/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.jdbc.SocketProfile;

public class TestSocketProfile {
    public String localhost = "localhost";

    @Test
    public void testAcceptsURL1() throws Exception {
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@mm://localhost:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@mm://localhost:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mms://localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@mms://localhost:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mms://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mms://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://127.0.0.1:1234;logLevel=2"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mms://127.0.0.1:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://127.0.0.1:1234,localhost.mydomain.com:63636;logLevel=2"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://my-host.mydomain.com:53535,127.0.0.1:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://123.123.123.123:53535,127.0.0.1:1234"));
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@localhost:1234") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@localhost:1234") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@c:/dqp.properties;version=1") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@/foo/dqp.properties;version=1") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@../foo/dqp.properties;version=1") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:jvdb@mm://localhost:port") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@localhost:port;version=x") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:teiid:@localhost:1234;stickyConnections=false;socketsPerVM=4") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://my_host.mydomain.com:53535,127.0.0.1:1234"));
    }

    @Test
    public void testAcceptsURL2() throws Exception {
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc:matamatrix:test") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"metamatrix:test") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc&matamatrix:test") ? 1 : 0) != 0);
        Assert.assertTrue((!SocketProfile.acceptsURL((String)"jdbc;metamatrix:test") ? 1 : 0) != 0);
    }

    @Test
    public void testParseURL() throws SQLException {
        Properties p = new Properties();
        SocketProfile.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234"));
        Assert.assertEquals((long)3L, (long)p.size());
    }

    @Test
    public void testParseURL2() throws SQLException {
        Properties p = new Properties();
        SocketProfile.parseURL((String)"jdbc:teiid:BQT@mms://slwxp157:1234;version=3", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mms://slwxp157:1234"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("ApplicationName").equals("JDBC"));
        Assert.assertEquals((long)5L, (long)p.size());
    }

    @Test
    public void testParseURL3() throws SQLException {
        Properties p = new Properties();
        SocketProfile.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302;version=4;autoCommitTxn=ON;partialResultsMode=YES;ApplicationName=Client", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        Assert.assertTrue((boolean)p.getProperty("autoCommitTxn").equals("ON"));
        Assert.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("4"));
        Assert.assertTrue((boolean)p.getProperty("ApplicationName").equals("Client"));
        Assert.assertEquals((long)7L, (long)p.size());
    }

    @Test
    public void testIPV6() throws SQLException {
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://[::1]:53535,127.0.0.1:1234"));
        Assert.assertTrue((boolean)SocketProfile.acceptsURL((String)"jdbc:teiid:vdb@mm://[3ffe:ffff:0100:f101::1]:53535,127.0.0.1:1234"));
        Properties p = new Properties();
        SocketProfile.parseURL((String)"jdbc:teiid:BQT@mms://[3ffe:ffff:0100:f101::1]:1234;version=3", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mms://[3ffe:ffff:0100:f101::1]:1234"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("3"));
    }

    @Test
    public void testIPV6MultipleHosts() throws SQLException {
        Properties p = new Properties();
        SocketProfile.parseURL((String)"jdbc:teiid:BQT@mms://[3ffe:ffff:0100:f101::1]:1234,[::1]:31000,127.0.0.1:2134;version=3", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mms://[3ffe:ffff:0100:f101::1]:1234,[::1]:31000,127.0.0.1:2134"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("3"));
    }
}

