/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.util.ReflectionHelper;

public class TestReflectionHelper
extends TestCase {
    public TestReflectionHelper(String name) {
        super(name);
    }

    private void helpAssertSameMethodSignature(String msg, Class[] signatureSought, Class[] signatureFound) {
        TestReflectionHelper.assertEquals((String)(msg + ": sizes differ."), (int)signatureSought.length, (int)signatureFound.length);
        for (int i = 0; i < signatureSought.length; ++i) {
            TestReflectionHelper.assertEquals((String)(msg + " for argument # " + (i + 1)), (Object)signatureSought[i], (Object)signatureFound[i]);
        }
    }

    public void testConstructorWithNullTargetClass() {
        try {
            new ReflectionHelper(null);
            TestReflectionHelper.fail((String)"Should have caught null target class passed to constructor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorWithValidTargetClass() {
        ReflectionHelper helper = new ReflectionHelper(String.class);
        TestReflectionHelper.assertNotNull((Object)helper);
    }

    public void testFindBestMethodWithSignature_String() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{String.class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_Serializable() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Serializable.class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_Object() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{NullPointerException.class};
        try {
            helper.findBestMethodWithSignature("method", signatureSought);
            TestReflectionHelper.fail((String)"exception expected");
        }
        catch (NoSuchMethodException e) {
            TestReflectionHelper.assertEquals((String)"method Args: [class java.lang.NullPointerException] has multiple possible signatures.", (String)e.getMessage());
        }
    }

    public void testFindBestMethodWithSignature_StringArray() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{String[].class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_Integer() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Integer.class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_long() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Long.TYPE};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_2ArgSerializableAndNumber() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Integer.class, Integer.class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class, Number.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_StringAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{String.class};
        Method theMethod = helper.findBestMethodWithSignature("methodString", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_ObjectAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{NullPointerException.class};
        Method theMethod = helper.findBestMethodWithSignature("methodObject", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Object.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_SerializableAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{NullPointerException.class};
        Method theMethod = helper.findBestMethodWithSignature("methodSerializable", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_ObjectSerializableAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{NullPointerException.class};
        Method theMethod = helper.findBestMethodWithSignature("methodSerializable", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_IntegerSerializableAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Integer.class};
        Method theMethod = helper.findBestMethodWithSignature("methodSerializable", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_StringArrayAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{String[].class};
        Method theMethod = helper.findBestMethodWithSignature("methodStringArray", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_ListAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{ArrayList.class};
        Method theMethod = helper.findBestMethodWithSignature("methodList", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{List.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_IntegerAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Integer.class};
        Method theMethod = helper.findBestMethodWithSignature("methodInteger", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_IntegerObjectAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Integer.class};
        Method theMethod = helper.findBestMethodWithSignature("methodObject", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Object.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_LongObjectAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Long.class};
        Method theMethod = helper.findBestMethodWithSignature("methodObject", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Object.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_longAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Long.TYPE};
        Method theMethod = helper.findBestMethodWithSignature("method_long", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_2ArgIntegerObjectAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Integer.class, Integer.class};
        Method theMethod = helper.findBestMethodWithSignature("twoArgMethod_Object_Object", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Object.class, Object.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_2ArgLongObjectAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Long.class, Long.class};
        Method theMethod = helper.findBestMethodWithSignature("twoArgMethod_Object_Object", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Object.class, Object.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_2ArgSerializableNumberAndMethodName() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeInterface.class);
        Object[] signatureSought = new Class[]{Long.class, Long.class};
        Method theMethod = helper.findBestMethodWithSignature("twoArgMethod_Serializable_Number", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class, Number.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_SubInterface_2ArgSerializableAndNumber() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeSubInterface.class);
        Object[] signatureSought = new Class[]{Serializable.class, Number.class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Object[] signatureExpected = signatureSought;
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeSubInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", (Class[])signatureExpected, signatureFound);
    }

    public void testFindBestMethodWithSignature_SubInterface_2ArgSerializableAndLong() throws Exception {
        ReflectionHelper helper = new ReflectionHelper(FakeSubInterface.class);
        Object[] signatureSought = new Class[]{Serializable.class, Long.class};
        Method theMethod = helper.findBestMethodWithSignature("method", signatureSought);
        TestReflectionHelper.assertNotNull((String)("Failed to find method for args: " + signatureSought), (Object)theMethod);
        Class[] signatureFound = theMethod.getParameterTypes();
        Class[] signatureExpected = new Class[]{Serializable.class, Long.class};
        TestReflectionHelper.assertEquals((String)"Wrong class", (String)theMethod.getDeclaringClass().getName(), (String)FakeSubInterface.class.getName());
        this.helpAssertSameMethodSignature("Found wrong method signature", signatureExpected, signatureFound);
    }

    public static interface FakeSubInterface
    extends FakeInterface {
        public void method(Number var1, Long var2);

        @Override
        public void method(Serializable var1, Number var2);

        public void method(Serializable var1, Long var2);
    }

    public static interface FakeInterface {
        public void method(String var1);

        public void method(Serializable var1);

        public void method(Object var1);

        public void method(String[] var1);

        public void method(List var1);

        public void method(Integer var1);

        public void method(long var1);

        public void method(Serializable var1, Number var2);

        public void methodString(String var1);

        public void methodSerializable(Serializable var1);

        public void methodObject(Object var1);

        public void methodStringArray(String[] var1);

        public void methodList(List var1);

        public void methodInteger(Integer var1);

        public void method_long(long var1);

        public void twoArgMethod_Object_Object(Object var1, Object var2);

        public void twoArgMethod_Serializable_Number(Serializable var1, Number var2);
    }
}

