/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.regex.Pattern;
import org.teiid.core.util.ArgCheck;

public class SqlUtil {
    public static final char CR_CHAR = '\r';
    public static final char NL_CHAR = '\n';
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    private static Pattern PATTERN = Pattern.compile("^([\\s]|(/\\*.*\\*/))*(insert|update|delete|create|drop|(select([\\s]|(/\\*.*\\*/))+.*into([\\s]|(/\\*.*\\*/))+)).*", 10);

    private SqlUtil() {
    }

    public static boolean isUpdateSql(String sql) throws IllegalArgumentException {
        ArgCheck.isNotNull(sql);
        return PATTERN.matcher(sql).matches();
    }

    public static SQLException createFeatureNotSupportedException() {
        return new SQLFeatureNotSupportedException();
    }
}

