/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.h2.H2ExecutionFactory;

public class TestRelate {
    private static boolean writeResults = false;
    private static boolean DEBUG = false;
    private static FakeServer server;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        server = new FakeServer();
        JdbcDataSource h2ds = new JdbcDataSource();
        h2ds.setURL("jdbc:h2:zip:src/test/resources/relate/test.zip!/test");
        JdbcConnectionPool ds = JdbcConnectionPool.create((ConnectionPoolDataSource)h2ds);
        H2ExecutionFactory h2 = new H2ExecutionFactory();
        h2.start();
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        ConnectorManager cm = new ConnectorManager("source", "bar", (DataSource)ds){
            final /* synthetic */ DataSource val$ds;
            {
                this.val$ds = dataSource;
                super(x0, x1);
            }

            protected Object getConnectionFactory() throws TranslatorException {
                return this.val$ds;
            }
        };
        cm.setExecutionFactory((ExecutionFactory)h2);
        cmr.addConnectorManager("source", cm);
        server.setConnectorManagerRepository(cmr);
        server.deployVDB("VehicleRentalsVDB", UnitTestUtil.getTestDataPath() + "/relate/VehicleRentalsVDB.vdb");
        if (DEBUG) {
            Logger logger = Logger.getLogger("org.teiid");
            logger.setLevel(Level.FINER);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(Level.FINER);
            logger.addHandler(handler);
        }
    }

    private void compareResults(SQLXML[] docs) throws SQLException, IOException {
        StackTraceElement ste = new Exception().getStackTrace()[1];
        String testName = ste.getMethodName();
        testName = "relate/" + testName;
        File actual = new File(UnitTestUtil.getTestDataPath() + "/" + testName + ".expected");
        if (writeResults) {
            PrintWriter writer = new PrintWriter(actual);
            for (SQLXML xml : docs) {
                writer.write(xml.getString());
                writer.write(10);
            }
            writer.close();
            return;
        }
        BufferedReader br = new BufferedReader(new FileReader(actual));
        for (int i = 0; i < docs.length; ++i) {
            Assert.assertEquals((Object)br.readLine(), (Object)docs[i].getString());
        }
    }

    @Test
    public void testCase3365() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, null, null, null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testCase3365_crit() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, "company.companyid = 'CID1'", null, null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testCase3365_critNestedSrc() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, "location = 'Pittsburgh'", null, null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testCase3365_critNestedSrcContext() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, null, null, null, null, "context(location, location) = 'Pittsburgh'", null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testCase3365_critNestedSrcCombinationContext() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, "location = 'Pittsburgh'", null, null, null, "context(location, location) = 'Pittsburgh'", null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testCase3365_critNestedTgt() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, null, "color = 'Black'", null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testCase3365_compoundCritNestedTgt() throws Exception {
        SQLXML[] docs = this.relate(false, null, null, null, "rentals.rentsVehicle", "rentals.company", "rentals.vehicle", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.rentsVehicle.companyId", "rentals.rentsVehicle.vehicleId", "'*:rentals/*:rentsVehicle/@vehicleID'", "STRING", "rentals.vehicle.vehicleId", "VehicleRentalsDoc.rentalsDocumentWithLocation", null, null, "color='Black' or color='Puce'", null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testSharesDoc() throws Exception {
        SQLXML[] docs = this.relate(true, null, null, null, "rentals.hasSharingAgreement", "rentals.company", "rentals.company", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.hasSharingAgreement.primaryPartyID", "rentals.hasSharingAgreement.secondaryPartyID", "'*:rentals/*:hasSharingAgreement/@secondaryPartyID'", "STRING", "rentals.company.companyId", "VehicleRentalsDoc.companiesDocument", null, null, null, null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testSharesDocWithCritTgt() throws Exception {
        SQLXML[] docs = this.relate(true, null, null, null, "rentals.hasSharingAgreement", "rentals.company", "rentals.company", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.hasSharingAgreement.primaryPartyID", "rentals.hasSharingAgreement.secondaryPartyID", "'*:rentals/*:hasSharingAgreement/@secondaryPartyID'", "STRING", "rentals.company.companyId", "VehicleRentalsDoc.companiesDocument", null, null, "rentals.company.name like 'B%'", null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testSharesDocWithCritTgtContext() throws Exception {
        SQLXML[] docs = this.relate(true, null, null, null, "rentals.hasSharingAgreement", "rentals.company", "rentals.company", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.hasSharingAgreement.primaryPartyID", "rentals.hasSharingAgreement.secondaryPartyID", "'*:rentals/*:hasSharingAgreement/@secondaryPartyID'", "STRING", "rentals.company.companyId", "VehicleRentalsDoc.companiesDocument", null, null, "rentals.company.name like 'B%'", "rentals.company.name like 'B%'", null, null, null, null, null, null);
        this.compareResults(docs);
    }

    @Test
    public void testSharesDocEspaceQuestion3() throws Exception {
        SQLXML[] docs = this.relate(true, null, null, null, "rentals.hasSharingAgreement", "rentals.company", "rentals.company", "rentals.company.companyId", "'*:rentals/*:company/@companyID'", "STRING", "rentals.hasSharingAgreement.primaryPartyID", "rentals.hasSharingAgreement.secondaryPartyID", "'*:rentals/*:hasSharingAgreement/@secondaryPartyID'", "STRING", "rentals.company.companyId", "VehicleRentalsDoc.companiesDocument", null, "company.locations.location = 'Pittsburgh'", null, null, null, null, null, null, null, null);
        this.compareResults(docs);
    }

    public SQLXML[] relate(boolean distinct, String relationshipSelect, String sourceSelect, String targetSelect, String relationshipContext, String sourceContext, String targetContext, String sourceKey, String sourceKeyPath, String sourceKeyType, String sourceFKey, String targetFKey, String targetFKeyPath, String targetFKeyType, String targetKey, String xmlDocument, String relationshipCriteria, String relateSourceCriteria, String relateTargetCriteria, String relateTargetContextCriteria, String relationshipContextCriteria, String sourceContextCriteria, String targetContextCriteria, String relationshipOrderBy, String sourceOrderBy, String targetOrderBy) throws Exception {
        SQLXML targetXml;
        SQLXML relXml;
        SQLXML sourceXml;
        if (sourceSelect == null) {
            sourceSelect = sourceContext + ".*";
        }
        if (relationshipSelect == null) {
            relationshipSelect = relationshipContext + ".*";
        }
        if (targetSelect == null) {
            targetSelect = targetContext + ".*";
        }
        ConnectionImpl conn = server.createConnection("jdbc:teiid:VehicleRentalsVDB");
        if (DEBUG) {
            conn.createStatement().execute("SET SHOWPLAN DEBUG");
        }
        SQLXML[] result = new SQLXML[3];
        String query = String.format("SELECT %s FROM %s WHERE CONTEXT(%s, %s) IN (SELECT %s FROM %s WHERE %s IN (SELECT %s FROM %s", sourceSelect, xmlDocument, sourceContext, sourceKey, sourceFKey, relationshipContext, targetFKey, targetKey, targetContext);
        if (relateTargetCriteria != null) {
            query = query + " WHERE " + relateTargetCriteria;
        }
        query = query + "))";
        if (relateSourceCriteria != null) {
            query = query + String.format(" AND (CONTEXT(%s, %s) = null OR %s)", sourceContext, sourceKey, relateSourceCriteria);
        }
        if (relationshipCriteria != null) {
            query = query + String.format(" AND CONTEXT(%s, %s) IN (SELECT %s FROM %s WHERE AND %s)", sourceContext, sourceKey, sourceFKey, relationshipContext, relationshipCriteria);
        }
        if (sourceContextCriteria != null) {
            query = query + " AND " + sourceContextCriteria;
        }
        if (sourceOrderBy != null) {
            query = query + " ORDER BY " + sourceOrderBy;
        }
        PreparedStatement sourcePs = conn.prepareStatement(query);
        ResultSet sourceRs = sourcePs.executeQuery();
        sourceRs.next();
        result[0] = sourceXml = sourceRs.getSQLXML(1);
        Statement ddlStmt = conn.createStatement();
        ddlStmt.execute("CREATE LOCAL TEMPORARY TABLE #st_source (source_key STRING, PRIMARY KEY (source_key))");
        String sourceStagingQuery = String.format("INSERT INTO #st_source (source_key) SELECT DISTINCT source_key FROM XMLTABLE(%s PASSING cast(? AS xml) COLUMNS source_key %s PATH '.') x", sourceKeyPath, sourceKeyType);
        PreparedStatement ps = conn.prepareStatement(sourceStagingQuery);
        ps.setSQLXML(1, sourceXml);
        ps.execute();
        ps.close();
        String relQuery = String.format("SELECT %s FROM %s WHERE CONTEXT(%s, %s) IN /*+ DJ */ (SELECT source_key from #st_source) AND CONTEXT(%s, %s) IN (SELECT %s FROM %s", relationshipSelect, xmlDocument, relationshipContext, sourceFKey, relationshipContext, targetFKey, targetKey, targetContext);
        if (relateTargetContextCriteria != null) {
            relQuery = relQuery + " WHERE " + relateTargetContextCriteria;
        }
        relQuery = relQuery + ")";
        if (relationshipCriteria != null) {
            relQuery = relQuery + String.format(" AND (CONTEXT(%s, %s) = null OR %s)", relationshipContext, sourceFKey, relationshipCriteria);
        }
        if (relationshipContextCriteria != null) {
            relQuery = relQuery + " AND " + relationshipContextCriteria;
        }
        if (relationshipOrderBy != null) {
            relQuery = relQuery + " ORDER BY " + relationshipOrderBy;
        }
        PreparedStatement relStmt = conn.prepareStatement(relQuery);
        ResultSet relRs = relStmt.executeQuery();
        relRs.next();
        result[1] = relXml = relRs.getSQLXML(1);
        ddlStmt.execute("CREATE LOCAL TEMPORARY TABLE #st_rel (target_key STRING, PRIMARY KEY (target_key))");
        String relStagingQuery = String.format("INSERT INTO #st_rel (target_key) SELECT DISTINCT target_key FROM XMLTABLE(%s PASSING cast(? AS xml) COLUMNS target_key %s PATH '.') x", targetFKeyPath, targetFKeyType);
        PreparedStatement psRel = conn.prepareStatement(relStagingQuery);
        psRel.setSQLXML(1, relXml);
        psRel.execute();
        psRel.close();
        String targetQuery = String.format("SELECT %s FROM %s WHERE CONTEXT(%s, %s) IN /*+ DJ */ (SELECT target_key FROM #st_rel", targetSelect, xmlDocument, targetContext, targetKey);
        if (distinct && targetContext.equalsIgnoreCase(sourceContext)) {
            targetQuery = targetQuery + " EXCEPT SELECT source_key FROM #st_source";
        }
        targetQuery = targetQuery + ")";
        if (targetContextCriteria != null) {
            targetQuery = targetQuery + " AND " + targetContextCriteria;
        }
        if (targetOrderBy != null) {
            targetQuery = targetQuery + " ORDER BY " + targetOrderBy;
        }
        PreparedStatement targetStmt = conn.prepareStatement(targetQuery);
        ResultSet taretRs = targetStmt.executeQuery();
        taretRs.next();
        result[2] = targetXml = taretRs.getSQLXML(1);
        ddlStmt.execute("drop table #st_source");
        ddlStmt.execute("drop table #st_rel");
        return result;
    }
}

