/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.TeiidComponentException;

public class BufferManagerFactory {
    private static BufferManager INSTANCE;

    public static BufferManager getStandaloneBufferManager() {
        if (INSTANCE == null) {
            BufferManagerImpl bufferMgr = BufferManagerFactory.createBufferManager();
            INSTANCE = bufferMgr;
        }
        return INSTANCE;
    }

    public static BufferManagerImpl createBufferManager() {
        return BufferManagerFactory.initBufferManager(new BufferManagerImpl());
    }

    public static BufferManagerImpl getTestBufferManager(long bytesAvailable, int procBatchSize, int connectorBatchSize) {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setProcessorBatchSize(procBatchSize);
        bufferManager.setConnectorBatchSize(connectorBatchSize);
        bufferManager.setMaxProcessingKB((int)(bytesAvailable / 1024L));
        bufferManager.setMaxReserveKB((int)(bytesAvailable / 1024L));
        return BufferManagerFactory.initBufferManager(bufferManager);
    }

    public static BufferManagerImpl getTestBufferManager(long bytesAvailable, int procBatchSize) {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setProcessorBatchSize(procBatchSize);
        bufferManager.setMaxProcessingKB((int)(bytesAvailable / 1024L));
        bufferManager.setMaxReserveKB((int)(bytesAvailable / 1024L));
        return BufferManagerFactory.initBufferManager(bufferManager);
    }

    public static BufferManagerImpl initBufferManager(BufferManagerImpl bufferManager) {
        try {
            bufferManager.initialize();
        }
        catch (TeiidComponentException e) {
            throw new RuntimeException(e);
        }
        bufferManager.setStorageManager((StorageManager)new MemoryStorageManager());
        return bufferManager;
    }
}

