/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestSTree {
    @Test
    public void testRemoveAll() throws TeiidComponentException {
        int i;
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        ElementSymbol e1 = new ElementSymbol("x");
        e1.setType(Integer.class);
        ElementSymbol e2 = new ElementSymbol("y");
        e2.setType(String.class);
        List<ElementSymbol> elements = Arrays.asList(e1, e2);
        STree map = bm.createSTree(elements, "1", 1);
        for (i = 20000; i > 0; --i) {
            Assert.assertNull((Object)map.insert(Arrays.asList(i, String.valueOf(i)), STree.InsertMode.NEW, -1));
            Assert.assertEquals((long)(20000 - i + 1), (long)map.getRowCount());
        }
        for (i = 20000; i > 0; --i) {
            Assert.assertNotNull((String)String.valueOf(i), (Object)map.remove(Arrays.asList(i)));
        }
        Assert.assertEquals((long)0L, (long)map.getRowCount());
        Assert.assertNull((Object)map.insert(Arrays.asList(1, String.valueOf(1)), STree.InsertMode.NEW, -1));
    }

    @Test
    public void testUnOrderedInsert() throws TeiidComponentException {
        BufferManagerImpl bm = BufferManagerFactory.createBufferManager();
        bm.setProcessorBatchSize(16);
        ElementSymbol e1 = new ElementSymbol("x");
        e1.setType(Integer.class);
        List<ElementSymbol> elements = Arrays.asList(e1);
        STree map = bm.createSTree(elements, "1", 1);
        int size = 65553;
        int logSize = map.getExpectedHeight(size);
        for (int i = 0; i < size; ++i) {
            Assert.assertNull((Object)map.insert(Arrays.asList(i), STree.InsertMode.NEW, logSize));
            Assert.assertEquals((long)(i + 1), (long)map.getRowCount());
        }
        Assert.assertTrue((5 >= map.getHeight() ? 1 : 0) != 0);
    }

    @Test
    public void testOrderedInsert() throws TeiidComponentException {
        int i;
        BufferManagerImpl bm = BufferManagerFactory.createBufferManager();
        bm.setProcessorBatchSize(16);
        ElementSymbol e1 = new ElementSymbol("x");
        e1.setType(Integer.class);
        List<ElementSymbol> elements = Arrays.asList(e1);
        STree map = bm.createSTree(elements, "1", 1);
        int size = 65553;
        for (i = 0; i < size; ++i) {
            Assert.assertNull((Object)map.insert(Arrays.asList(i), STree.InsertMode.ORDERED, size));
            Assert.assertEquals((long)(i + 1), (long)map.getRowCount());
        }
        Assert.assertEquals((long)4L, (long)map.getHeight());
        for (i = 0; i < size; ++i) {
            Assert.assertNotNull((Object)map.remove(Arrays.asList(i)));
        }
    }
}

