/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.jboss.virtual.VirtualFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;

public class TestMetadataFactory {
    private static final String MY_RESOURCE_PATH = "my/resource/path";
    private RuntimeMetadataImpl metadataFactory;

    @Before
    public void setUp() throws IOException {
        MetadataStore metadataStore = new MetadataStore();
        CompositeMetadataStore store = new CompositeMetadataStore(metadataStore);
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName("foo");
        vdbMetaData.setVersion(1);
        LinkedHashMap<String, TransformationMetadata.Resource> vdbEntries = new LinkedHashMap<String, TransformationMetadata.Resource>();
        VirtualFile vf = (VirtualFile)Mockito.mock(VirtualFile.class);
        Mockito.stub((Object)vf.openStream()).toReturn((Object)new ByteArrayInputStream("ResourceContents".getBytes()));
        vdbEntries.put(MY_RESOURCE_PATH, new TransformationMetadata.Resource(vf, true));
        this.metadataFactory = new RuntimeMetadataImpl((QueryMetadataInterface)new TransformationMetadata(vdbMetaData, store, vdbEntries, null, null));
    }

    @Test
    public void testGetVDBResourcePaths() throws Exception {
        String[] expectedPaths = new String[]{MY_RESOURCE_PATH};
        String[] mfPaths = this.metadataFactory.getVDBResourcePaths();
        Assert.assertEquals((long)expectedPaths.length, (long)mfPaths.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assert.assertEquals((Object)expectedPaths[i], (Object)mfPaths[i]);
        }
    }

    @Test
    public void testGetBinaryVDBResource() throws Exception {
        byte[] expectedBytes = "ResourceContents".getBytes();
        byte[] mfBytes = this.metadataFactory.getBinaryVDBResource(MY_RESOURCE_PATH);
        Assert.assertEquals((long)expectedBytes.length, (long)mfBytes.length);
        for (int i = 0; i < expectedBytes.length; ++i) {
            Assert.assertEquals((String)("Byte at index " + i + " differs from expected content"), (long)expectedBytes[i], (long)mfBytes[i]);
        }
    }

    @Test
    public void testGetCharacterVDBResource() throws Exception {
        Assert.assertEquals((Object)"ResourceContents", (Object)this.metadataFactory.getCharacterVDBResource(MY_RESOURCE_PATH));
    }
}

