/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import org.junit.Test;
import org.teiid.metadata.Table;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TestParser;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestParseAlter {
    @Test
    public void testAlterView() throws Exception {
        AlterView alterView = new AlterView();
        alterView.setTarget(new GroupSymbol("x"));
        alterView.setDefinition((Command)((QueryCommand)QueryParser.getQueryParser().parseCommand("/*+ cache */ SELECT 1")));
        TestParser.helpTest("alter view x as /*+ cache */ select 1", "ALTER VIEW x AS\n/*+ cache */ SELECT 1", (Command)alterView);
    }

    @Test
    public void testAlterProc() throws Exception {
        AlterView alterView = new AlterView();
        alterView.setTarget(new GroupSymbol("x"));
        alterView.setDefinition((Command)((QueryCommand)QueryParser.getQueryParser().parseCommand("/*+ cache */ SELECT 1")));
        TestParser.helpTest("alter view x as /*+ cache */ select 1", "ALTER VIEW x AS\n/*+ cache */ SELECT 1", (Command)alterView);
    }

    @Test
    public void testAlterTrigger() throws Exception {
        AlterTrigger alterTrigger = new AlterTrigger();
        alterTrigger.setTarget(new GroupSymbol("x"));
        alterTrigger.setEvent(Table.TriggerEvent.UPDATE);
        alterTrigger.setDefinition((Command)((TriggerAction)QueryParser.getQueryParser().parseUpdateProcedure("for each row begin end")));
        TestParser.helpTest("alter trigger on x instead of update as for each row begin end", "ALTER TRIGGER ON x INSTEAD OF UPDATE AS\nFOR EACH ROW\nBEGIN\nEND", (Command)alterTrigger);
    }

    @Test
    public void testAlterDisabled() throws Exception {
        AlterTrigger alterTrigger = new AlterTrigger();
        alterTrigger.setTarget(new GroupSymbol("x"));
        alterTrigger.setEvent(Table.TriggerEvent.UPDATE);
        alterTrigger.setEnabled(Boolean.valueOf(false));
        TestParser.helpTest("alter trigger on x instead of update disabled", "ALTER TRIGGER ON x INSTEAD OF UPDATE DISABLED", (Command)alterTrigger);
    }

    @Test
    public void testCreateTrigger() throws Exception {
        AlterTrigger alterTrigger = new AlterTrigger();
        alterTrigger.setCreate(true);
        alterTrigger.setTarget(new GroupSymbol("x"));
        alterTrigger.setEvent(Table.TriggerEvent.UPDATE);
        alterTrigger.setDefinition((Command)((TriggerAction)QueryParser.getQueryParser().parseUpdateProcedure("for each row begin end")));
        TestParser.helpTest("create trigger on x instead of update as for each row begin end", "CREATE TRIGGER ON x INSTEAD OF UPDATE AS\nFOR EACH ROW\nBEGIN\nEND", (Command)alterTrigger);
    }
}

