/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.TestValidator;

public class TestVirtualDepJoin {
    private static void setStats(List<Column> elementObjects, int[] ndvs, int[] nnvs, String[] mins, String[] maxs) {
        for (int i = 0; i < elementObjects.size(); ++i) {
            Column obj = elementObjects.get(i);
            if (ndvs != null) {
                obj.setDistinctValues(ndvs[i]);
            }
            if (nnvs != null) {
                obj.setNullValues(nnvs[i]);
            }
            if (mins != null) {
                obj.setMinimumValue(mins[i]);
            }
            if (maxs == null) continue;
            obj.setMaximumValue(maxs[i]);
        }
    }

    public static TransformationMetadata exampleVirtualDepJoin() {
        MetadataStore metadataStore = new MetadataStore();
        Schema us = RealMetadataFactory.createPhysicalModel("US", metadataStore);
        Table usAccts = RealMetadataFactory.createPhysicalGroup("Accounts", us);
        usAccts.setCardinality(1000000);
        List<Column> usAcctsElem = RealMetadataFactory.createElements(usAccts, new String[]{"customer", "account", "txn", "txnid", "pennies"}, new String[]{"long", "integer", "string", "integer", "integer"});
        TestVirtualDepJoin.setStats(usAcctsElem, new int[]{1000, 1250, 4, 1000000, 800000}, new int[]{0, 0, 0, 0, 0}, new String[]{"0", null, null, null, "-10"}, new String[]{"1000", null, null, null, "-5"});
        Schema europe = RealMetadataFactory.createPhysicalModel("Europe", metadataStore);
        Table euAccts = RealMetadataFactory.createPhysicalGroup("CustAccts", europe);
        euAccts.setCardinality(1000000);
        List<Column> euAcctsElem = RealMetadataFactory.createElements(euAccts, new String[]{"id", "accid", "type", "amount"}, new String[]{"long", "long", "short", "bigdecimal"});
        TestVirtualDepJoin.setStats(euAcctsElem, new int[]{10000, 1000000, 4, 1000000, 750000}, new int[]{0, 0, 0, 0, 0}, null, null);
        Schema cust = RealMetadataFactory.createPhysicalModel("CustomerMaster", metadataStore);
        Table customers = RealMetadataFactory.createPhysicalGroup("Customers", cust);
        customers.setCardinality(1000);
        List<Column> customersElem = RealMetadataFactory.createElements(customers, new String[]{"id", "first", "last", "birthday"}, new String[]{"long", "string", "string", "date"});
        TestVirtualDepJoin.setStats(customersElem, new int[]{1000, 800, 800, 365}, new int[]{0, 0, 0, 0}, null, null);
        Table locations = RealMetadataFactory.createPhysicalGroup("Locations", cust);
        locations.setCardinality(1200);
        List<Column> locationsElem = RealMetadataFactory.createElements(locations, new String[]{"id", "location"}, new String[]{"long", "string"});
        TestVirtualDepJoin.setStats(locationsElem, new int[]{1000, 2}, new int[]{0, 0, 0, 0}, null, null);
        Schema vAccts = RealMetadataFactory.createVirtualModel("Accounts", metadataStore);
        QueryNode accountsPlan = new QueryNode("SELECT customer as customer_id, convert(account, long) as account_id, convert(txnid, long) as transaction_id, case txn when 'DEP' then 1 when 'TFR' then 2 when 'WD' then 3 else -1 end as txn_type, (pennies + convert('0.00', bigdecimal)) / 100 as amount, 'US' as source FROM US.Accounts where txn != 'X'UNION ALL SELECT id, convert(accid / 10000, long), mod(accid, 10000), convert(type, integer), amount, 'EU' from Europe.CustAccts");
        Table accounts = RealMetadataFactory.createVirtualGroup("Accounts", vAccts, accountsPlan);
        RealMetadataFactory.createElements(accounts, new String[]{"customer_id", "account_id", "transaction_id", "txn_type", "amount", "source"}, new String[]{"long", "long", "long", "integer", "bigdecimal", "string"});
        Schema master = RealMetadataFactory.createVirtualModel("Master", metadataStore);
        QueryNode masterPlan = new QueryNode("select id as CustomerID, First, Last, a.account_id as AccountID, transaction_id as TransactionID, txn_type AS TxnCode, Amount from CustomerMaster.Customers c, Accounts.Accounts a where c.id=a.customer_id");
        Table transactions = RealMetadataFactory.createVirtualGroup("Transactions", master, masterPlan);
        RealMetadataFactory.createElements(transactions, new String[]{"CustomerID", "First", "Last", "AccountID", "TransactionID", "TxnCode", "Amount"}, new String[]{"long", "string", "string", "long", "long", "integer", "bigdecimal"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "virtualDepJoin", new FunctionTree[0]);
    }

    @Test
    public void testVirtualDepJoinNoValues() throws Exception {
        String sql = "select first, last, sum(amount) from Europe.CustAccts e join CustomerMaster.Customers c on c.id=e.id where c.first=-9999 group by c.id, first, last";
        List[] expected = new List[]{};
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        finder.addCapabilities("Europe", (SourceCapabilities)caps);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, finder, context);
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
        Assert.assertEquals((long)3L, (long)dataManager.getQueries().size());
    }

    public void helpTestVirtualDepJoinSourceSelection(boolean setPushdown) throws Exception {
        String sql = "select c.id as CustomerID, First, Last, a.account_id as AccountID, transaction_id as TransactionID, txn_type AS TxnCode, Amount, source from (CustomerMaster.Customers c join CustomerMaster.Locations l on c.id=l.id) join Accounts.Accounts a on c.id=a.customer_id and l.location=a.source where c.first='Miles' order by accountid option makenotdep c, l";
        List[] expected = new List[]{Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1002L), new Integer(1), new BigDecimal("7.20"), "EU"), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1003L), new Integer(2), new BigDecimal("1000.00"), "EU"), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(123L), new Integer(1), new BigDecimal("100.00"), "US"), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(127L), new Integer(2), new BigDecimal("250.00"), "US"), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(128L), new Integer(3), new BigDecimal("1000.00"), "US"), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(134L), new Integer(1), new BigDecimal("10.00"), "US"), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(201L), new Integer(1), new BigDecimal("10.00"), "US")};
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, setPushdown);
        finder.addCapabilities("US", (SourceCapabilities)caps);
        finder.addCapabilities("Europe", (SourceCapabilities)caps);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, finder, context);
        int selectCount = !setPushdown ? 3 : 0;
        int accessCount = setPushdown ? 1 : 4;
        int depAccessCount = 4 - accessCount;
        TestOptimizer.checkNodeTypes(plan, new int[]{accessCount, depAccessCount, 0, 0, 0, 0, 0, 2, 0, 0, 3, selectCount, 1, 1});
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testVirtualDepJoinSourceSelectionPushdown() throws Exception {
        this.helpTestVirtualDepJoinSourceSelection(true);
    }

    @Test
    public void testVirtualDepJoinSourceSelectionNoPushdown() throws Exception {
        this.helpTestVirtualDepJoinSourceSelection(false);
    }

    @Test
    public void testVirtualDepJoinPartialPushdown() throws Exception {
        String sql = "SELECT * from Master.Transactions where last = 'Davis'";
        List[] expected = new List[]{Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(123L), new Integer(1), new BigDecimal("100.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(127L), new Integer(2), new BigDecimal("250.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(128L), new Integer(3), new BigDecimal("1000.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(134L), new Integer(1), new BigDecimal("10.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(201L), new Integer(1), new BigDecimal("10.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1002L), new Integer(1), new BigDecimal("7.20")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1003L), new Integer(2), new BigDecimal("1000.00"))};
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps1 = TestOptimizer.getTypicalCapabilities();
        BasicSourceCapabilities caps2 = TestOptimizer.getTypicalCapabilities();
        caps2.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, false);
        finder.addCapabilities("US", (SourceCapabilities)caps1);
        finder.addCapabilities("Europe", (SourceCapabilities)caps2);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps1);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, finder, context);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 0, 0, 1, 0, 0, 3, 1, 0, 1});
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testVirtualDepJoinOverAggregates() throws Exception {
        String sql = "select first, last, sum(amount) from Europe.CustAccts e join CustomerMaster.Customers c on c.id=e.id where c.first='Miles' group by c.id, first, last";
        List[] expected = new List[]{Arrays.asList("Miles", "Davis", new BigDecimal("1007.20"))};
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        finder.addCapabilities("Europe", (SourceCapabilities)caps);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, finder, context);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
        ArrayList<String> expectedQueries = new ArrayList<String>(6);
        for (int i = 0; i < 3; ++i) {
            expectedQueries.add("SELECT g_0.id AS c_0, g_0.first AS c_1, g_0.last AS c_2 FROM CustomerMaster.Customers AS g_0 WHERE g_0.first = 'Miles' ORDER BY c_0");
            expectedQueries.add("SELECT g_0.id, g_0.amount FROM Europe.CustAccts AS g_0 WHERE g_0.id = 100");
        }
        Assert.assertEquals(expectedQueries, dataManager.getQueries());
    }

    @Test
    public void testVirtualDepJoinSelects() throws Exception {
        this.helpTestVirtualDepJoin(false);
    }

    @Test
    public void testVirtualDepJoinPushdown() throws Exception {
        this.helpTestVirtualDepJoin(true);
    }

    @Test
    public void testVirtualDepMultipleDependentBatches() throws Exception {
        this.helpTestMultipleBatches(true);
    }

    @Test
    public void testVirtualDepMultipleDependentBatchesNonUnique() throws Exception {
        this.helpTestMultipleBatches(false);
    }

    private void helpTestMultipleBatches(boolean unique) throws Exception, TeiidComponentException, TeiidException, SQLException {
        String sql = "SELECT * from Master.Transactions where last = 'Davis' order by CustomerID, TransactionID";
        LinkedList<List<Object>> expected = new LinkedList<List<Object>>();
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(123L), new Integer(1), new BigDecimal("100.00")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(123L), new Integer(1), new BigDecimal("100.00")));
        }
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(127L), new Integer(2), new BigDecimal("250.00")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(127L), new Integer(2), new BigDecimal("250.00")));
        }
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(128L), new Integer(3), new BigDecimal("1000.00")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(128L), new Integer(3), new BigDecimal("1000.00")));
        }
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(134L), new Integer(1), new BigDecimal("10.00")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(134L), new Integer(1), new BigDecimal("10.00")));
        }
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(201L), new Integer(1), new BigDecimal("10.00")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(201L), new Integer(1), new BigDecimal("10.00")));
        }
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1002L), new Integer(1), new BigDecimal("7.20")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1002L), new Integer(1), new BigDecimal("7.20")));
        }
        expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1003L), new Integer(2), new BigDecimal("1000.00")));
        if (!unique) {
            expected.add(Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1003L), new Integer(2), new BigDecimal("1000.00")));
        }
        expected.add(Arrays.asList(new Long(200L), "CloneA", "Davis", new Long(16000L), new Long(207L), new Integer(3), new BigDecimal("12.34")));
        expected.add(Arrays.asList(new Long(200L), "CloneA", "Davis", new Long(16000L), new Long(299L), new Integer(3), new BigDecimal("950.34")));
        expected.add(Arrays.asList(new Long(200L), "CloneA", "Davis", new Long(550L), new Long(1004L), new Integer(3), new BigDecimal("542.20")));
        expected.add(Arrays.asList(new Long(200L), "CloneA", "Davis", new Long(550L), new Long(1005L), new Integer(1), new BigDecimal("99.99")));
        expected.add(Arrays.asList(new Long(300L), "CloneB", "Davis", new Long(620L), new Long(1006L), new Integer(1), new BigDecimal("10000.00")));
        expected.add(Arrays.asList(new Long(300L), "CloneB", "Davis", new Long(620L), new Long(1007L), new Integer(2), new BigDecimal("0.75")));
        expected.add(Arrays.asList(new Long(300L), "CloneB", "Davis", new Long(630L), new Long(1008L), new Integer(2), new BigDecimal("62.00")));
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        this.overrideVirtualDepJoinData(dataManager, (QueryMetadataInterface)metadata, unique);
        CommandContext context = TestProcessor.createCommandContext();
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        finder.addCapabilities("US", (SourceCapabilities)caps);
        finder.addCapabilities("Europe", (SourceCapabilities)caps);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, finder, context);
        BufferManager bufferMgr = this.createCustomBufferMgr(2);
        QueryProcessor processor = new QueryProcessor(plan, context, bufferMgr, (ProcessorDataManager)dataManager);
        processor.setNonBlocking(true);
        BatchCollector collector = processor.createBatchCollector();
        TupleBuffer id = collector.collectTuples();
        TestProcessor.examineResults(expected.toArray(new List[expected.size()]), bufferMgr, id);
    }

    private BufferManager createCustomBufferMgr(int batchSize) throws TeiidComponentException {
        BufferManagerImpl bufferMgr = new BufferManagerImpl();
        bufferMgr.setConnectorBatchSize(batchSize);
        bufferMgr.setProcessorBatchSize(batchSize);
        bufferMgr.initialize();
        bufferMgr.setStorageManager((StorageManager)new MemoryStorageManager());
        return bufferMgr;
    }

    public void helpTestVirtualDepJoin(boolean pushCriteria) throws Exception {
        String sql = "SELECT * from Master.Transactions where last = 'Davis'";
        List[] expected = new List[]{Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(123L), new Integer(1), new BigDecimal("100.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(127L), new Integer(2), new BigDecimal("250.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15000L), new Long(128L), new Integer(3), new BigDecimal("1000.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(134L), new Integer(1), new BigDecimal("10.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(15001L), new Long(201L), new Integer(1), new BigDecimal("10.00")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1002L), new Integer(1), new BigDecimal("7.20")), Arrays.asList(new Long(100L), "Miles", "Davis", new Long(540L), new Long(1003L), new Integer(2), new BigDecimal("1000.00"))};
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, pushCriteria);
        finder.addCapabilities("US", (SourceCapabilities)caps);
        finder.addCapabilities("Europe", (SourceCapabilities)caps);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        CommandContext context = TestProcessor.createCommandContext();
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    private void sampleDataVirtualDepJoin(FakeDataManager dataMgr, QueryMetadataInterface metadata) throws Exception {
        dataMgr.setBlockOnce();
        dataMgr.registerTuples(metadata, "US.Accounts", new List[]{Arrays.asList(new Long(100L), new Integer(15000), "DEP", new Integer(123), new Integer(10000)), Arrays.asList(new Long(100L), new Integer(15000), "TFR", new Integer(127), new Integer(25000)), Arrays.asList(new Long(100L), new Integer(15000), "WD", new Integer(128), new Integer(100000)), Arrays.asList(new Long(100L), new Integer(15001), "DEP", new Integer(134), new Integer(1000)), Arrays.asList(new Long(100L), new Integer(15001), "DEP", new Integer(201), new Integer(1000)), Arrays.asList(new Long(200L), new Integer(16000), "WD", new Integer(207), new Integer(1234)), Arrays.asList(new Long(200L), new Integer(16000), "WD", new Integer(299), new Integer(95034)), Arrays.asList(new Long(200L), new Integer(16000), "X", new Integer(301), new Integer(5000))});
        dataMgr.registerTuples(metadata, "Europe.CustAccts", new List[]{Arrays.asList(new Long(100L), new Long(5401002L), new Short(1), new BigDecimal("7.20")), Arrays.asList(new Long(100L), new Long(5401003L), new Short(2), new BigDecimal("1000.00")), Arrays.asList(new Long(200L), new Long(5501004L), new Short(3), new BigDecimal("542.20")), Arrays.asList(new Long(200L), new Long(5501005L), new Short(1), new BigDecimal("99.99")), Arrays.asList(new Long(300L), new Long(6201006L), new Short(1), new BigDecimal("10000.00")), Arrays.asList(new Long(300L), new Long(6201007L), new Short(2), new BigDecimal("0.75")), Arrays.asList(new Long(300L), new Long(6301008L), new Short(2), new BigDecimal("62.00"))});
        dataMgr.registerTuples(metadata, "CustomerMaster.Customers", new List[]{Arrays.asList(new Long(100L), "Miles", "Davis", TimestampUtil.createDate((int)1926, (int)4, (int)25)), Arrays.asList(new Long(200L), "John", "Coltrane", TimestampUtil.createDate((int)1926, (int)8, (int)23)), Arrays.asList(new Long(300L), "Thelonious", "Monk", TimestampUtil.createDate((int)1917, (int)9, (int)10))});
        dataMgr.registerTuples(metadata, "CustomerMaster.Locations", new List[]{Arrays.asList(new Long(100L), "US"), Arrays.asList(new Long(100L), "EU"), Arrays.asList(new Long(200L), "US"), Arrays.asList(new Long(200L), "EU"), Arrays.asList(new Long(300L), "EU")});
    }

    private void overrideVirtualDepJoinData(FakeDataManager dataMgr, QueryMetadataInterface metadata, boolean unique) throws Exception {
        LinkedList<List<Object>> data = new LinkedList<List<Object>>();
        data.add(Arrays.asList(new Long(100L), "Miles", "Davis", TimestampUtil.createDate((int)1926, (int)4, (int)25)));
        if (!unique) {
            data.add(Arrays.asList(new Long(100L), "Miles", "Davis", TimestampUtil.createDate((int)1926, (int)4, (int)25)));
        }
        data.add(Arrays.asList(new Long(200L), "CloneA", "Davis", TimestampUtil.createDate((int)1926, (int)4, (int)26)));
        data.add(Arrays.asList(new Long(300L), "CloneB", "Davis", TimestampUtil.createDate((int)1926, (int)4, (int)27)));
        data.add(Arrays.asList(new Long(400L), "CloneC", "Davis", TimestampUtil.createDate((int)1926, (int)4, (int)28)));
        dataMgr.registerTuples(metadata, "CustomerMaster.Customers", data.toArray(new List[data.size()]));
    }

    @Test
    public void testVirtualAccessVirtualDep() throws Exception {
        String sql = "SELECT a.e0, b.e2 FROM vTest.vGroup a inner join vTest.vGroup b on (a.e0 = b.e2 and a.e1 = b.e2) where b.e0=1 and b.e1='2'";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("convert", true);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("test", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, (CapabilitiesFinder)finder, new String[]{"SELECT g_0.e2 AS c_0 FROM test.\"group\" AS g_0 WHERE (g_0.e0 = 1) AND (g_0.e1 = '2') ORDER BY c_0", "SELECT g_0.e0 AS c_0, g_0.e1 AS c_1, g_0.e0 AS c_2 FROM test.\"group\" AS g_0 WHERE (g_0.e0 IN (<dependent values>)) AND (g_0.e1 IN (<dependent values>)) ORDER BY c_2, c_1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testVirtualAccessVirtualDep2() {
        String sql = "SELECT a.e0, b.e2 FROM vTest.vGroup a makenotdep inner join vTest.vGroup b on (a.e0 = b.e2 and a.e1 = b.e2) where b.e0=1 and b.e1='2'";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("convert", true);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("test", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata4(), null, (CapabilitiesFinder)finder, new String[0], false);
    }

    @Test
    public void testVirtualDepJoinOverAggregates2() throws Exception {
        String sql = "select first, last, sum(amount) from Europe.CustAccts e makenotdep join CustomerMaster.Customers c on c.id=e.id where c.first='Miles' group by c.id, first, last";
        List[] expected = new List[]{Arrays.asList("Miles", "Davis", new BigDecimal("1007.20"))};
        TransformationMetadata metadata = TestVirtualDepJoin.exampleVirtualDepJoin();
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataVirtualDepJoin(dataManager, (QueryMetadataInterface)metadata);
        CommandContext context = TestProcessor.createCommandContext();
        Command command = TestProcessor.helpParse(sql);
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        finder.addCapabilities("Europe", (SourceCapabilities)caps);
        finder.addCapabilities("CustomerMaster", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, finder, context);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 0);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testVirtualMakeDepHint() throws Exception {
        String sql = "select distinct pm1.g1.e1 from (pm1.g1 inner join pm1.g2 on g1.e1 = g2.e1) makedep inner join pm2.g1 on pm2.g1.e1 = pm1.g1.e1 where pm2.g1.e3 = 1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("c")};
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 1, 0, 0, 2, 0, 0, 1, 2, 0, 0});
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, new CommandContext(), dataManager, expected);
    }
}

