/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.SortSpecification;
import org.teiid.query.processor.relational.BlockingFakeRelationalNode;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class TestSortNode {
    public static final int BATCH_SIZE = 100;

    private void helpTestSort(List elements, List[] data, List sortElements, List sortTypes, List[] expected, SortUtility.Mode mode) throws TeiidComponentException, TeiidProcessingException {
        BufferManagerImpl mgr = BufferManagerFactory.getTestBufferManager(100L, 100, 100);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        BlockingFakeRelationalNode dataNode = new BlockingFakeRelationalNode(2, data);
        dataNode.setReturnPeriod(3);
        dataNode.setElements(elements);
        dataNode.initialize(context, (BufferManager)mgr, null);
        SortNode sortNode = new SortNode(1);
        sortNode.setSortElements(new OrderBy(sortElements, sortTypes).getOrderByItems());
        sortNode.setMode(mode);
        sortNode.setElements(elements);
        sortNode.addChild((RelationalNode)dataNode);
        sortNode.initialize(context, (BufferManager)mgr, null);
        sortNode.open();
        int currentRow = 1;
        while (true) {
            try {
                TupleBatch batch;
                do {
                    batch = sortNode.nextBatch();
                    if (mode != SortUtility.Mode.DUP_REMOVE) {
                        for (int row = currentRow; row <= batch.getEndRow(); ++row) {
                            Assert.assertEquals((String)("Rows don't match at " + row), (Object)expected[row - 1], (Object)batch.getTuple(row));
                        }
                    }
                    currentRow += batch.getRowCount();
                } while (!batch.getTerminationFlag());
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        Assert.assertEquals((long)expected.length, (long)(currentRow - 1));
    }

    private void helpTestBasicSort(List[] expected, SortUtility.Mode mode) throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.STRING);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        elements.add(es2);
        List[] data = new List[20];
        for (int i = 0; i < 20; ++i) {
            data[i] = new ArrayList();
            data[i].add(new Integer(i * 51 % 11));
            String str = String.valueOf(i * 3);
            str = str.substring(0, 1);
            data[i].add(str);
        }
        ArrayList<ElementSymbol> sortElements = new ArrayList<ElementSymbol>();
        sortElements.add(es1);
        ArrayList<Boolean> sortTypes = new ArrayList<Boolean>();
        sortTypes.add(new Boolean(true));
        this.helpTestSort(elements, data, sortElements, sortTypes, expected, mode);
    }

    private void helpTestAllSorts(int batches) throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(es1);
        int rows = batches * 100;
        ListNestedSortComparator comparator = new ListNestedSortComparator(new int[]{0}, false);
        List[] expected = new List[rows];
        List[] data = new List[rows];
        TreeSet<List<Integer>> distinct = new TreeSet<List<Integer>>((Comparator<List<Integer>>)comparator);
        for (int i = 0; i < rows; ++i) {
            Integer value = new Integer(i * 51 % 11);
            data[i] = Arrays.asList(value);
            expected[i] = Arrays.asList(value);
            distinct.add(Arrays.asList(value));
        }
        List[] expectedDistinct = distinct.toArray(new List[distinct.size()]);
        ArrayList<ElementSymbol> sortElements = new ArrayList<ElementSymbol>();
        sortElements.add(es1);
        ArrayList<Boolean> sortTypes = new ArrayList<Boolean>();
        sortTypes.add(new Boolean(false));
        Arrays.sort(expected, comparator);
        for (SortUtility.Mode mode : SortUtility.Mode.values()) {
            this.helpTestSort(elements, data, sortElements, sortTypes, mode == SortUtility.Mode.SORT ? expected : expectedDistinct, mode);
        }
    }

    @Test
    public void testComparatorNullOrdering() {
        ListNestedSortComparator comparator = new ListNestedSortComparator(new int[]{0}, false);
        comparator.setNullOrdering(Arrays.asList(SortSpecification.NullOrdering.FIRST));
        List[] data = new List[]{Arrays.asList(1), Arrays.asList(new Integer[]{null}), Arrays.asList(2)};
        Arrays.sort(data, comparator);
        Assert.assertNull(data[0].get(0));
        comparator.setNullOrdering(Arrays.asList(SortSpecification.NullOrdering.LAST));
        Arrays.sort(data, comparator);
        Assert.assertNull(data[2].get(0));
        comparator = new ListNestedSortComparator(new int[]{0}, true);
        Arrays.sort(data, comparator);
        Assert.assertNull(data[0].get(0));
        comparator.setNullOrdering(Arrays.asList(SortSpecification.NullOrdering.LAST));
        Arrays.sort(data, comparator);
        Assert.assertNull(data[2].get(0));
    }

    @Test
    public void testNoSort() throws Exception {
        this.helpTestAllSorts(0);
    }

    @Test
    public void testBasicSort() throws Exception {
        List[] expected = new List[]{Arrays.asList(new Integer(0), "0"), Arrays.asList(new Integer(0), "3"), Arrays.asList(new Integer(1), "2"), Arrays.asList(new Integer(1), "5"), Arrays.asList(new Integer(2), "1"), Arrays.asList(new Integer(2), "4"), Arrays.asList(new Integer(3), "6"), Arrays.asList(new Integer(3), "3"), Arrays.asList(new Integer(4), "3"), Arrays.asList(new Integer(5), "2"), Arrays.asList(new Integer(5), "5"), Arrays.asList(new Integer(6), "1"), Arrays.asList(new Integer(6), "4"), Arrays.asList(new Integer(7), "3"), Arrays.asList(new Integer(7), "3"), Arrays.asList(new Integer(8), "2"), Arrays.asList(new Integer(9), "1"), Arrays.asList(new Integer(9), "5"), Arrays.asList(new Integer(10), "9"), Arrays.asList(new Integer(10), "4")};
        this.helpTestBasicSort(expected, SortUtility.Mode.SORT);
    }

    @Test
    public void testDupSortDesc() throws Exception {
        List[] expected = new List[]{Arrays.asList(new Integer(0), "0"), Arrays.asList(new Integer(0), "3"), Arrays.asList(new Integer(1), "2"), Arrays.asList(new Integer(1), "5"), Arrays.asList(new Integer(2), "1"), Arrays.asList(new Integer(2), "4"), Arrays.asList(new Integer(3), "6"), Arrays.asList(new Integer(3), "3"), Arrays.asList(new Integer(4), "3"), Arrays.asList(new Integer(5), "2"), Arrays.asList(new Integer(5), "5"), Arrays.asList(new Integer(6), "1"), Arrays.asList(new Integer(6), "4"), Arrays.asList(new Integer(7), "3"), Arrays.asList(new Integer(7), "3"), Arrays.asList(new Integer(8), "2"), Arrays.asList(new Integer(9), "1"), Arrays.asList(new Integer(9), "5"), Arrays.asList(new Integer(10), "9"), Arrays.asList(new Integer(10), "4")};
        this.helpTestBasicSort(expected, SortUtility.Mode.SORT);
    }

    @Test
    public void testBasicSortRemoveDup() throws Exception {
        List[] expected = new List[]{Arrays.asList(new Integer(0), "0"), Arrays.asList(new Integer(0), "3"), Arrays.asList(new Integer(1), "2"), Arrays.asList(new Integer(1), "5"), Arrays.asList(new Integer(2), "1"), Arrays.asList(new Integer(2), "4"), Arrays.asList(new Integer(3), "3"), Arrays.asList(new Integer(3), "6"), Arrays.asList(new Integer(4), "3"), Arrays.asList(new Integer(5), "2"), Arrays.asList(new Integer(5), "5"), Arrays.asList(new Integer(6), "1"), Arrays.asList(new Integer(6), "4"), Arrays.asList(new Integer(7), "3"), Arrays.asList(new Integer(8), "2"), Arrays.asList(new Integer(9), "1"), Arrays.asList(new Integer(9), "5"), Arrays.asList(new Integer(10), "4"), Arrays.asList(new Integer(10), "9")};
        this.helpTestBasicSort(expected, SortUtility.Mode.DUP_REMOVE);
    }

    @Test
    public void testBasicSortRemoveDupSort() throws Exception {
        List[] expected = new List[]{Arrays.asList(new Integer(0), "0"), Arrays.asList(new Integer(0), "3"), Arrays.asList(new Integer(1), "2"), Arrays.asList(new Integer(1), "5"), Arrays.asList(new Integer(2), "1"), Arrays.asList(new Integer(2), "4"), Arrays.asList(new Integer(3), "3"), Arrays.asList(new Integer(3), "6"), Arrays.asList(new Integer(4), "3"), Arrays.asList(new Integer(5), "2"), Arrays.asList(new Integer(5), "5"), Arrays.asList(new Integer(6), "1"), Arrays.asList(new Integer(6), "4"), Arrays.asList(new Integer(7), "3"), Arrays.asList(new Integer(8), "2"), Arrays.asList(new Integer(9), "1"), Arrays.asList(new Integer(9), "5"), Arrays.asList(new Integer(10), "4"), Arrays.asList(new Integer(10), "9")};
        this.helpTestBasicSort(expected, SortUtility.Mode.DUP_REMOVE_SORT);
    }

    @Test
    public void testBiggerSort() throws Exception {
        this.helpTestAllSorts(100);
    }

    @Test
    public void testAllSort() throws Exception {
        this.helpTestAllSorts(1);
    }

    @Test
    public void testDupRemove() throws Exception {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tsid = bm.createTupleBuffer(Arrays.asList(es1), "test", BufferManager.TupleSourceType.PROCESSOR);
        tsid.addTuple(Arrays.asList(1));
        SortUtility su = new SortUtility((TupleSource)tsid.createIndexedTupleSource(), Arrays.asList(es1), Arrays.asList(Boolean.TRUE), SortUtility.Mode.DUP_REMOVE, bm, "test", tsid.getSchema());
        TupleBuffer out = su.sort();
        IndexedTupleSource ts = out.createIndexedTupleSource();
        Assert.assertEquals(Arrays.asList(1), (Object)ts.nextTuple());
        try {
            ts.nextTuple();
            Assert.fail();
        }
        catch (BlockedException e) {
            // empty catch block
        }
        tsid.addTuple(Arrays.asList(2));
        tsid.addTuple(Arrays.asList(3));
        su.sort();
        Assert.assertEquals(Arrays.asList(2), (Object)ts.nextTuple());
    }
}

