/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class TestSelect
extends TestCase {
    public TestSelect(String name) {
        super(name);
    }

    public static final Select sample1() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("a"));
        symbols.add(new ElementSymbol("b"));
        Select select = new Select();
        MultipleElementSymbol all = new MultipleElementSymbol();
        all.setElementSymbols(symbols);
        select.addSymbol((SelectSymbol)all);
        return select;
    }

    public static final Select sample2() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("a"));
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        select.addSymbol((SelectSymbol)new ElementSymbol("c"));
        select.addSymbol((SelectSymbol)new AliasSymbol("Z", (SingleElementSymbol)new ElementSymbol("ZZ 9 Plural Z Alpha")));
        return select;
    }

    public void testGetProjectedNoElements() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        List projectedSymbols = select.getProjectedSymbols();
        TestSelect.assertEquals((String)"Did not get empty list for select * with no elements: ", new ArrayList(), (Object)projectedSymbols);
    }

    public void testGetProjectedWithStar() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("a"));
        symbols.add(new ElementSymbol("b"));
        Select select = new Select();
        MultipleElementSymbol all = new MultipleElementSymbol();
        all.setElementSymbols(symbols);
        select.addSymbol((SelectSymbol)all);
        List projectedSymbols = select.getProjectedSymbols();
        TestSelect.assertEquals((String)"Did not get correct list for select *: ", symbols, (Object)projectedSymbols);
    }

    public void testSelfEquivalence() {
        Select s1 = TestSelect.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        Select s1 = TestSelect.sample1();
        Select s1a = TestSelect.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        Select s1 = TestSelect.sample1();
        Select s2 = TestSelect.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }
}

