/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.TestCaseExpression;
import org.teiid.query.sql.symbol.TestSearchedCaseExpression;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestSQLStringVisitor {
    private void helpTest(LanguageObject obj, String expectedStr) {
        String actualStr = SQLStringVisitor.getSQLString((LanguageObject)obj);
        Assert.assertEquals((String)"Expected and actual strings don't match: ", (Object)expectedStr, (Object)actualStr);
    }

    @Test
    public void testNull() {
        String sql = SQLStringVisitor.getSQLString(null);
        Assert.assertEquals((String)"Incorrect string for null object", (Object)"<undefined>", (Object)sql);
    }

    @Test
    public void testBetweenCriteria1() {
        BetweenCriteria bc = new BetweenCriteria((Expression)new ElementSymbol("m.g.c1"), (Expression)new Constant((Object)new Integer(1000)), (Expression)new Constant((Object)new Integer(2000)));
        this.helpTest((LanguageObject)bc, "m.g.c1 BETWEEN 1000 AND 2000");
    }

    @Test
    public void testBetweenCriteria2() {
        BetweenCriteria bc = new BetweenCriteria((Expression)new ElementSymbol("m.g.c1"), (Expression)new Constant((Object)new Integer(1000)), (Expression)new Constant((Object)new Integer(2000)));
        bc.setNegated(true);
        this.helpTest((LanguageObject)bc, "m.g.c1 NOT BETWEEN 1000 AND 2000");
    }

    @Test
    public void testCompareCriteria1() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)cc, "m.g.c1 = 'abc'");
    }

    @Test
    public void testCompareCriteria2() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 2, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)cc, "m.g.c1 <> 'abc'");
    }

    @Test
    public void testCompareCriteria3() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 4, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)cc, "m.g.c1 > 'abc'");
    }

    @Test
    public void testCompareCriteria4() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 6, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)cc, "m.g.c1 >= 'abc'");
    }

    @Test
    public void testCompareCriteria5() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 3, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)cc, "m.g.c1 < 'abc'");
    }

    @Test
    public void testCompareCriteria6() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 5, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)cc, "m.g.c1 <= 'abc'");
    }

    @Test
    public void testCompareCriteria7() {
        CompareCriteria cc = new CompareCriteria(null, 1, null);
        this.helpTest((LanguageObject)cc, "<undefined> = <undefined>");
    }

    @Test
    public void testCompoundCriteria1() {
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(cc);
        CompoundCriteria comp = new CompoundCriteria(0, crits);
        this.helpTest((LanguageObject)comp, "m.g.c1 = 'abc'");
    }

    @Test
    public void testCompoundCriteria2() {
        CompareCriteria cc1 = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        CompareCriteria cc2 = new CompareCriteria((Expression)new ElementSymbol("m.g.c2"), 1, (Expression)new Constant((Object)"abc"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(cc1);
        crits.add(cc2);
        CompoundCriteria comp = new CompoundCriteria(0, crits);
        this.helpTest((LanguageObject)comp, "(m.g.c1 = 'abc') AND (m.g.c2 = 'abc')");
    }

    @Test
    public void testCompoundCriteria3() {
        CompareCriteria cc1 = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        CompareCriteria cc2 = new CompareCriteria((Expression)new ElementSymbol("m.g.c2"), 1, (Expression)new Constant((Object)"abc"));
        CompareCriteria cc3 = new CompareCriteria((Expression)new ElementSymbol("m.g.c3"), 1, (Expression)new Constant((Object)"abc"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(cc1);
        crits.add(cc2);
        crits.add(cc3);
        CompoundCriteria comp = new CompoundCriteria(1, crits);
        this.helpTest((LanguageObject)comp, "(m.g.c1 = 'abc') OR (m.g.c2 = 'abc') OR (m.g.c3 = 'abc')");
    }

    @Test
    public void testCompoundCriteria4() {
        CompareCriteria cc1 = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(cc1);
        crits.add(null);
        CompoundCriteria comp = new CompoundCriteria(1, crits);
        this.helpTest((LanguageObject)comp, "(m.g.c1 = 'abc') OR (<undefined>)");
    }

    @Test
    public void testCompoundCriteria5() {
        CompareCriteria cc1 = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(null);
        crits.add(cc1);
        CompoundCriteria comp = new CompoundCriteria(1, crits);
        this.helpTest((LanguageObject)comp, "(<undefined>) OR (m.g.c1 = 'abc')");
    }

    @Test
    public void testCompoundCriteria6() {
        CompareCriteria cc1 = new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(cc1);
        crits.add(null);
        CompoundCriteria comp = new CompoundCriteria(1, crits);
        this.helpTest((LanguageObject)comp, "(m.g.c1 = 'abc') OR (<undefined>)");
    }

    @Test
    public void testDelete1() {
        Delete delete = new Delete();
        delete.setGroup(new GroupSymbol("m.g"));
        this.helpTest((LanguageObject)delete, "DELETE FROM m.g");
    }

    @Test
    public void testDelete2() {
        Delete delete = new Delete();
        delete.setGroup(new GroupSymbol("m.g"));
        delete.setCriteria((Criteria)new CompareCriteria((Expression)new ElementSymbol("m.g.c1"), 1, (Expression)new Constant((Object)"abc")));
        this.helpTest((LanguageObject)delete, "DELETE FROM m.g WHERE m.g.c1 = 'abc'");
    }

    @Test
    public void testFrom1() {
        From from = new From();
        from.addGroup(new GroupSymbol("m.g1"));
        from.addGroup(new GroupSymbol("m.g2"));
        this.helpTest((LanguageObject)from, "FROM m.g1, m.g2");
    }

    @Test
    public void testFrom2() {
        From from = new From();
        from.addClause((FromClause)new UnaryFromClause(new GroupSymbol("m.g1")));
        from.addClause((FromClause)new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_CROSS));
        this.helpTest((LanguageObject)from, "FROM m.g1, m.g2 CROSS JOIN m.g3");
    }

    @Test
    public void testGroupBy1() {
        GroupBy gb = new GroupBy();
        gb.addSymbol((Expression)new ElementSymbol("m.g.e1"));
        this.helpTest((LanguageObject)gb, "GROUP BY m.g.e1");
    }

    @Test
    public void testGroupBy2() {
        GroupBy gb = new GroupBy();
        gb.addSymbol((Expression)new ElementSymbol("m.g.e1"));
        gb.addSymbol((Expression)new ElementSymbol("m.g.e2"));
        gb.addSymbol((Expression)new ElementSymbol("m.g.e3"));
        this.helpTest((LanguageObject)gb, "GROUP BY m.g.e1, m.g.e2, m.g.e3");
    }

    @Test
    public void testInsert1() {
        Insert insert = new Insert();
        insert.setGroup(new GroupSymbol("m.g1"));
        ArrayList<ElementSymbol> vars = new ArrayList<ElementSymbol>();
        vars.add(new ElementSymbol("e1"));
        vars.add(new ElementSymbol("e2"));
        insert.setVariables(vars);
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(new Constant((Object)new Integer(5)));
        values.add(new Constant((Object)"abc"));
        insert.setValues(values);
        this.helpTest((LanguageObject)insert, "INSERT INTO m.g1 (e1, e2) VALUES (5, 'abc')");
    }

    @Test
    public void testIsNullCriteria1() {
        IsNullCriteria inc = new IsNullCriteria();
        inc.setExpression((Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)inc, "'abc' IS NULL");
    }

    @Test
    public void testIsNullCriteria2() {
        IsNullCriteria inc = new IsNullCriteria();
        inc.setExpression((Expression)new ElementSymbol("m.g.e1"));
        this.helpTest((LanguageObject)inc, "m.g.e1 IS NULL");
    }

    @Test
    public void testIsNullCriteria3() {
        IsNullCriteria inc = new IsNullCriteria();
        this.helpTest((LanguageObject)inc, "<undefined> IS NULL");
    }

    @Test
    public void testIsNullCriteria4() {
        IsNullCriteria inc = new IsNullCriteria();
        inc.setExpression((Expression)new ElementSymbol("m.g.e1"));
        inc.setNegated(true);
        this.helpTest((LanguageObject)inc, "m.g.e1 IS NOT NULL");
    }

    @Test
    public void testJoinPredicate1() {
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_CROSS);
        this.helpTest((LanguageObject)jp, "m.g2 CROSS JOIN m.g3");
    }

    @Test
    public void testOptionalJoinPredicate1() {
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_CROSS);
        jp.setOptional(true);
        this.helpTest((LanguageObject)jp, "/*+ optional */ (m.g2 CROSS JOIN m.g3)");
    }

    @Test
    public void testJoinPredicate2() {
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)new ElementSymbol("m.g2.e1"), 1, (Expression)new ElementSymbol("m.g3.e1")));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_INNER, crits);
        this.helpTest((LanguageObject)jp, "m.g2 INNER JOIN m.g3 ON m.g2.e1 = m.g3.e1");
    }

    @Test
    public void testJoinPredicate3() {
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)new ElementSymbol("m.g2.e1"), 1, (Expression)new ElementSymbol("m.g3.e1")));
        crits.add(new CompareCriteria((Expression)new ElementSymbol("m.g2.e2"), 1, (Expression)new ElementSymbol("m.g3.e2")));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_INNER, crits);
        this.helpTest((LanguageObject)jp, "m.g2 INNER JOIN m.g3 ON m.g2.e1 = m.g3.e1 AND m.g2.e2 = m.g3.e2");
    }

    @Test
    public void testJoinPredicate4() {
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)new ElementSymbol("m.g2.e1"), 1, (Expression)new ElementSymbol("m.g3.e1")));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_INNER, crits);
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(new GroupSymbol("m.g1")), JoinType.JOIN_CROSS);
        this.helpTest((LanguageObject)jp2, "(m.g2 INNER JOIN m.g3 ON m.g2.e1 = m.g3.e1) CROSS JOIN m.g1");
    }

    @Test
    public void testJoinPredicate5() {
        ArrayList<NotCriteria> crits = new ArrayList<NotCriteria>();
        crits.add(new NotCriteria((Criteria)new CompareCriteria((Expression)new ElementSymbol("m.g2.e1"), 1, (Expression)new ElementSymbol("m.g3.e1"))));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g3")), JoinType.JOIN_INNER, crits);
        this.helpTest((LanguageObject)jp, "m.g2 INNER JOIN m.g3 ON NOT (m.g2.e1 = m.g3.e1)");
    }

    @Test
    public void testJoinType1() {
        this.helpTest((LanguageObject)JoinType.JOIN_CROSS, "CROSS JOIN");
    }

    @Test
    public void testJoinType2() {
        this.helpTest((LanguageObject)JoinType.JOIN_INNER, "INNER JOIN");
    }

    @Test
    public void testJoinType3() {
        this.helpTest((LanguageObject)JoinType.JOIN_RIGHT_OUTER, "RIGHT OUTER JOIN");
    }

    @Test
    public void testJoinType4() {
        this.helpTest((LanguageObject)JoinType.JOIN_LEFT_OUTER, "LEFT OUTER JOIN");
    }

    @Test
    public void testJoinType5() {
        this.helpTest((LanguageObject)JoinType.JOIN_FULL_OUTER, "FULL OUTER JOIN");
    }

    @Test
    public void testMatchCriteria1() {
        MatchCriteria mc = new MatchCriteria();
        mc.setLeftExpression((Expression)new ElementSymbol("m.g.e1"));
        mc.setRightExpression((Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)mc, "m.g.e1 LIKE 'abc'");
    }

    @Test
    public void testMatchCriteria2() {
        MatchCriteria mc = new MatchCriteria();
        mc.setLeftExpression((Expression)new ElementSymbol("m.g.e1"));
        mc.setRightExpression((Expression)new Constant((Object)"%"));
        mc.setEscapeChar('#');
        this.helpTest((LanguageObject)mc, "m.g.e1 LIKE '%' ESCAPE '#'");
    }

    @Test
    public void testMatchCriteria3() {
        MatchCriteria mc = new MatchCriteria();
        mc.setLeftExpression((Expression)new ElementSymbol("m.g.e1"));
        mc.setRightExpression((Expression)new Constant((Object)"abc"));
        mc.setNegated(true);
        this.helpTest((LanguageObject)mc, "m.g.e1 NOT LIKE 'abc'");
    }

    @Test
    public void testNotCriteria1() {
        NotCriteria not = new NotCriteria((Criteria)new IsNullCriteria((Expression)new ElementSymbol("m.g.e1")));
        this.helpTest((LanguageObject)not, "NOT (m.g.e1 IS NULL)");
    }

    @Test
    public void testNotCriteria2() {
        NotCriteria not = new NotCriteria();
        this.helpTest((LanguageObject)not, "NOT (<undefined>)");
    }

    @Test
    public void testOption1() {
        Option option = new Option();
        this.helpTest((LanguageObject)option, "OPTION");
    }

    @Test
    public void testOption5() {
        Option option = new Option();
        option.addDependentGroup("abc");
        option.addDependentGroup("def");
        option.addDependentGroup("xyz");
        this.helpTest((LanguageObject)option, "OPTION MAKEDEP abc, def, xyz");
    }

    @Test
    public void testOption6() {
        Option option = new Option();
        option.addDependentGroup("abc");
        option.addDependentGroup("def");
        option.addDependentGroup("xyz");
        this.helpTest((LanguageObject)option, "OPTION MAKEDEP abc, def, xyz");
    }

    @Test
    public void testOption8() {
        Option option = new Option();
        option.addNoCacheGroup("abc");
        option.addNoCacheGroup("def");
        option.addNoCacheGroup("xyz");
        this.helpTest((LanguageObject)option, "OPTION NOCACHE abc, def, xyz");
    }

    @Test
    public void testOption9() {
        Option option = new Option();
        option.setNoCache(true);
        this.helpTest((LanguageObject)option, "OPTION NOCACHE");
    }

    @Test
    public void testOrderBy1() {
        OrderBy ob = new OrderBy();
        ob.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        this.helpTest((LanguageObject)ob, "ORDER BY e1");
    }

    @Test
    public void testOrderBy2() {
        OrderBy ob = new OrderBy();
        ob.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        ob.addVariable((SingleElementSymbol)new AliasSymbol("x", (SingleElementSymbol)new ElementSymbol("e2")));
        this.helpTest((LanguageObject)ob, "ORDER BY e1, x");
    }

    @Test
    public void testOrderBy3() {
        OrderBy ob = new OrderBy();
        ob.addVariable((SingleElementSymbol)new ElementSymbol("e1"), false);
        ob.addVariable((SingleElementSymbol)new ElementSymbol("x"), false);
        this.helpTest((LanguageObject)ob, "ORDER BY e1 DESC, x DESC");
    }

    @Test
    public void testQuery1() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g");
    }

    @Test
    public void testQuery2() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(5)));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("e1"));
        CompareCriteria having = new CompareCriteria((Expression)new ElementSymbol("e1"), 4, (Expression)new Constant((Object)new Integer(0)));
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)cc);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        query.setOrderBy(orderBy);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g WHERE e1 = 5 GROUP BY e1 HAVING e1 > 0 ORDER BY e1");
    }

    @Test
    public void testQuery3() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("e1"));
        CompareCriteria having = new CompareCriteria((Expression)new ElementSymbol("e1"), 4, (Expression)new Constant((Object)new Integer(0)));
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        query.setOrderBy(orderBy);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g GROUP BY e1 HAVING e1 > 0 ORDER BY e1");
    }

    @Test
    public void testQuery4() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria having = new CompareCriteria((Expression)new ElementSymbol("e1"), 4, (Expression)new Constant((Object)new Integer(0)));
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)cc);
        query.setHaving((Criteria)having);
        query.setOrderBy(orderBy);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g WHERE e1 = 5 HAVING e1 > 0 ORDER BY e1");
    }

    @Test
    public void testQuery5() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(5)));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("e1"));
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)cc);
        query.setGroupBy(groupBy);
        query.setOrderBy(orderBy);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g WHERE e1 = 5 GROUP BY e1 ORDER BY e1");
    }

    @Test
    public void testQuery6() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(5)));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("e1"));
        CompareCriteria having = new CompareCriteria((Expression)new ElementSymbol("e1"), 4, (Expression)new Constant((Object)new Integer(0)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)cc);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g WHERE e1 = 5 GROUP BY e1 HAVING e1 > 0");
    }

    @Test
    public void testQuery7() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria cc = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(5)));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("e1"));
        CompareCriteria having = new CompareCriteria((Expression)new ElementSymbol("e1"), 4, (Expression)new Constant((Object)new Integer(0)));
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)cc);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        query.setOrderBy(orderBy);
        this.helpTest((LanguageObject)query, "SELECT * FROM m.g WHERE e1 = 5 GROUP BY e1 HAVING e1 > 0 ORDER BY e1");
    }

    @Test
    public void testSelect1() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        this.helpTest((LanguageObject)select, "SELECT e1");
    }

    @Test
    public void testSelect2() {
        Select select = new Select();
        select.setDistinct(true);
        select.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        this.helpTest((LanguageObject)select, "SELECT DISTINCT e1");
    }

    @Test
    public void testSelect3() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        select.addSymbol((SelectSymbol)new ElementSymbol("e2"));
        this.helpTest((LanguageObject)select, "SELECT e1, e2");
    }

    @Test
    public void testSetCriteria1() {
        SetCriteria sc = new SetCriteria();
        sc.setExpression((Expression)new ElementSymbol("e1"));
        sc.setValues(new ArrayList());
        this.helpTest((LanguageObject)sc, "e1 IN ()");
    }

    @Test
    public void testSetCriteria2() {
        SetCriteria sc = new SetCriteria();
        sc.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(new ElementSymbol("e2"));
        values.add(new Constant((Object)"abc"));
        sc.setValues(values);
        this.helpTest((LanguageObject)sc, "e1 IN (e2, 'abc')");
    }

    @Test
    public void testSetCriteria3() {
        SetCriteria sc = new SetCriteria();
        sc.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(null);
        values.add(new Constant((Object)"b"));
        sc.setValues(values);
        this.helpTest((LanguageObject)sc, "e1 IN (<undefined>, 'b')");
    }

    @Test
    public void testSetCriteria4() {
        SetCriteria sc = new SetCriteria();
        sc.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(new ElementSymbol("e2"));
        values.add(new Constant((Object)"abc"));
        sc.setValues(values);
        sc.setNegated(true);
        this.helpTest((LanguageObject)sc, "e1 NOT IN (e2, 'abc')");
    }

    @Test
    public void testSetQuery1() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)q1, (QueryCommand)q2);
        this.helpTest((LanguageObject)sq, "SELECT e1 FROM m.g1 UNION SELECT e1 FROM m.g2");
    }

    @Test
    public void testSetQuery2() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, true, (QueryCommand)q1, (QueryCommand)q2);
        this.helpTest((LanguageObject)sq, "SELECT e1 FROM m.g1 UNION ALL SELECT e1 FROM m.g2");
    }

    @Test
    public void testSetQuery3() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("e1"));
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)q1, (QueryCommand)q2);
        sq.setOrderBy(orderBy);
        this.helpTest((LanguageObject)sq, "SELECT e1 FROM m.g1 UNION SELECT e1 FROM m.g2 ORDER BY e1");
    }

    @Test
    public void testSetQuery4() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)q1, (QueryCommand)q2);
        this.helpTest((LanguageObject)sq, "SELECT e1 FROM m.g1 UNION SELECT e1 FROM m.g2");
    }

    @Test
    public void testSetQuery5() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        Select s3 = new Select();
        s3.addSymbol((SelectSymbol)new ElementSymbol("e3"));
        From f3 = new From();
        f3.addGroup(new GroupSymbol("m.g3"));
        Query q3 = new Query();
        q3.setSelect(s3);
        q3.setFrom(f3);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)q1, (QueryCommand)q2);
        SetQuery sq2 = new SetQuery(SetQuery.Operation.UNION, true, (QueryCommand)q3, (QueryCommand)sq);
        this.helpTest((LanguageObject)sq2, "SELECT e3 FROM m.g3 UNION ALL (SELECT e1 FROM m.g1 UNION SELECT e1 FROM m.g2)");
    }

    @Test
    public void testSubqueryFromClause1() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        SubqueryFromClause sfc = new SubqueryFromClause("temp", (Command)q1);
        this.helpTest((LanguageObject)sfc, "(SELECT e1 FROM m.g1) AS temp");
    }

    @Test
    public void testOptionalSubqueryFromClause1() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        SubqueryFromClause sfc = new SubqueryFromClause("temp", (Command)q1);
        sfc.setOptional(true);
        this.helpTest((LanguageObject)sfc, "/*+ optional */ (SELECT e1 FROM m.g1) AS temp");
    }

    @Test
    public void testSubquerySetCriteria1() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        ElementSymbol expr = new ElementSymbol("e2");
        SubquerySetCriteria ssc = new SubquerySetCriteria((Expression)expr, (QueryCommand)q1);
        this.helpTest((LanguageObject)ssc, "e2 IN (SELECT e1 FROM m.g1)");
    }

    @Test
    public void testSubquerySetCriteria2() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        ElementSymbol expr = new ElementSymbol("e2");
        SubquerySetCriteria ssc = new SubquerySetCriteria((Expression)expr, (QueryCommand)q1);
        ssc.setNegated(true);
        this.helpTest((LanguageObject)ssc, "e2 NOT IN (SELECT e1 FROM m.g1)");
    }

    @Test
    public void testUnaryFromClause() {
        this.helpTest((LanguageObject)new UnaryFromClause(new GroupSymbol("m.g1")), "m.g1");
    }

    @Test
    public void testOptionalUnaryFromClause() {
        UnaryFromClause unaryFromClause = new UnaryFromClause(new GroupSymbol("m.g1"));
        unaryFromClause.setOptional(true);
        this.helpTest((LanguageObject)unaryFromClause, "/*+ optional */ m.g1");
    }

    @Test
    public void testUpdate1() {
        Update update = new Update();
        update.setGroup(new GroupSymbol("m.g1"));
        update.addChange(new ElementSymbol("e1"), (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)update, "UPDATE m.g1 SET e1 = 'abc'");
    }

    @Test
    public void testUpdate2() {
        Update update = new Update();
        update.setGroup(new GroupSymbol("m.g1"));
        update.addChange(new ElementSymbol("e1"), (Expression)new Constant((Object)"abc"));
        update.addChange(new ElementSymbol("e2"), (Expression)new Constant((Object)"xyz"));
        this.helpTest((LanguageObject)update, "UPDATE m.g1 SET e1 = 'abc', e2 = 'xyz'");
    }

    @Test
    public void testUpdate3() {
        Update update = new Update();
        update.setGroup(new GroupSymbol("m.g1"));
        update.addChange(new ElementSymbol("e1"), (Expression)new Constant((Object)"abc"));
        update.setCriteria((Criteria)new CompareCriteria((Expression)new ElementSymbol("e2"), 1, (Expression)new Constant((Object)"abc")));
        this.helpTest((LanguageObject)update, "UPDATE m.g1 SET e1 = 'abc' WHERE e2 = 'abc'");
    }

    @Test
    public void testAggregateSymbol1() {
        AggregateSymbol agg = new AggregateSymbol("abc", "COUNT", false, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)agg, "COUNT('abc')");
    }

    @Test
    public void testAggregateSymbol2() {
        AggregateSymbol agg = new AggregateSymbol("abc", "COUNT", true, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)agg, "COUNT(DISTINCT 'abc')");
    }

    @Test
    public void testAggregateSymbol3() {
        AggregateSymbol agg = new AggregateSymbol("abc", "COUNT", false, null);
        this.helpTest((LanguageObject)agg, "COUNT(*)");
    }

    @Test
    public void testAggregateSymbol4() {
        AggregateSymbol agg = new AggregateSymbol("abc", "AVG", false, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)agg, "AVG('abc')");
    }

    @Test
    public void testAggregateSymbol5() {
        AggregateSymbol agg = new AggregateSymbol("abc", "SUM", false, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)agg, "SUM('abc')");
    }

    @Test
    public void testAggregateSymbol6() {
        AggregateSymbol agg = new AggregateSymbol("abc", "MIN", false, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)agg, "MIN('abc')");
    }

    @Test
    public void testAggregateSymbol7() {
        AggregateSymbol agg = new AggregateSymbol("abc", "MAX", false, (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)agg, "MAX('abc')");
    }

    @Test
    public void testAliasSymbol1() {
        AliasSymbol as = new AliasSymbol("x", (SingleElementSymbol)new ElementSymbol("y"));
        this.helpTest((LanguageObject)as, "y AS x");
    }

    @Test
    public void testAliasSymbol2() {
        AliasSymbol as = new AliasSymbol("select", (SingleElementSymbol)new ElementSymbol("y"));
        this.helpTest((LanguageObject)as, "y AS \"select\"");
    }

    @Test
    public void testAllSymbol() {
        this.helpTest((LanguageObject)new MultipleElementSymbol(), "*");
    }

    @Test
    public void testAllInGroupSymbol() {
        this.helpTest((LanguageObject)new MultipleElementSymbol("m.g"), "m.g.*");
    }

    @Test
    public void testConstantNull() {
        this.helpTest((LanguageObject)new Constant(null), "null");
    }

    @Test
    public void testConstantString() {
        this.helpTest((LanguageObject)new Constant((Object)"abc"), "'abc'");
    }

    @Test
    public void testConstantInteger() {
        this.helpTest((LanguageObject)new Constant((Object)new Integer(5)), "5");
    }

    @Test
    public void testConstantBigDecimal() {
        this.helpTest((LanguageObject)new Constant((Object)new BigDecimal("5.4")), "5.4");
    }

    @Test
    public void testConstantStringWithTick() {
        this.helpTest((LanguageObject)new Constant((Object)"O'Leary"), "'O''Leary'");
    }

    @Test
    public void testConstantStringWithTicks() {
        this.helpTest((LanguageObject)new Constant((Object)"'abc'"), "'''abc'''");
    }

    @Test
    public void testConstantStringWithMoreTicks() {
        this.helpTest((LanguageObject)new Constant((Object)"a'b'c"), "'a''b''c'");
    }

    @Test
    public void testConstantStringWithDoubleTick() {
        this.helpTest((LanguageObject)new Constant((Object)"group=\"x\""), "'group=\"x\"'");
    }

    @Test
    public void testConstantBooleanTrue() {
        this.helpTest((LanguageObject)new Constant((Object)Boolean.TRUE), "TRUE");
    }

    @Test
    public void testConstantBooleanFalse() {
        this.helpTest((LanguageObject)new Constant((Object)Boolean.FALSE), "FALSE");
    }

    @Test
    public void testConstantDate() {
        this.helpTest((LanguageObject)new Constant((Object)Date.valueOf("2002-10-02")), "{d'2002-10-02'}");
    }

    @Test
    public void testConstantTime() {
        this.helpTest((LanguageObject)new Constant((Object)Time.valueOf("5:00:00")), "{t'05:00:00'}");
    }

    @Test
    public void testConstantTimestamp() {
        this.helpTest((LanguageObject)new Constant((Object)Timestamp.valueOf("2002-10-02 17:10:35.0234")), "{ts'2002-10-02 17:10:35.0234'}");
    }

    @Test
    public void testElementSymbol1() {
        ElementSymbol es = new ElementSymbol("elem");
        this.helpTest((LanguageObject)es, "elem");
    }

    @Test
    public void testElementSymbol2() {
        ElementSymbol es = new ElementSymbol("elem", false);
        es.setGroupSymbol(new GroupSymbol("m.g"));
        this.helpTest((LanguageObject)es, "elem");
    }

    @Test
    public void testElementSymbol3() {
        ElementSymbol es = new ElementSymbol("m.g.elem", true);
        es.setGroupSymbol(new GroupSymbol("m.g"));
        this.helpTest((LanguageObject)es, "m.g.elem");
    }

    @Test
    public void testElementSymbol4() {
        ElementSymbol es = new ElementSymbol("vdb.m.g.elem", true);
        this.helpTest((LanguageObject)es, "vdb.m.g.elem");
    }

    @Test
    public void testElementSymbol5() {
        ElementSymbol es = new ElementSymbol("m.g.select", false);
        es.setGroupSymbol(new GroupSymbol("m.g"));
        this.helpTest((LanguageObject)es, "\"select\"");
    }

    @Test
    public void testExpressionSymbol1() {
        ExpressionSymbol expr = new ExpressionSymbol("abc", (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)expr, "'abc'");
    }

    @Test
    public void testFunction1() {
        Function func = new Function("concat", new Expression[]{new Constant((Object)"a"), null});
        this.helpTest((LanguageObject)func, "concat('a', <undefined>)");
    }

    @Test
    public void testFunction2() {
        Function func = new Function("now", new Expression[0]);
        this.helpTest((LanguageObject)func, "now()");
    }

    @Test
    public void testFunction3() {
        Function func = new Function("concat", new Expression[]{null, null});
        this.helpTest((LanguageObject)func, "concat(<undefined>, <undefined>)");
    }

    @Test
    public void testFunction4() {
        Function func1 = new Function("power", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(3))});
        Function func2 = new Function("power", new Expression[]{func1, new Constant((Object)new Integer(3))});
        Function func3 = new Function("+", new Expression[]{new Constant((Object)new Integer(1000)), func2});
        this.helpTest((LanguageObject)func3, "(1000 + power(power(5, 3), 3))");
    }

    @Test
    public void testFunction5() {
        Function func1 = new Function("concat", new Expression[]{new ElementSymbol("elem2"), null});
        Function func2 = new Function("concat", new Expression[]{new ElementSymbol("elem1"), func1});
        this.helpTest((LanguageObject)func2, "concat(elem1, concat(elem2, <undefined>))");
    }

    @Test
    public void testConvertFunction1() {
        Function func = new Function("convert", new Expression[]{new Constant((Object)"5"), new Constant((Object)"integer")});
        this.helpTest((LanguageObject)func, "convert('5', integer)");
    }

    @Test
    public void testConvertFunction2() {
        Function func = new Function("convert", new Expression[]{null, new Constant((Object)"integer")});
        this.helpTest((LanguageObject)func, "convert(<undefined>, integer)");
    }

    @Test
    public void testConvertFunction3() {
        Function func = new Function("convert", new Expression[]{new Constant(null), new Constant((Object)"integer")});
        this.helpTest((LanguageObject)func, "convert(null, integer)");
    }

    @Test
    public void testConvertFunction4() {
        Function func = new Function("convert", new Expression[]{new Constant((Object)"abc"), null});
        this.helpTest((LanguageObject)func, "convert('abc', <undefined>)");
    }

    @Test
    public void testConvertFunction5() {
        Function func = new Function("convert", null);
        this.helpTest((LanguageObject)func, "convert()");
    }

    @Test
    public void testConvertFunction6() {
        Function func = new Function("convert", new Expression[0]);
        this.helpTest((LanguageObject)func, "convert()");
    }

    @Test
    public void testConvertFunction7() {
        Function func = new Function("convert", new Expression[]{new Constant((Object)"abc")});
        this.helpTest((LanguageObject)func, "convert('abc', <undefined>)");
    }

    @Test
    public void testCastFunction1() {
        Function func = new Function("cast", new Expression[]{new Constant((Object)"5"), new Constant((Object)"integer")});
        this.helpTest((LanguageObject)func, "cast('5' AS integer)");
    }

    @Test
    public void testCastFunction2() {
        Function func = new Function("cast", new Expression[]{null, new Constant((Object)"integer")});
        this.helpTest((LanguageObject)func, "cast(<undefined> AS integer)");
    }

    @Test
    public void testCastFunction3() {
        Function func = new Function("cast", new Expression[]{new Constant(null), new Constant((Object)"integer")});
        this.helpTest((LanguageObject)func, "cast(null AS integer)");
    }

    @Test
    public void testCastFunction4() {
        Function func = new Function("cast", new Expression[]{new Constant((Object)"abc"), null});
        this.helpTest((LanguageObject)func, "cast('abc' AS <undefined>)");
    }

    @Test
    public void testArithemeticFunction1() {
        Function func = new Function("-", new Expression[]{new Constant((Object)new Integer(-2)), new Constant((Object)new Integer(-1))});
        this.helpTest((LanguageObject)func, "(-2 - -1)");
    }

    @Test
    public void testGroupSymbol1() {
        GroupSymbol gs = new GroupSymbol("g");
        this.helpTest((LanguageObject)gs, "g");
    }

    @Test
    public void testGroupSymbol2() {
        GroupSymbol gs = new GroupSymbol("x", "g");
        this.helpTest((LanguageObject)gs, "g AS x");
    }

    @Test
    public void testGroupSymbol3() {
        GroupSymbol gs = new GroupSymbol("vdb.g");
        this.helpTest((LanguageObject)gs, "vdb.g");
    }

    @Test
    public void testGroupSymbol4() {
        GroupSymbol gs = new GroupSymbol("x", "vdb.g");
        this.helpTest((LanguageObject)gs, "vdb.g AS x");
    }

    @Test
    public void testGroupSymbol5() {
        GroupSymbol gs = new GroupSymbol("from", "m.g");
        this.helpTest((LanguageObject)gs, "m.g AS \"from\"");
    }

    @Test
    public void testGroupSymbol6() {
        GroupSymbol gs = new GroupSymbol("x", "on.select");
        this.helpTest((LanguageObject)gs, "\"on\".\"select\" AS x");
    }

    @Test
    public void testExecNoParams() {
        StoredProcedure proc = new StoredProcedure();
        proc.setProcedureName("myproc");
        this.helpTest((LanguageObject)proc, "EXEC myproc()");
    }

    @Test
    public void testExecInputParam() {
        StoredProcedure proc = new StoredProcedure();
        proc.setProcedureName("myproc");
        SPParameter param = new SPParameter(1, (Expression)new Reference(0));
        proc.setParameter(param);
        this.helpTest((LanguageObject)proc, "EXEC myproc(?)");
    }

    @Test
    public void testExecInputOutputParam() {
        StoredProcedure proc = new StoredProcedure();
        proc.setProcedureName("myproc");
        SPParameter param1 = new SPParameter(1, (Expression)new Constant((Object)new Integer(5)));
        param1.setParameterType(1);
        proc.setParameter(param1);
        SPParameter param2 = new SPParameter(2, 2, "x");
        proc.setParameter(param2);
        this.helpTest((LanguageObject)proc, "EXEC myproc(5)");
    }

    @Test
    public void testExecOutputInputParam() {
        StoredProcedure proc = new StoredProcedure();
        proc.setProcedureName("myproc");
        SPParameter param2 = new SPParameter(2, 2, "x");
        proc.setParameter(param2);
        SPParameter param1 = new SPParameter(1, (Expression)new Constant((Object)new Integer(5)));
        param1.setParameterType(1);
        proc.setParameter(param1);
        this.helpTest((LanguageObject)proc, "EXEC myproc(5)");
    }

    @Test
    public void testExecReturnParam() {
        StoredProcedure proc = new StoredProcedure();
        proc.setProcedureName("myproc");
        SPParameter param = new SPParameter(1, 4, "ret");
        proc.setParameter(param);
        this.helpTest((LanguageObject)proc, "EXEC myproc()");
    }

    @Test
    public void testExecNamedParam() {
        StoredProcedure proc = new StoredProcedure();
        proc.setDisplayNamedParameters(true);
        proc.setProcedureName("myproc");
        SPParameter param = new SPParameter(1, (Expression)new Reference(0));
        param.setName("p1");
        proc.setParameter(param);
        this.helpTest((LanguageObject)proc, "EXEC myproc(p1 => ?)");
    }

    @Test
    public void testExecNamedParams() {
        StoredProcedure proc = new StoredProcedure();
        proc.setDisplayNamedParameters(true);
        proc.setProcedureName("myproc");
        SPParameter param = new SPParameter(1, (Expression)new Reference(0));
        param.setName("p1");
        proc.setParameter(param);
        SPParameter param2 = new SPParameter(2, (Expression)new Reference(0));
        param2.setName("p2");
        proc.setParameter(param2);
        this.helpTest((LanguageObject)proc, "EXEC myproc(p1 => ?, p2 => ?)");
    }

    @Test
    public void testExecNamedParamsReservedWord() {
        StoredProcedure proc = new StoredProcedure();
        proc.setDisplayNamedParameters(true);
        proc.setProcedureName("myproc");
        SPParameter param = new SPParameter(1, (Expression)new Reference(0));
        param.setName("in");
        proc.setParameter(param);
        SPParameter param2 = new SPParameter(2, (Expression)new Reference(0));
        param2.setName("in2");
        proc.setParameter(param2);
        this.helpTest((LanguageObject)proc, "EXEC myproc(\"in\" => ?, in2 => ?)");
    }

    @Test
    public void testDeclareStatement() {
        DeclareStatement dclStmt = new DeclareStatement(new ElementSymbol("a"), "String");
        this.helpTest((LanguageObject)dclStmt, "DECLARE String a;");
    }

    @Test
    public void testRaiseErrorStatement() {
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        this.helpTest((LanguageObject)errStmt, "ERROR 'My Error';");
    }

    @Test
    public void testRaiseErrorStatementWithExpression() {
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new ElementSymbol("a"));
        this.helpTest((LanguageObject)errStmt, "ERROR a;");
    }

    @Test
    public void testAssignmentStatement1() {
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        this.helpTest((LanguageObject)assigStmt, "a = 1;");
    }

    @Test
    public void testAssignmentStatement2() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        q1.setFrom(from);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (QueryCommand)q1);
        this.helpTest((LanguageObject)assigStmt, "a = (SELECT x FROM g);");
    }

    @Test
    public void testCriteriaSelector1() {
        ElementSymbol sy1 = new ElementSymbol("a");
        ElementSymbol sy2 = new ElementSymbol("b");
        ElementSymbol sy3 = new ElementSymbol("c");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(1, elmnts);
        this.helpTest((LanguageObject)cs, "= CRITERIA ON (a, b, c)");
    }

    @Test
    public void testCriteriaSelector2() {
        ElementSymbol sy1 = new ElementSymbol("x");
        ElementSymbol sy2 = new ElementSymbol("y");
        ElementSymbol sy3 = new ElementSymbol("z");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        this.helpTest((LanguageObject)cs, "LIKE CRITERIA ON (x, y, z)");
    }

    @Test
    public void testCriteriaSelector3() {
        ElementSymbol sy1 = new ElementSymbol("x");
        ElementSymbol sy2 = new ElementSymbol("y");
        ElementSymbol sy3 = new ElementSymbol("z");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(10, elmnts);
        this.helpTest((LanguageObject)cs, "BETWEEN CRITERIA ON (x, y, z)");
    }

    @Test
    public void testHasCriteria1() {
        ElementSymbol sy1 = new ElementSymbol("x");
        ElementSymbol sy2 = new ElementSymbol("y");
        ElementSymbol sy3 = new ElementSymbol("z");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        this.helpTest((LanguageObject)new HasCriteria(cs), "HAS LIKE CRITERIA ON (x, y, z)");
    }

    @Test
    public void testHasCriteria2() {
        ElementSymbol sy1 = new ElementSymbol("x");
        ElementSymbol sy2 = new ElementSymbol("y");
        ElementSymbol sy3 = new ElementSymbol("z");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        this.helpTest((LanguageObject)new HasCriteria(cs), "HAS LIKE CRITERIA ON (x, y, z)");
    }

    @Test
    public void testHasCriteria3() {
        ElementSymbol sy1 = new ElementSymbol("x");
        ElementSymbol sy2 = new ElementSymbol("y");
        ElementSymbol sy3 = new ElementSymbol("z");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(10, elmnts);
        this.helpTest((LanguageObject)new HasCriteria(cs), "HAS BETWEEN CRITERIA ON (x, y, z)");
    }

    @Test
    public void testCommandStatement1() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        q1.setFrom(from);
        CommandStatement cmdStmt = new CommandStatement((Command)q1);
        this.helpTest((LanguageObject)cmdStmt, "SELECT x FROM g;");
    }

    @Test
    public void testCommandStatement2() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        this.helpTest((LanguageObject)cmdStmt, "DELETE FROM g;");
    }

    @Test
    public void testBlock1() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block b = new Block();
        b.addStatement((Statement)cmdStmt);
        b.addStatement((Statement)assigStmt);
        b.addStatement((Statement)errStmt);
        this.helpTest((LanguageObject)b, "BEGIN\nDELETE FROM g;\na = 1;\nERROR 'My Error';\nEND");
    }

    @Test
    public void testBlock2() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        Block ifblock = new Block((Statement)cmdStmt);
        ElementSymbol sy1 = new ElementSymbol("x");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(1);
        elmnts.add(sy1);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        HasCriteria crit = new HasCriteria(cs);
        IfStatement ifStmt = new IfStatement((Criteria)crit, ifblock);
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block b = new Block();
        b.addStatement((Statement)cmdStmt);
        b.addStatement((Statement)ifStmt);
        b.addStatement((Statement)errStmt);
        this.helpTest((LanguageObject)b, "BEGIN\nDELETE FROM g;\nIF(HAS LIKE CRITERIA ON (x))\nBEGIN\nDELETE FROM g;\nEND\nERROR 'My Error';\nEND");
    }

    @Test
    public void testIfStatement1() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block ifblock = new Block();
        ifblock.addStatement((Statement)cmdStmt);
        ifblock.addStatement((Statement)assigStmt);
        ifblock.addStatement((Statement)errStmt);
        ElementSymbol sy1 = new ElementSymbol("x");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(1);
        elmnts.add(sy1);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        HasCriteria crit = new HasCriteria(cs);
        IfStatement ifStmt = new IfStatement((Criteria)crit, ifblock);
        this.helpTest((LanguageObject)ifStmt, "IF(HAS LIKE CRITERIA ON (x))\nBEGIN\nDELETE FROM g;\na = 1;\nERROR 'My Error';\nEND");
    }

    @Test
    public void testIfStatement2() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        Block ifblock = new Block((Statement)cmdStmt);
        ElementSymbol sy1 = new ElementSymbol("x");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(1);
        elmnts.add(sy1);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        HasCriteria crit = new HasCriteria(cs);
        IfStatement ifStmt = new IfStatement((Criteria)crit, ifblock);
        this.helpTest((LanguageObject)ifStmt, "IF(HAS LIKE CRITERIA ON (x))\nBEGIN\nDELETE FROM g;\nEND");
    }

    @Test
    public void testIfStatement3() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block ifblock = new Block();
        ifblock.addStatement((Statement)cmdStmt);
        ifblock.addStatement((Statement)assigStmt);
        ifblock.addStatement((Statement)errStmt);
        ElementSymbol sy1 = new ElementSymbol("x");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(1);
        elmnts.add(sy1);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        HasCriteria crit = new HasCriteria(cs);
        Block elseblock = new Block();
        elseblock.addStatement((Statement)cmdStmt);
        IfStatement ifStmt = new IfStatement((Criteria)crit, ifblock, elseblock);
        this.helpTest((LanguageObject)ifStmt, "IF(HAS LIKE CRITERIA ON (x))\nBEGIN\nDELETE FROM g;\na = 1;\nERROR 'My Error';\nEND\nELSE\nBEGIN\nDELETE FROM g;\nEND");
    }

    @Test
    public void testCreateUpdateProcedure1() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block b = new Block();
        b.addStatement((Statement)cmdStmt);
        b.addStatement((Statement)assigStmt);
        b.addStatement((Statement)errStmt);
        CreateUpdateProcedureCommand cup = new CreateUpdateProcedureCommand(b);
        this.helpTest((LanguageObject)cup, "CREATE PROCEDURE\nBEGIN\nDELETE FROM g;\na = 1;\nERROR 'My Error';\nEND");
    }

    @Test
    public void testCreateUpdateProcedure2() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block b = new Block();
        b.addStatement((Statement)cmdStmt);
        b.addStatement((Statement)assigStmt);
        b.addStatement((Statement)errStmt);
        CreateUpdateProcedureCommand cup = new CreateUpdateProcedureCommand(b);
        this.helpTest((LanguageObject)cup, "CREATE PROCEDURE\nBEGIN\nDELETE FROM g;\na = 1;\nERROR 'My Error';\nEND");
    }

    @Test
    public void testCreateUpdateProcedure3() {
        Delete d1 = new Delete();
        d1.setGroup(new GroupSymbol("g"));
        CommandStatement cmdStmt = new CommandStatement((Command)d1);
        AssignmentStatement assigStmt = new AssignmentStatement(new ElementSymbol("a"), (Expression)new Constant((Object)new Integer(1)));
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"My Error"));
        Block b = new Block();
        b.addStatement((Statement)cmdStmt);
        b.addStatement((Statement)assigStmt);
        b.addStatement((Statement)errStmt);
        CreateUpdateProcedureCommand cup = new CreateUpdateProcedureCommand(b);
        this.helpTest((LanguageObject)cup, "CREATE PROCEDURE\nBEGIN\nDELETE FROM g;\na = 1;\nERROR 'My Error';\nEND");
    }

    @Test
    public void testSubqueryCompareCriteria1() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        ElementSymbol expr = new ElementSymbol("e2");
        SubqueryCompareCriteria scc = new SubqueryCompareCriteria((Expression)expr, (QueryCommand)q1, 1, 3);
        this.helpTest((LanguageObject)scc, "e2 = ANY (SELECT e1 FROM m.g1)");
    }

    @Test
    public void testSubqueryCompareCriteria2() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        ElementSymbol expr = new ElementSymbol("e2");
        SubqueryCompareCriteria scc = new SubqueryCompareCriteria((Expression)expr, (QueryCommand)q1, 5, 2);
        this.helpTest((LanguageObject)scc, "e2 <= SOME (SELECT e1 FROM m.g1)");
    }

    @Test
    public void testExistsCriteria1() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        ExistsCriteria ec = new ExistsCriteria((QueryCommand)q1);
        this.helpTest((LanguageObject)ec, "EXISTS (SELECT e1 FROM m.g1)");
    }

    @Test
    public void testDynamicCommand() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        ElementSymbol a1 = new ElementSymbol("a1");
        a1.setType(DataTypeManager.DefaultDataClasses.STRING);
        symbols.add(a1);
        DynamicCommand obj = new DynamicCommand();
        Constant sql = new Constant((Object)"SELECT a1 FROM g WHERE a2 = 5");
        obj.setSql((Expression)sql);
        obj.setAsColumns(symbols);
        obj.setAsClauseSet(true);
        obj.setIntoGroup(new GroupSymbol("#g"));
        this.helpTest((LanguageObject)obj, "EXECUTE 'SELECT a1 FROM g WHERE a2 = 5' AS a1 string INTO #g");
    }

    @Test
    public void testScalarSubquery() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        ScalarSubquery obj = new ScalarSubquery((QueryCommand)q1);
        this.helpTest((LanguageObject)obj, "(SELECT e1 FROM m.g1)");
    }

    @Test
    public void testNewSubqueryObjects() {
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new ElementSymbol("e1"));
        s2.addSymbol((SelectSymbol)new ExpressionSymbol("blargh", (Expression)new ScalarSubquery((QueryCommand)q1)));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        SubqueryCompareCriteria left = new SubqueryCompareCriteria((Expression)new ElementSymbol("e3"), (QueryCommand)q1, 6, 3);
        ExistsCriteria right = new ExistsCriteria((QueryCommand)q1);
        CompoundCriteria outer = new CompoundCriteria(0, (Criteria)left, (Criteria)right);
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        q2.setCriteria((Criteria)outer);
        this.helpTest((LanguageObject)q2, "SELECT e1, (SELECT e1 FROM m.g1) FROM m.g2 WHERE (e3 >= ANY (SELECT e1 FROM m.g1)) AND (EXISTS (SELECT e1 FROM m.g1))");
    }

    @Test
    public void testCaseExpression1() {
        this.helpTest((LanguageObject)TestCaseExpression.example(2), "CASE x WHEN 'a' THEN 0 WHEN 'b' THEN 1 ELSE 9999 END");
    }

    @Test
    public void testCaseExpression2() {
        CaseExpression example = TestCaseExpression.example(2);
        example.setElseExpression(null);
        this.helpTest((LanguageObject)example, "CASE x WHEN 'a' THEN 0 WHEN 'b' THEN 1 END");
    }

    @Test
    public void testCaseExpression3() {
        CaseExpression example = TestCaseExpression.example(3, 0, true);
        this.helpTest((LanguageObject)example, "CASE x WHEN null THEN 0 WHEN 'b' THEN 1 WHEN 'c' THEN 2 ELSE 9999 END");
    }

    @Test
    public void testCaseExpression4() {
        CaseExpression example = TestCaseExpression.example(3, 2, true);
        example.setElseExpression(null);
        this.helpTest((LanguageObject)example, "CASE x WHEN 'a' THEN 0 WHEN 'b' THEN 1 WHEN null THEN 2 END");
    }

    @Test
    public void testSearchedCaseExpression1() {
        this.helpTest((LanguageObject)TestSearchedCaseExpression.example(2), "CASE WHEN x = 0 THEN 0 WHEN x = 1 THEN 1 ELSE 9999 END");
    }

    @Test
    public void testSearchedCaseExpression2() {
        SearchedCaseExpression example = TestSearchedCaseExpression.example(2);
        example.setElseExpression(null);
        this.helpTest((LanguageObject)example, "CASE WHEN x = 0 THEN 0 WHEN x = 1 THEN 1 END");
    }

    @Test
    public void testSetQueryUnionOfLiteralsCase3102() {
        String expected = "SELECT 'A' AS FOO UNION SELECT 'B' AS FOO";
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new AliasSymbol("FOO", (SingleElementSymbol)new ExpressionSymbol("xxx", (Expression)new Constant((Object)"A"))));
        Query q1 = new Query();
        q1.setSelect(s1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new AliasSymbol("FOO", (SingleElementSymbol)new ExpressionSymbol("xxx", (Expression)new Constant((Object)"B"))));
        Query q2 = new Query();
        q2.setSelect(s2);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)q1, (QueryCommand)q2);
        this.helpTest((LanguageObject)sq, expected);
    }

    @Test
    public void testSetQueryUnionOfLiteralsCase3102a() {
        String expected = "SELECT 'A' AS FOO UNION SELECT 'B' AS FOO";
        Select s1 = new Select();
        s1.addSymbol((SelectSymbol)new AliasSymbol("FOO", (SingleElementSymbol)new ExpressionSymbol("xxx", (Expression)new Constant((Object)"A"))));
        Query q1 = new Query();
        q1.setSelect(s1);
        Select s2 = new Select();
        s2.addSymbol((SelectSymbol)new AliasSymbol("FOO", (SingleElementSymbol)new ExpressionSymbol("yyy", (Expression)new Constant((Object)"B"))));
        Query q2 = new Query();
        q2.setSelect(s2);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)q1, (QueryCommand)q2);
        this.helpTest((LanguageObject)sq, expected);
    }

    @Test
    public void testLimit() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit(null, (Expression)new Constant((Object)new Integer(100))));
        this.helpTest((LanguageObject)query, "SELECT * FROM a LIMIT 100");
    }

    @Test
    public void testLimitWithOffset() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Constant((Object)new Integer(50)), (Expression)new Constant((Object)new Integer(100))));
        this.helpTest((LanguageObject)query, "SELECT * FROM a LIMIT 50, 100");
    }

    @Test
    public void testUnionOrderBy() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("select pm1.g1.e1 from pm1.g1 union select e2 from pm1.g2 order by e1");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTest((LanguageObject)command, "SELECT pm1.g1.e1 FROM pm1.g1 UNION SELECT e2 FROM pm1.g2 ORDER BY e1");
    }

    @Test
    public void testUnionBranchOrderBy() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("select pm1.g1.e1 from pm1.g1 union (select e2 from pm1.g2 order by e1)");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTest((LanguageObject)command, "SELECT pm1.g1.e1 FROM pm1.g1 UNION (SELECT e2 FROM pm1.g2 ORDER BY e1)");
    }

    @Test
    public void testAliasedOrderBy() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("select pm1.g1.e1 as a from pm1.g1 order by a");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTest((LanguageObject)command, "SELECT pm1.g1.e1 AS a FROM pm1.g1 ORDER BY a");
    }

    @Test
    public void testNumberOrderBy() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("select pm1.g1.e1 as a from pm1.g1 order by 1");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTest((LanguageObject)command, "SELECT pm1.g1.e1 AS a FROM pm1.g1 ORDER BY 1");
    }

    public Expression helpTestExpression(String sql, String expected) throws QueryParserException {
        Expression expr = QueryParser.getQueryParser().parseExpression(sql);
        this.helpTest((LanguageObject)expr, expected);
        return expr;
    }

    @Test
    public void testLikeRegex() throws Exception {
        this.helpTestExpression("x like_regex 'b'", "x LIKE_REGEX 'b'");
    }

    @Test
    public void testSimilar() throws Exception {
        this.helpTestExpression("x similar to 'b' escape 'c'", "x SIMILAR TO 'b' ESCAPE 'c'");
    }
}

