/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.TestValidator;

public class TestAlterValidation {
    @Test
    public void testValidateAlterView() {
        TestValidator.helpValidate("alter view SmallA_2589 as select 2", new String[]{"SELECT 2"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestValidator.helpValidate("alter view Defect15355 as select 'a', 1", new String[]{"SELECT 'a', 1"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestValidator.helpValidate("alter view Defect15355 as select 'a', cast(1 as biginteger)", new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestValidator.helpValidate("alter view SmallA_2589 as select * from bqt1.smalla", new String[0], (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testValidateAlterViewDeep() {
        TestValidator.helpValidate("alter view Defect15355 as select xpathvalue('a', ':'), cast(1 as biginteger)", new String[]{"xpathvalue('a', ':')"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testValidateAlterTrigger() {
        TestValidator.helpValidate("alter trigger on SmallA_2589 instead of insert as for each row select 1;", new String[]{"SmallA_2589"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testValidateAlterProcedure() {
        TestValidator.helpValidate("alter procedure spTest8a as begin select 1; end", new String[]{"spTest8a"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestValidator.helpValidate("alter procedure MMSP1 as begin select 1; end", new String[]{"BEGIN\nSELECT 1;\nEND"}, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }
}

