/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.teiid.core.TeiidComponentException;

public abstract class FileStore {
    private static ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    private static final Set<PhantomReference<Object>> REFERENCES = Collections.newSetFromMap(new IdentityHashMap());
    private boolean removed;
    protected long len;

    public void setCleanupReference(Object o) {
        CleanupReference ref;
        REFERENCES.add(new CleanupReference(o, this));
        for (int i = 0; i < 10 && (ref = (CleanupReference)QUEUE.poll()) != null; ++i) {
            ref.cleanup();
            REFERENCES.remove(ref);
        }
    }

    public synchronized long getLength() {
        return this.len;
    }

    public int read(long fileOffset, byte[] b, int offSet, int length) throws TeiidComponentException {
        if (this.removed) {
            throw new TeiidComponentException("already removed");
        }
        return this.readDirect(fileOffset, b, offSet, length);
    }

    protected abstract int readDirect(long var1, byte[] var3, int var4, int var5) throws TeiidComponentException;

    public void readFully(long fileOffset, byte[] b, int offSet, int length) throws TeiidComponentException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(fileOffset + (long)n, b, offSet + n, length - n)) >= 0) continue;
            throw new TeiidComponentException("not enough bytes available");
        } while ((n += count) < length);
    }

    public void write(byte[] bytes) throws TeiidComponentException {
        this.write(bytes, 0, bytes.length);
    }

    public synchronized long write(byte[] bytes, int offset, int length) throws TeiidComponentException {
        if (this.removed) {
            throw new TeiidComponentException("already removed");
        }
        this.writeDirect(bytes, offset, length);
        long result = this.len;
        this.len += (long)length;
        return result;
    }

    protected abstract void writeDirect(byte[] var1, int var2, int var3) throws TeiidComponentException;

    public void remove() {
        if (!this.removed) {
            this.removed = true;
            this.removeDirect();
        }
    }

    protected abstract void removeDirect();

    public InputStream createInputStream(final long start, final long length) {
        return new InputStream(){
            private long offset;
            private long streamLength;
            {
                this.offset = start;
                this.streamLength = length;
            }

            @Override
            public int read() throws IOException {
                byte[] buffer = new byte[1];
                int read = this.read(buffer, 0, 1);
                if (read == -1) {
                    return -1;
                }
                return buffer[0];
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    if (this.streamLength != -1L && (long)len > this.streamLength) {
                        len = (int)this.streamLength;
                    }
                    if (this.streamLength == -1L || this.streamLength > 0L) {
                        int bytes = FileStore.this.read(this.offset, b, off, len);
                        if (bytes != -1) {
                            this.offset += (long)bytes;
                            if (this.streamLength != -1L) {
                                this.streamLength -= (long)bytes;
                            }
                        }
                        return bytes;
                    }
                    return -1;
                }
                catch (TeiidComponentException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public InputStream createInputStream(long start) {
        return this.createInputStream(start, -1L);
    }

    public OutputStream createOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new UnsupportedOperationException("buffered reading must be used");
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    FileStore.this.write(b, off, len);
                }
                catch (TeiidComponentException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public FileStoreOutputStream createOutputStream(int maxMemorySize) {
        return new FileStoreOutputStream(maxMemorySize);
    }

    static class CleanupReference
    extends PhantomReference<Object> {
        private FileStore store;

        public CleanupReference(Object referent, FileStore store) {
            super(referent, QUEUE);
            this.store = store;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            try {
                this.store.remove();
            }
            finally {
                this.clear();
            }
        }
    }

    public final class FileStoreOutputStream
    extends OutputStream {
        private byte[] buffer;
        private int count;
        private boolean bytesWritten;
        private boolean closed;

        public FileStoreOutputStream(int size) {
            this.buffer = new byte[size];
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[b], 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkOpen();
            if (len > this.buffer.length) {
                this.flushBuffer();
                this.writeDirect(b, off, len);
                return;
            }
            int bufferedLength = Math.min(len, this.buffer.length - this.count);
            if (this.count < this.buffer.length) {
                System.arraycopy(b, off, this.buffer, this.count, bufferedLength);
                this.count += bufferedLength;
                if (bufferedLength == len) {
                    return;
                }
            }
            this.flushBuffer();
            System.arraycopy(b, off + bufferedLength, this.buffer, this.count, len - bufferedLength);
            this.count += len - bufferedLength;
        }

        private void writeDirect(byte[] b, int off, int len) throws IOException {
            try {
                FileStore.this.write(b, off, len);
                this.bytesWritten = true;
            }
            catch (TeiidComponentException e) {
                throw new IOException(e);
            }
        }

        public void flushBuffer() throws IOException {
            this.checkOpen();
            if (this.count > 0) {
                this.writeDirect(this.buffer, 0, this.count);
                this.count = 0;
            }
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getCount() {
            return this.count;
        }

        public boolean bytesWritten() {
            return this.bytesWritten;
        }

        @Override
        public void flush() throws IOException {
            if (this.bytesWritten) {
                this.flushBuffer();
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.closed = true;
            this.buffer = (byte[])(this.bytesWritten ? null : Arrays.copyOf(this.buffer, this.count));
        }

        private void checkOpen() {
            if (this.closed) {
                throw new IllegalStateException("Alread closed");
            }
        }
    }
}

