/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.language.SortSpecification;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.optimizer.relational.rules.RulePushLimit;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ExecutionFactory;

public final class RuleRaiseAccess
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean afterJoinPlanning = !rules.contains(RuleConstants.PLAN_JOINS);
        boolean raisedNode = true;
        while (raisedNode) {
            raisedNode = false;
            for (PlanNode accessNode : NodeEditor.findAllNodes(plan, 1)) {
                PlanNode newRoot = RuleRaiseAccess.raiseAccessNode(plan, accessNode, metadata, capFinder, afterJoinPlanning, analysisRecord);
                if (newRoot == null) continue;
                raisedNode = true;
                plan = newRoot;
            }
        }
        return plan;
    }

    static PlanNode raiseAccessNode(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean afterJoinPlanning, AnalysisRecord record) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode parentNode = accessNode.getParent();
        if (parentNode == null) {
            return null;
        }
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return null;
        }
        switch (parentNode.getType()) {
            case 4: {
                modelID = RuleRaiseAccess.canRaiseOverJoin(modelID, parentNode, metadata, capFinder, afterJoinPlanning, record);
                if (modelID != null) {
                    RuleRaiseAccess.raiseAccessOverJoin(parentNode, modelID, true);
                    return rootNode;
                }
                return null;
            }
            case 8: {
                List projectCols = (List)parentNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (int i = 0; i < projectCols.size(); ++i) {
                    SingleElementSymbol symbol = (SingleElementSymbol)projectCols.get(i);
                    if (RuleRaiseAccess.canPushSymbol(symbol, true, modelID, metadata, capFinder, record)) continue;
                    return null;
                }
                if (FrameUtil.isProcedure(parentNode)) {
                    return null;
                }
                PlanNode orderBy = NodeEditor.findParent(parentNode, 32, 64);
                if (orderBy != null && orderBy.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) && !RuleRaiseAccess.canRaiseOverSort(accessNode, metadata, capFinder, orderBy, record, false)) {
                    return null;
                }
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 2: {
                if (!CapabilitiesUtil.supportsSelectDistinct(modelID, metadata, capFinder)) {
                    RuleRaiseAccess.recordDebug("cannot push dupremove, since distinct is not supported by source", parentNode, record);
                    return null;
                }
                if (!CapabilitiesUtil.checkElementsAreSearchable((List)NodeEditor.findNodePreOrder(parentNode, 8).getProperty(NodeConstants.Info.PROJECT_COLS), metadata, 2)) {
                    RuleRaiseAccess.recordDebug("cannot push dupremove, since not all columns are comparable at the source", parentNode, record);
                    return null;
                }
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 32: {
                if (RuleRaiseAccess.canRaiseOverSort(accessNode, metadata, capFinder, parentNode, record, false)) {
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 128: {
                LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(parentNode);
                if (RuleRaiseAccess.canRaiseOverGroupBy(parentNode, accessNode, aggregates, metadata, capFinder, record)) {
                    accessNode.getGroups().clear();
                    accessNode.getGroups().addAll(parentNode.getGroups());
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 256: {
                if (!RuleRaiseAccess.canRaiseOverSetQuery(parentNode, metadata, capFinder)) {
                    return null;
                }
                for (PlanNode node : new ArrayList<PlanNode>(parentNode.getChildren())) {
                    if (node == accessNode) continue;
                    NodeEditor.removeChildNode(parentNode, node);
                }
                accessNode.getGroups().clear();
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 16: {
                JoinType jt;
                if (parentNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
                    return null;
                }
                if (RuleRaiseAccess.canRaiseOverSelect(accessNode, metadata, capFinder, parentNode, record)) {
                    RulePushSelectCriteria.satisfyAccessPatterns(parentNode, accessNode);
                    return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                }
                if (parentNode.getParent() == null) {
                    return null;
                }
                PlanNode selectRoot = parentNode;
                while (selectRoot.getParent() != null && selectRoot.getParent().getType() == 16) {
                    selectRoot = selectRoot.getParent();
                }
                if (selectRoot.getParent() == null || (selectRoot.getParent().getType() & 0x88) == selectRoot.getParent().getType()) {
                    return null;
                }
                PlanNode grandParent = selectRoot.getParent();
                boolean isLeft = false;
                boolean bl = isLeft = grandParent.getFirstChild() == selectRoot;
                if (grandParent.getType() == 4 && ((jt = (JoinType)grandParent.getProperty(NodeConstants.Info.JOIN_TYPE)) == JoinType.JOIN_FULL_OUTER || jt == JoinType.JOIN_LEFT_OUTER && !isLeft)) {
                    return null;
                }
                grandParent.removeChild(selectRoot);
                if (isLeft) {
                    grandParent.addFirstChild(accessNode);
                } else {
                    grandParent.addLastChild(accessNode);
                }
                PlanNode newParent = grandParent.getParent();
                PlanNode newRoot = RuleRaiseAccess.raiseAccessNode(rootNode, accessNode, metadata, capFinder, afterJoinPlanning, record);
                if (newRoot == null) {
                    parentNode.addFirstChild(accessNode);
                    if (isLeft) {
                        grandParent.addFirstChild(selectRoot);
                    } else {
                        grandParent.addLastChild(selectRoot);
                    }
                } else {
                    accessNode = grandParent.getParent();
                    if (newParent != null) {
                        boolean bl2 = isLeft = newParent.getFirstChild() == accessNode;
                        if (isLeft) {
                            newParent.addFirstChild(selectRoot);
                        } else {
                            newParent.addLastChild(selectRoot);
                        }
                    } else {
                        newRoot = selectRoot;
                    }
                    parentNode.addFirstChild(accessNode);
                    return newRoot;
                }
                return null;
            }
            case 64: {
                if (parentNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                    return null;
                }
                SymbolMap references = (SymbolMap)parentNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                if (references != null) {
                    return null;
                }
                PlanNode parentProject = NodeEditor.findParent(parentNode, 8);
                GroupSymbol intoGroup = (GroupSymbol)parentProject.getProperty(NodeConstants.Info.INTO_GROUP);
                if (intoGroup != null && parentProject.getParent() == null) {
                    if (CapabilitiesUtil.supports(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, modelID, metadata, capFinder) && CapabilitiesUtil.isSameConnector(modelID, metadata.getModelID(intoGroup.getMetadataID()), metadata, capFinder)) {
                        rootNode = RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
                        return RuleRaiseAccess.performRaise(rootNode, accessNode, parentProject);
                    }
                    return null;
                }
                if (!CapabilitiesUtil.supportsInlineView(modelID, metadata, capFinder)) {
                    return null;
                }
                if (FrameUtil.getNonQueryCommand(accessNode) != null || FrameUtil.getNestedPlan(accessNode) != null) {
                    return null;
                }
                parentNode.setProperty(NodeConstants.Info.INLINE_VIEW, Boolean.TRUE);
                accessNode.getGroups().clear();
                accessNode.addGroups(parentNode.getGroups());
                RulePlaceAccess.copyDependentHints(parentNode, accessNode);
                return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
            }
            case 1024: {
                return RulePushLimit.raiseAccessOverLimit(rootNode, accessNode, metadata, capFinder, parentNode);
            }
        }
        return null;
    }

    static boolean canRaiseOverGroupBy(PlanNode groupNode, PlanNode accessNode, Collection<? extends SingleElementSymbol> aggregates, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        List groupCols = (List)groupNode.getProperty(NodeConstants.Info.GROUP_COLS);
        if (!CapabilitiesUtil.supportsAggregates(groupCols, modelID, metadata, capFinder)) {
            RuleRaiseAccess.recordDebug("cannot push group by, since group by is not supported by source", groupNode, record);
            return false;
        }
        if (groupCols != null) {
            for (Expression expression : groupCols) {
                if (RuleRaiseAccess.canPushSymbol(expression, false, modelID, metadata, capFinder, record)) continue;
                return false;
            }
        }
        if (aggregates != null) {
            for (SingleElementSymbol singleElementSymbol : aggregates) {
                if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject(singleElementSymbol, modelID, metadata, capFinder, record)) continue;
                return false;
            }
        }
        return CapabilitiesUtil.checkElementsAreSearchable(groupCols, metadata, 2);
    }

    private static void recordDebug(String message, PlanNode node, AnalysisRecord record) {
        if (record != null && record.recordDebug()) {
            record.println(message + " " + node.nodeToString());
        }
    }

    static boolean canRaiseOverSort(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode, AnalysisRecord record, boolean compensateForUnrelated) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        List<OrderByItem> sortCols = ((OrderBy)parentNode.getProperty(NodeConstants.Info.SORT_ORDER)).getOrderByItems();
        for (OrderByItem symbol : sortCols) {
            if (!RuleRaiseAccess.canPushSymbol(symbol.getSymbol(), true, modelID, metadata, capFinder, record)) {
                return false;
            }
            boolean supportsNullOrdering = CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, modelID, metadata, capFinder);
            ExecutionFactory.NullOrder defaultNullOrder = CapabilitiesUtil.getDefaultNullOrder(modelID, metadata, capFinder);
            if (symbol.getNullOrdering() != null) {
                if (supportsNullOrdering) continue;
                if (symbol.getNullOrdering() == SortSpecification.NullOrdering.FIRST ? !(defaultNullOrder == ExecutionFactory.NullOrder.FIRST || symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.LOW || !symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.HIGH) : !(defaultNullOrder == ExecutionFactory.NullOrder.LAST || symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.HIGH || !symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.LOW)) {
                    return false;
                }
                symbol.setNullOrdering(null);
                continue;
            }
            if (!supportsNullOrdering || defaultNullOrder == ExecutionFactory.NullOrder.LOW) continue;
            if (symbol.isAscending()) {
                if (defaultNullOrder == ExecutionFactory.NullOrder.FIRST) continue;
                symbol.setNullOrdering(SortSpecification.NullOrdering.FIRST);
                continue;
            }
            if (defaultNullOrder == ExecutionFactory.NullOrder.LAST) continue;
            symbol.setNullOrdering(SortSpecification.NullOrdering.LAST);
        }
        if (accessNode.getLastChild() != null) {
            if (accessNode.getLastChild().getType() == 256) {
                return CapabilitiesUtil.supportsSetQueryOrderBy(modelID, metadata, capFinder);
            }
            if (accessNode.getLastChild().getType() == 1024) {
                return false;
            }
        }
        if (!CapabilitiesUtil.checkElementsAreSearchable(sortCols, metadata, 2)) {
            return false;
        }
        if (!CapabilitiesUtil.supportsOrderBy(modelID, metadata, capFinder)) {
            return false;
        }
        return !parentNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) || CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, modelID, metadata, capFinder) || NodeEditor.findParent(accessNode, 8, 64) != null || compensateForUnrelated;
    }

    static boolean canRaiseOverSelect(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (parentNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) {
            return true;
        }
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return false;
        }
        if (parentNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_HAVING, modelID, metadata, capFinder)) {
            RuleRaiseAccess.recordDebug("cannot push having, since having is not supported by source", parentNode, record);
            return false;
        }
        PlanNode limitNode = NodeEditor.findNodePreOrder(accessNode, 1024, 64);
        if (limitNode != null && FrameUtil.isOrderedLimit(limitNode)) {
            return false;
        }
        Criteria crit = (Criteria)parentNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(crit, modelID, metadata, capFinder, record)) {
            return false;
        }
        return accessNode.getFirstChild() == null || accessNode.getFirstChild().getType() != 256;
    }

    private static boolean canPushSymbol(Expression symbol, boolean inSelectClause, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record) throws TeiidComponentException, QueryMetadataException {
        Expression expr = SymbolMap.getExpression(symbol);
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(expr, modelID, metadata, capFinder, record)) {
            return false;
        }
        return !inSelectClause || expr instanceof ElementSymbol || expr instanceof AggregateSymbol || CapabilitiesUtil.supportsSelectExpression(modelID, metadata, capFinder);
    }

    static PlanNode performRaise(PlanNode rootNode, PlanNode accessNode, PlanNode parentNode) {
        accessNode.removeProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        NodeEditor.removeChildNode(parentNode, accessNode);
        parentNode.addAsParent(accessNode);
        PlanNode grandparentNode = accessNode.getParent();
        if (grandparentNode != null) {
            return rootNode;
        }
        return accessNode;
    }

    private static Object canRaiseOverJoin(Object modelId, PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean afterJoinPlanning, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        JoinType jt;
        List crits = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        JoinType type = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!afterJoinPlanning && type == JoinType.JOIN_CROSS && joinNode.getParent().getType() == 4 && !(jt = (JoinType)joinNode.getParent().getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter()) {
            return null;
        }
        if (joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null) {
            return null;
        }
        if (joinNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            return null;
        }
        if (type.isOuter() && CapabilitiesUtil.getSupportedJoinCriteria(modelId, metadata, capFinder) != ExecutionFactory.SupportedJoinCriteria.ANY) {
            PlanNode critNode = NodeEditor.findNodePreOrder(joinNode.getLastChild(), 16, 64);
            if (critNode != null) {
                return null;
            }
            if (type == JoinType.JOIN_FULL_OUTER && (critNode = NodeEditor.findNodePreOrder(joinNode.getFirstChild(), 16, 64)) != null) {
                return null;
            }
        }
        return RuleRaiseAccess.canRaiseOverJoin(joinNode.getChildren(), metadata, capFinder, crits, type, record);
    }

    static Object canRaiseOverJoin(List<PlanNode> children, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, List<Criteria> crits, JoinType type, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        if (children.size() != 2) {
            return null;
        }
        Object modelID = null;
        HashSet<Object> groupIDs = new HashSet<Object>();
        int groupCount = 0;
        LinkedList<CompareCriteria> thetaCriteria = new LinkedList<CompareCriteria>();
        ExecutionFactory.SupportedJoinCriteria sjc = null;
        for (PlanNode childNode : children) {
            if (childNode.getType() != 1 || childNode.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                return null;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(childNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            groupCount += childNode.getGroups().size();
            boolean supportsSelfJoins = CapabilitiesUtil.supportsSelfJoins(accessModelID, metadata, capFinder);
            if (!supportsSelfJoins) {
                for (GroupSymbol groupSymbol : childNode.getGroups()) {
                    Object groupID = groupSymbol.getMetadataID();
                    if (groupIDs.add(groupID)) continue;
                    return null;
                }
            }
            if (modelID == null) {
                if (!CapabilitiesUtil.supportsJoin(accessModelID, type, metadata, capFinder)) {
                    return null;
                }
                sjc = CapabilitiesUtil.getSupportedJoinCriteria(accessModelID, metadata, capFinder);
                if (sjc == ExecutionFactory.SupportedJoinCriteria.KEY && children.get(0).getGroups().size() != 1) {
                    return null;
                }
                if (crits != null && !crits.isEmpty()) {
                    for (Criteria crit : crits) {
                        if (!RuleRaiseAccess.isSupportedJoinCriteria(sjc, crit, accessModelID, metadata, capFinder, record)) {
                            CompareCriteria cc;
                            if (crit instanceof CompareCriteria && (cc = (CompareCriteria)crit).isOptional()) {
                                cc.setOptional(true);
                                continue;
                            }
                            return null;
                        }
                        if (!(crit instanceof CompareCriteria)) continue;
                        thetaCriteria.add((CompareCriteria)crit);
                    }
                    if (sjc == ExecutionFactory.SupportedJoinCriteria.KEY) {
                        LinkedList<Expression> leftExpressions = new LinkedList<Expression>();
                        LinkedList<Expression> rightExpressions = new LinkedList<Expression>();
                        RuleChooseJoinStrategy.separateCriteria(children.get(0).getGroups(), children.get(1).getGroups(), leftExpressions, rightExpressions, crits, new LinkedList<Criteria>());
                        ArrayList<Object> leftIds = new ArrayList<Object>(leftExpressions.size());
                        ArrayList<Object> rightIds = new ArrayList<Object>(rightExpressions.size());
                        for (Expression expr : leftExpressions) {
                            if (!(expr instanceof ElementSymbol)) continue;
                            leftIds.add(((ElementSymbol)expr).getMetadataID());
                        }
                        GroupSymbol rightGroup = null;
                        for (Expression expr : rightExpressions) {
                            if (!(expr instanceof ElementSymbol)) continue;
                            ElementSymbol es = (ElementSymbol)expr;
                            if (rightGroup == null) {
                                rightGroup = es.getGroupSymbol();
                            } else if (!rightGroup.equals(es.getGroupSymbol())) {
                                return null;
                            }
                            rightIds.add(es.getMetadataID());
                        }
                        if (rightGroup == null) {
                            return null;
                        }
                        if (!RuleRaiseAccess.matchesForeignKey(metadata, leftIds, rightIds, children.get(0).getGroups().iterator().next(), true) && !RuleRaiseAccess.matchesForeignKey(metadata, rightIds, leftIds, rightGroup, true)) {
                            return null;
                        }
                    }
                } else if (sjc != ExecutionFactory.SupportedJoinCriteria.ANY) {
                    return null;
                }
                modelID = accessModelID;
                continue;
            }
            if (CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) continue;
            return null;
        }
        int maxGroups = CapabilitiesUtil.getMaxFromGroups(modelID, metadata, capFinder);
        if (maxGroups != -1 && maxGroups < groupCount) {
            return null;
        }
        if (sjc == ExecutionFactory.SupportedJoinCriteria.KEY) {
            for (CompareCriteria criteria : thetaCriteria) {
                criteria.setOptional(false);
            }
        } else {
            boolean hasCriteria = false;
            for (CompareCriteria criteria : thetaCriteria) {
                if (criteria.getIsOptional() == null || !hasCriteria && criteria.getIsOptional().booleanValue()) {
                    criteria.setOptional(false);
                }
                hasCriteria = true;
            }
        }
        return modelID;
    }

    static boolean isSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria sjc, Criteria crit, Object accessModelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(crit, accessModelID, metadata, capFinder, record)) {
            return false;
        }
        if (sjc == ExecutionFactory.SupportedJoinCriteria.ANY) {
            return true;
        }
        if (!(crit instanceof CompareCriteria)) {
            return false;
        }
        CompareCriteria cc = (CompareCriteria)crit;
        if (!(cc.getLeftExpression() instanceof ElementSymbol)) {
            return false;
        }
        if (!(cc.getRightExpression() instanceof ElementSymbol)) {
            return false;
        }
        if (sjc == ExecutionFactory.SupportedJoinCriteria.THETA) {
            return true;
        }
        return cc.getOperator() == 1;
    }

    public static boolean matchesForeignKey(QueryMetadataInterface metadata, Collection<Object> leftIds, Collection<Object> rightIds, GroupSymbol leftGroup, boolean exact) throws TeiidComponentException, QueryMetadataException {
        Collection fks = metadata.getForeignKeysInGroup(leftGroup.getMetadataID());
        for (Object fk : fks) {
            List fkColumns = metadata.getElementIDsInKey(fk);
            if (exact && leftIds.size() != fkColumns.size() || !leftIds.containsAll(fkColumns)) continue;
            Object pk = metadata.getPrimaryKeyIDForForeignKeyID(fk);
            List pkColumns = metadata.getElementIDsInKey(pk);
            if (exact && rightIds.size() != pkColumns.size() || !rightIds.containsAll(pkColumns)) continue;
            return true;
        }
        return false;
    }

    static PlanNode raiseAccessOverJoin(PlanNode joinNode, Object modelID, boolean insert) {
        PlanNode leftAccess = joinNode.getFirstChild();
        PlanNode rightAccess = joinNode.getLastChild();
        NodeEditor.removeChildNode(joinNode, leftAccess);
        NodeEditor.removeChildNode(joinNode, rightAccess);
        joinNode.setProperty(NodeConstants.Info.MODEL_ID, modelID);
        PlanNode newAccess = NodeFactory.getNewNode(1);
        newAccess.setProperty(NodeConstants.Info.MODEL_ID, modelID);
        newAccess.addGroups(rightAccess.getGroups());
        newAccess.addGroups(leftAccess.getGroups());
        RuleRaiseAccess.combineHint(leftAccess, rightAccess, newAccess, NodeConstants.Info.MAKE_DEP);
        RuleRaiseAccess.combineHint(leftAccess, rightAccess, newAccess, NodeConstants.Info.MAKE_IND);
        RulePlaceAccess.copyDependentHints(leftAccess, newAccess);
        RulePlaceAccess.copyDependentHints(rightAccess, newAccess);
        RulePlaceAccess.copyDependentHints(joinNode, newAccess);
        if (insert) {
            joinNode.addAsParent(newAccess);
        } else {
            newAccess.addFirstChild(joinNode);
        }
        return newAccess;
    }

    private static void combineHint(PlanNode leftAccess, PlanNode rightAccess, PlanNode newAccess, NodeConstants.Info info) {
        Object leftHint = leftAccess.getProperty(info);
        if (leftHint != null) {
            newAccess.setProperty(info, leftHint);
        } else {
            Object rightHint = rightAccess.getProperty(info);
            if (rightHint != null) {
                newAccess.setProperty(info, rightHint);
            }
        }
    }

    static Object getModelIDFromAccess(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Object accessModelID = accessNode.getProperty(NodeConstants.Info.MODEL_ID);
        if (accessModelID == null && accessNode.getGroups().size() > 0) {
            GroupSymbol group = accessNode.getGroups().iterator().next();
            if (metadata.isVirtualGroup(group.getMetadataID())) {
                return null;
            }
            accessModelID = metadata.getModelID(group.getMetadataID());
            accessNode.setProperty(NodeConstants.Info.MODEL_ID, accessModelID);
        }
        return accessModelID;
    }

    private static boolean canRaiseOverSetQuery(PlanNode setOpNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        Object modelID = null;
        for (PlanNode childNode : setOpNode.getChildren()) {
            if (childNode.getType() != 1) {
                return false;
            }
            if (FrameUtil.getNonQueryCommand(childNode) != null || FrameUtil.getNestedPlan(childNode) != null) {
                return false;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(childNode, metadata);
            if (accessModelID == null) {
                return false;
            }
            if (modelID == null) {
                modelID = accessModelID;
                if (!CapabilitiesUtil.supportsSetOp(accessModelID, (SetQuery.Operation)((Object)setOpNode.getProperty(NodeConstants.Info.SET_OPERATION)), metadata, capFinder)) {
                    return false;
                }
            } else if (!CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) {
                return false;
            }
            if (setOpNode.hasBooleanProperty(NodeConstants.Info.USE_ALL) || CapabilitiesUtil.checkElementsAreSearchable((List)NodeEditor.findNodePreOrder(childNode, 8).getProperty(NodeConstants.Info.PROJECT_COLS), metadata, 2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "RaiseAccess";
    }
}

