/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.logging.LogManager;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.SourceNodePlannerVisitor;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.optimizer.xml.XMLQueryPlanner;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class XMLStagaingQueryPlanner {
    static void stageQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            @Override
            public void visit(MappingSourceNode sourceNode) {
                try {
                    XMLStagaingQueryPlanner.stagePlannedQuery(sourceNode, planEnv);
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        XMLStagaingQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor(walker);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }

    static boolean stagePlannedQuery(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException, QueryParserException {
        Option option = planEnv.xmlCommand.getOption();
        if (sourceNode.isRootSourceNode()) {
            return false;
        }
        if (sourceNode.getAliasResultName() != null) {
            return false;
        }
        String groupName = sourceNode.getActualResultSetName();
        ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
        if (rsInfo.hasInputSet() && !rsInfo.isCriteriaRaised()) {
            return false;
        }
        QueryNode queryNode = QueryUtil.getQueryNode(groupName, planEnv.getGlobalMetadata());
        if (queryNode.getBindings() != null && !queryNode.getBindings().isEmpty()) {
            return false;
        }
        Query stagableQuery = (Query)QueryUtil.getQueryFromQueryNode(groupName, planEnv);
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)stagableQuery, false);
        if (groups.size() == 1) {
            GroupSymbol group = groups.iterator().next();
            if (planEnv.isStagingTable((group = QueryUtil.createResolvedGroup(group.clone(), (QueryMetadataInterface)planEnv.getGlobalMetadata())).getMetadataID()) && stagableQuery.getCriteria() == null) {
                return false;
            }
        }
        Criteria crit = ((Query)rsInfo.getCommand()).getCriteria();
        GroupSymbol parent = null;
        LinkedHashSet<ElementSymbol> outerReferences = new LinkedHashSet<ElementSymbol>();
        LinkedHashSet<ElementSymbol> fkColumns = new LinkedHashSet<ElementSymbol>();
        for (Criteria conjunct : Criteria.separateCriteriaByAnd(crit)) {
            CompareCriteria cc;
            if (!(conjunct instanceof CompareCriteria) || (cc = (CompareCriteria)conjunct).getOperator() != 1 || !(cc.getLeftExpression() instanceof ElementSymbol) || !(cc.getRightExpression() instanceof ElementSymbol)) continue;
            ElementSymbol les = (ElementSymbol)cc.getLeftExpression();
            ElementSymbol res = (ElementSymbol)cc.getRightExpression();
            if (les.getGroupSymbol().getNonCorrelationName().equalsIgnoreCase(groupName)) {
                parent = res.getGroupSymbol();
                outerReferences.add(res.clone());
                fkColumns.add(les.clone());
                continue;
            }
            if (!res.getGroupSymbol().getNonCorrelationName().equalsIgnoreCase(groupName)) continue;
            parent = les.getGroupSymbol();
            outerReferences.add(les.clone());
            fkColumns.add(res.clone());
        }
        String stagingGroupName = planEnv.getStagedResultName(groupName);
        boolean recursive = false;
        for (MappingSourceNode msn = sourceNode; !recursive && msn != null; msn = msn.getParentSourceNode()) {
            MappingNode mappingNode = msn.getChildren().get(0);
            if (!(mappingNode instanceof MappingBaseNode)) continue;
            recursive = ((MappingBaseNode)mappingNode).isRootRecursiveNode();
        }
        if (parent != null && !recursive) {
            boolean parentStaged;
            stagableQuery = (Query)stagableQuery.clone();
            String parentName = parent.getNonCorrelationName();
            String parentStagingName = planEnv.getStagedResultName(parentName);
            GroupSymbol parentTempTable = new GroupSymbol(XMLQueryPlanner.getTempTableName(parentStagingName));
            ResultSetInfo parentRsInfo = planEnv.getStagingTableResultsInfo(parentStagingName);
            String stagingRoot = sourceNode.getParentSourceNode().getSource();
            boolean bl = parentStaged = parentRsInfo.getPlan() != null;
            if (!parentStaged) {
                parentRsInfo = sourceNode.getParentSourceNode().getResultSetInfo();
                if (parentRsInfo.getTempTable() == null) {
                    List<SingleElementSymbol> projectedSymbols = parentRsInfo.getCommand().getProjectedSymbols();
                    ArrayList<SingleElementSymbol> elements = new ArrayList<SingleElementSymbol>(projectedSymbols.size());
                    for (SingleElementSymbol singleElementSymbol : projectedSymbols) {
                        singleElementSymbol = (SingleElementSymbol)singleElementSymbol.clone();
                        ResolverVisitor.resolveLanguageObject(singleElementSymbol, planEnv.getGlobalMetadata());
                        elements.add(singleElementSymbol);
                    }
                    TempMetadataStore store = planEnv.getGlobalMetadata().getMetadataStore();
                    GroupSymbol newGroup = new GroupSymbol(SourceNodePlannerVisitor.getNewName("#" + planEnv.getAliasName(parentName) + "_RS", store));
                    newGroup.setMetadataID(store.addTempGroup(newGroup.getName(), elements, false, true));
                    parentStagingName = newGroup.getName();
                    parentTempTable = newGroup;
                } else {
                    parentStagingName = parentRsInfo.getTempTable();
                    parentTempTable = new GroupSymbol(parentRsInfo.getTempTable());
                    parentStaged = true;
                }
            } else {
                stagingRoot = parentRsInfo.getStagingRoot();
            }
            Query query = new Query();
            query.setSelect(new Select(Arrays.asList(new ExpressionSymbol("expr", new Constant(1)))));
            query.setFrom(new From(Arrays.asList(new UnaryFromClause(parentTempTable))));
            HashMap symbolMap = new HashMap();
            String inlineViewName = planEnv.getAliasName(rsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, rsInfo.getResultSetName(), inlineViewName, planEnv.getGlobalMetadata());
            XMLQueryPlanner.updateSymbolMap(symbolMap, parentName, parentTempTable.getName(), planEnv.getGlobalMetadata());
            crit = (Criteria)crit.clone();
            ExpressionMappingVisitor.mapExpressions(crit, symbolMap);
            if (!stagableQuery.getSelect().isDistinct()) {
                query.setHaving(crit);
                query.setGroupBy(new GroupBy(new ArrayList(outerReferences)));
                ExpressionMappingVisitor.mapExpressions(query.getGroupBy(), symbolMap);
            } else {
                query.setCriteria(crit);
            }
            ExistsCriteria ec = new ExistsCriteria();
            ec.setSubqueryHint(new ExistsCriteria.SubqueryHint());
            ec.getSubqueryHint().setDepJoin(true);
            ec.setCommand(query);
            Criteria existing = stagableQuery.getCriteria();
            stagableQuery.setCriteria(Criteria.combineCriteria(existing, ec));
            if (!XMLQueryPlanner.planStagaingQuery(false, groupName, stagingGroupName, stagableQuery, planEnv)) {
                return false;
            }
            if (!parentStaged) {
                Insert insert = new Insert();
                insert.setGroup(parentTempTable);
                int valCount = parentRsInfo.getCommand().getProjectedSymbols().size();
                ArrayList<Reference> vals = new ArrayList<Reference>(valCount);
                for (int i = 0; i < valCount; ++i) {
                    vals.add(new Reference(i + 1));
                }
                insert.setValues(vals);
                QueryResolver.resolveCommand(insert, planEnv.getGlobalMetadata());
                Command tempCommand = QueryParser.getQueryParser().parseCommand("select * from " + parentStagingName);
                QueryResolver.resolveCommand(tempCommand, planEnv.getGlobalMetadata());
                Command dropCommand = QueryParser.getQueryParser().parseCommand("drop table " + parentStagingName);
                QueryResolver.resolveCommand(dropCommand, planEnv.getGlobalMetadata());
                parentRsInfo.setTempTable(parentStagingName);
                parentRsInfo.setTempSelect(tempCommand);
                parentRsInfo.setTempInsert(insert);
                parentRsInfo.setTempDrop(dropCommand);
            }
            LogManager.logDetail((String)"org.teiid.PLANNER.XML_PLANNER", (Object[])new Object[]{"Using a dependent join to load the mapping class", groupName});
            sourceNode.addStagingTable(stagingGroupName);
            GroupSymbol tempGroup = new GroupSymbol(XMLQueryPlanner.getTempTableName(stagingGroupName));
            ResolverUtil.resolveGroup(tempGroup, planEnv.getGlobalMetadata());
            List<GroupSymbol> temp = Arrays.asList(tempGroup);
            ArrayList<ElementSymbol> fk = new ArrayList<ElementSymbol>(fkColumns.size());
            for (ElementSymbol elementSymbol : fkColumns) {
                ElementSymbol es = new ElementSymbol(elementSymbol.getShortName());
                ResolverVisitor.resolveLanguageObject(es, temp, planEnv.getGlobalMetadata());
                fk.add(es);
            }
            ResultSetInfo stagedInfo = planEnv.getStagingTableResultsInfo(stagingGroupName);
            stagedInfo.setStagingRoot(stagingRoot);
            stagedInfo.setAutoStaged(true);
            stagedInfo.setFkColumns(fk);
            stagedInfo.setTempTable(tempGroup.getName());
            rsInfo.setAutoStaged(true);
            return true;
        }
        Object metadataID = planEnv.getGlobalMetadata().getGroupID(sourceNode.getResultName());
        if (RelationalPlanner.isNoCacheGroup(planEnv.getGlobalMetadata(), metadataID, option)) {
            return false;
        }
        metadataID = planEnv.getGlobalMetadata().getGroupID(sourceNode.getActualResultSetName());
        if (RelationalPlanner.isNoCacheGroup(planEnv.getGlobalMetadata(), metadataID, option)) {
            return false;
        }
        if (!XMLQueryPlanner.planStagaingQuery(true, groupName, stagingGroupName, stagableQuery = (Query)stagableQuery.clone(), planEnv)) {
            return false;
        }
        sourceNode.addStagingTable(stagingGroupName);
        ResultSetInfo stagedInfo = planEnv.getStagingTableResultsInfo(stagingGroupName);
        stagedInfo.setAutoStaged(true);
        stagedInfo.setTempTable(XMLQueryPlanner.getTempTableName(stagingGroupName));
        rsInfo.setAutoStaged(true);
        return true;
    }
}

