/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBrowser;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SourceState;
import org.teiid.query.sql.symbol.ElementSymbol;

public class EnhancedSortMergeJoinStrategy
extends MergeJoinStrategy {
    private boolean semiDep;
    private TupleSource currentSource;
    private SourceState sortedSource;
    private SourceState notSortedSource;
    private List<?> currentTuple;
    private TupleBrowser tb;
    private int reserved;
    private STree index;
    private int[] reverseIndexes;
    private List<?> sortedTuple;
    private boolean repeatedMerge;
    private boolean validSemiDep;
    private int preferMemCutoff = 8;

    public EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption sortLeft, MergeJoinStrategy.SortOption sortRight) {
        super(sortLeft, sortRight, false);
    }

    public void setPreferMemCutoff(int cutoff) {
        this.preferMemCutoff = cutoff;
    }

    @Override
    public void close() {
        if (this.joinNode == null) {
            return;
        }
        super.close();
        if (this.index != null) {
            this.index.remove();
        }
        this.releaseReserved();
        this.index = null;
        this.tb = null;
        this.currentSource = null;
        this.sortedSource = null;
        this.notSortedSource = null;
        this.sortedTuple = null;
        this.reverseIndexes = null;
    }

    public void createIndex(SourceState state, boolean sorted) throws TeiidComponentException, TeiidProcessingException {
        int keyLength = state.getExpressionIndexes().length;
        List elements = state.getSource().getOutputElements();
        int[] reorderedSortIndex = Arrays.copyOf(state.getExpressionIndexes(), elements.size());
        HashSet<Integer> used = new HashSet<Integer>();
        for (int i : state.getExpressionIndexes()) {
            used.add(i);
        }
        int j = state.getExpressionIndexes().length;
        for (int i = 0; i < elements.size(); ++i) {
            if (used.contains(i)) continue;
            reorderedSortIndex[j++] = i;
        }
        List reordered = RelationalNode.projectTuple(reorderedSortIndex, elements);
        if (!state.isDistinct()) {
            reordered = new ArrayList(reordered);
            ElementSymbol id = new ElementSymbol("rowId");
            id.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            reordered.add(keyLength, id);
            ++keyLength;
        }
        this.index = this.joinNode.getBufferManager().createSTree(reordered, this.joinNode.getConnectionID(), keyLength);
        this.index.setPreferMemory(true);
        if (!state.isDistinct()) {
            this.index.getComparator().setDistinctIndex(keyLength - 2);
        }
        IndexedTupleSource its = state.getTupleBuffer().createIndexedTupleSource(!this.joinNode.isDependent());
        int rowId = 0;
        List<?> lastTuple = null;
        boolean sortedDistinct = sorted && !state.isDistinct();
        int sizeHint = this.index.getExpectedHeight(state.getTupleBuffer().getRowCount());
        block2: while (its.hasNext()) {
            List<?> originalTuple = its.nextTuple();
            for (int i : state.getExpressionIndexes()) {
                if (originalTuple.get(i) == null) continue block2;
            }
            if (sortedDistinct && lastTuple != null && this.compare(lastTuple, originalTuple, state.getExpressionIndexes(), state.getExpressionIndexes()) == 0) {
                sortedDistinct = false;
            }
            lastTuple = originalTuple;
            List<?> tuple = RelationalNode.projectTuple(reorderedSortIndex, originalTuple);
            if (!state.isDistinct()) {
                tuple.add(keyLength - 1, rowId++);
            }
            this.index.insert(tuple, sorted ? STree.InsertMode.ORDERED : STree.InsertMode.NEW, sizeHint);
        }
        if (!sorted) {
            this.index.compact();
        }
        its.closeSource();
        this.reverseIndexes = new int[elements.size()];
        for (int i = 0; i < this.reverseIndexes.length; ++i) {
            int oldIndex = reorderedSortIndex[i];
            this.reverseIndexes[oldIndex] = i + (!state.isDistinct() && i >= keyLength - 1 ? 1 : 0);
        }
        if (!state.isDistinct() && (!sorted && this.index.getComparator().isDistinct() || sorted && sortedDistinct)) {
            this.index.removeRowIdFromKey();
            state.markDistinct(true);
        }
    }

    @Override
    protected void loadLeft() throws TeiidComponentException, TeiidProcessingException {
        if (this.joinNode.isDependent()) {
            this.leftSource.getTupleBuffer();
        }
    }

    private boolean shouldIndexIfSmall(SourceState source) throws TeiidComponentException, TeiidProcessingException {
        Number cardinality = source.getSource().getEstimateNodeCardinality();
        return (source.hasBuffer() || cardinality != null && cardinality.floatValue() != -1.0f && cardinality.floatValue() <= (float)this.joinNode.getBatchSize()) && source.getRowCount() <= this.joinNode.getBatchSize();
    }

    @Override
    protected void loadRight() throws TeiidComponentException, TeiidProcessingException {
        if (this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.shouldIndexIfSmall(this.leftSource)) {
            this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
        } else if (!this.leftSource.hasBuffer() && this.processingSortLeft == MergeJoinStrategy.SortOption.SORT && this.shouldIndexIfSmall(this.rightSource)) {
            this.processingSortLeft = MergeJoinStrategy.SortOption.NOT_SORTED;
        } else {
            this.leftSource.getTupleBuffer();
            if (!this.rightSource.hasBuffer() && this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.shouldIndexIfSmall(this.leftSource)) {
                this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
            } else if (this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.shouldIndex(this.leftSource, this.rightSource)) {
                this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
            } else if (this.processingSortLeft == MergeJoinStrategy.SortOption.SORT && this.shouldIndex(this.rightSource, this.leftSource)) {
                this.processingSortLeft = MergeJoinStrategy.SortOption.NOT_SORTED;
            }
        }
        if (this.processingSortLeft != MergeJoinStrategy.SortOption.NOT_SORTED && this.processingSortRight != MergeJoinStrategy.SortOption.NOT_SORTED) {
            super.loadRight();
            super.loadLeft();
            return;
        }
        if (this.processingSortLeft == MergeJoinStrategy.SortOption.NOT_SORTED) {
            this.sortedSource = this.rightSource;
            this.notSortedSource = this.leftSource;
            if (!this.repeatedMerge) {
                this.createIndex(this.rightSource, this.processingSortRight == MergeJoinStrategy.SortOption.ALREADY_SORTED);
            } else {
                super.loadRight();
                this.notSortedSource.sort(MergeJoinStrategy.SortOption.NOT_SORTED);
            }
        } else if (this.processingSortRight == MergeJoinStrategy.SortOption.NOT_SORTED) {
            this.sortedSource = this.leftSource;
            this.notSortedSource = this.rightSource;
            if (this.semiDep && this.leftSource.isDistinct()) {
                this.rightSource.getTupleBuffer();
                if (!this.joinNode.getDependentValueSource().isUnused()) {
                    this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
                    this.validSemiDep = true;
                    return;
                }
            }
            if (!this.repeatedMerge) {
                this.createIndex(this.leftSource, this.processingSortLeft == MergeJoinStrategy.SortOption.ALREADY_SORTED);
            } else {
                super.loadLeft();
                this.notSortedSource.sort(MergeJoinStrategy.SortOption.NOT_SORTED);
            }
        }
    }

    private boolean shouldIndex(SourceState possibleIndex, SourceState other) throws TeiidComponentException, TeiidProcessingException {
        if (possibleIndex.getRowCount() * 4 > other.getRowCount()) {
            return false;
        }
        int schemaSize = this.joinNode.getBufferManager().getSchemaSize(other.getSource().getOutputElements());
        int toReserve = this.joinNode.getBufferManager().getMaxProcessingKB();
        if (other.getRowCount() <= this.joinNode.getBatchSize() || possibleIndex.getRowCount() > this.joinNode.getBatchSize() && other.getRowCount() / this.joinNode.getBatchSize() < toReserve / schemaSize) {
            return false;
        }
        boolean useIndex = false;
        int indexSchemaSize = this.joinNode.getBufferManager().getSchemaSize(possibleIndex.getSource().getOutputElements());
        toReserve = (int)((double)(indexSchemaSize * possibleIndex.getTupleBuffer().getRowCount()) / ((double)possibleIndex.getTupleBuffer().getBatchSize() * 0.5));
        if (toReserve < this.joinNode.getBufferManager().getMaxProcessingKB()) {
            useIndex = true;
        } else if (possibleIndex.getTupleBuffer().getRowCount() / this.joinNode.getBatchSize() < this.preferMemCutoff) {
            useIndex = true;
        }
        if (useIndex) {
            this.reserved = this.joinNode.getBufferManager().reserveBuffers(toReserve, BufferManager.BufferReserveMode.FORCE);
            return true;
        }
        this.repeatedMerge = true;
        return true;
    }

    private void releaseReserved() {
        this.joinNode.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
    }

    @Override
    protected void process() throws TeiidComponentException, TeiidProcessingException {
        if (this.processingSortLeft != MergeJoinStrategy.SortOption.NOT_SORTED && this.processingSortRight != MergeJoinStrategy.SortOption.NOT_SORTED) {
            super.process();
            return;
        }
        if (this.sortedSource.getTupleBuffer().getRowCount() == 0) {
            return;
        }
        if (this.repeatedMerge) {
            while (this.notSortedSource.hasBuffer()) {
                super.process();
                this.resetMatchState();
                this.sortedSource.resetState();
                this.notSortedSource.nextBuffer();
            }
            return;
        }
        if (this.currentSource == null) {
            this.currentSource = this.notSortedSource.getIterator();
        }
        while (true) {
            if (this.currentTuple == null) {
                this.currentTuple = this.currentSource.nextTuple();
                if (this.currentTuple == null) {
                    return;
                }
                if (this.validSemiDep) {
                    List<?> tuple = this.currentTuple;
                    this.currentTuple = null;
                    this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getOuterVals(), tuple));
                    continue;
                }
                List<?> key = RelationalNode.projectTuple(this.notSortedSource.getExpressionIndexes(), this.currentTuple);
                this.tb = new TupleBrowser(this.index, new CollectionTupleSource(Arrays.asList(key).iterator()), true);
            }
            if (this.sortedTuple == null) {
                this.sortedTuple = this.tb.nextTuple();
                if (this.sortedTuple == null) {
                    this.currentTuple = null;
                    continue;
                }
            }
            List<?> reorderedTuple = RelationalNode.projectTuple(this.reverseIndexes, this.sortedTuple);
            List outputTuple = this.outputTuple(this.processingSortLeft == MergeJoinStrategy.SortOption.NOT_SORTED ? this.currentTuple : reorderedTuple, this.processingSortLeft == MergeJoinStrategy.SortOption.NOT_SORTED ? reorderedTuple : this.currentTuple);
            boolean matches = this.joinNode.matchesCriteria(outputTuple);
            this.sortedTuple = null;
            if (!matches) continue;
            this.joinNode.addBatchRow(outputTuple);
        }
    }

    @Override
    public EnhancedSortMergeJoinStrategy clone() {
        EnhancedSortMergeJoinStrategy clone = new EnhancedSortMergeJoinStrategy(this.sortLeft, this.sortRight);
        clone.semiDep = this.semiDep;
        return clone;
    }

    @Override
    public String getName() {
        return "ENHANCED SORT JOIN" + (this.semiDep ? " [SEMI]" : "");
    }

    public void setSemiDep(boolean semiDep) {
        this.semiDep = semiDep;
    }
}

