/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.language.SortSpecification;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class SortUtility {
    private TupleSource source;
    private Mode mode;
    private BufferManager bufferManager;
    private String groupName;
    private List<? extends Expression> schema;
    private int schemaSize;
    private ListNestedSortComparator comparator;
    private TupleBuffer output;
    private boolean doneReading;
    private int phase = 1;
    private List<TupleBuffer> activeTupleBuffers = new ArrayList<TupleBuffer>();
    private int masterSortIndex;
    private int collected;
    private static final int INITIAL_SORT = 1;
    private static final int MERGE = 2;
    private static final int DONE = 3;
    private Collection<List<?>> workingTuples;

    public SortUtility(TupleSource sourceID, List<OrderByItem> items, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema) {
        List<? extends Expression> sortElements = null;
        List<Boolean> sortTypes = null;
        ArrayList<SortSpecification.NullOrdering> nullOrderings = null;
        if (items == null) {
            sortElements = schema;
            sortTypes = Collections.nCopies(sortElements.size(), true);
        } else {
            sortElements = new ArrayList<Expression>(items.size());
            sortTypes = new ArrayList<Boolean>(items.size());
            nullOrderings = new ArrayList<SortSpecification.NullOrdering>(items.size());
            for (OrderByItem orderByItem : items) {
                sortElements.add(orderByItem.getSymbol());
                sortTypes.add(orderByItem.isAscending());
                nullOrderings.add(orderByItem.getNullOrdering());
            }
            if (items.size() < schema.size() && mode != Mode.SORT) {
                ArrayList<? extends Expression> toAdd = new ArrayList<Expression>(schema);
                toAdd.removeAll(sortElements);
                sortElements.addAll(toAdd);
                sortTypes.addAll(Collections.nCopies(sortElements.size() - sortTypes.size(), true));
                nullOrderings.addAll(Collections.nCopies(sortElements.size() - nullOrderings.size(), null));
            }
        }
        int[] cols = new int[sortElements.size()];
        ListIterator<? extends Expression> iter = sortElements.listIterator();
        while (iter.hasNext()) {
            Expression elem = iter.next();
            cols[iter.previousIndex()] = schema.indexOf(elem);
            Assertion.assertTrue((cols[iter.previousIndex()] != -1 ? 1 : 0) != 0);
        }
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
    }

    public SortUtility(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
    }

    private void init(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.source = sourceID;
        this.mode = mode;
        this.bufferManager = bufferMgr;
        this.groupName = groupName;
        this.schema = schema;
        this.schemaSize = this.bufferManager.getSchemaSize(this.schema);
        this.comparator = new ListNestedSortComparator(cols, sortTypes);
        int distinctIndex = cols.length - 1;
        this.comparator.setDistinctIndex(distinctIndex);
        this.comparator.setNullOrdering(nullOrderings);
    }

    public SortUtility(TupleSource ts, List<? extends SingleElementSymbol> expressions, List<Boolean> types, Mode mode, BufferManager bufferManager, String connectionID, List schema) {
        this(ts, new OrderBy(expressions, types).getOrderByItems(), mode, bufferManager, connectionID, schema);
    }

    public boolean isDone() {
        return this.doneReading && this.phase == 3;
    }

    public TupleBuffer sort() throws TeiidComponentException, TeiidProcessingException {
        if (this.phase == 1) {
            this.initialSort();
        }
        if (this.phase == 2) {
            this.mergePhase();
        }
        if (this.output != null) {
            return this.output;
        }
        return this.activeTupleBuffers.get(0);
    }

    public List<TupleBuffer> onePassSort() throws TeiidComponentException, TeiidProcessingException {
        assert (this.mode != Mode.DUP_REMOVE);
        if (this.phase == 1) {
            this.initialSort();
        }
        return this.activeTupleBuffers;
    }

    private TupleBuffer createTupleBuffer() throws TeiidComponentException {
        TupleBuffer tb = this.bufferManager.createTupleBuffer(this.schema, this.groupName, BufferManager.TupleSourceType.PROCESSOR);
        tb.setForwardOnly(true);
        return tb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialSort() throws TeiidComponentException, TeiidProcessingException {
        while (!this.doneReading) {
            if (this.workingTuples == null) {
                this.workingTuples = this.mode == Mode.SORT ? new ArrayList() : new TreeSet(this.comparator);
            }
            int totalReservedBuffers = 0;
            try {
                int maxRows = this.bufferManager.getProcessorBatchSize();
                while (!this.doneReading) {
                    if (this.workingTuples.size() >= maxRows) {
                        int reserved = this.bufferManager.reserveBuffers(this.schemaSize, totalReservedBuffers + this.schemaSize <= this.bufferManager.getMaxProcessingKB() ? BufferManager.BufferReserveMode.FORCE : BufferManager.BufferReserveMode.NO_WAIT);
                        if (reserved != this.schemaSize) break;
                        totalReservedBuffers += reserved;
                        maxRows += this.bufferManager.getProcessorBatchSize();
                    }
                    try {
                        List<?> tuple = this.source.nextTuple();
                        if (tuple == null) {
                            this.doneReading = true;
                            break;
                        }
                        if (!this.workingTuples.add(tuple)) continue;
                        ++this.collected;
                    }
                    catch (BlockedException e) {
                        if (this.workingTuples.size() >= this.bufferManager.getProcessorBatchSize() || this.mode == Mode.DUP_REMOVE && (this.output == null || this.collected >= this.output.getRowCount() * 2) && (this.output != null || !this.workingTuples.isEmpty() || !this.activeTupleBuffers.isEmpty())) break;
                        throw e;
                    }
                }
                if (this.workingTuples.isEmpty()) break;
                TupleBuffer sublist = this.createTupleBuffer();
                this.activeTupleBuffers.add(sublist);
                if (this.mode == Mode.SORT) {
                    Collections.sort((List)this.workingTuples, this.comparator);
                }
                for (List<?> list : this.workingTuples) {
                    sublist.addTuple(list);
                }
                this.workingTuples = null;
                sublist.saveBatch();
            }
            finally {
                this.bufferManager.releaseBuffers(totalReservedBuffers);
            }
        }
        if (this.activeTupleBuffers.isEmpty()) {
            this.activeTupleBuffers.add(this.createTupleBuffer());
        }
        this.collected = 0;
        this.phase = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergePhase() throws TeiidComponentException, TeiidProcessingException {
        while (this.activeTupleBuffers.size() > 1) {
            ArrayList<SortedSublist> sublists = new ArrayList<SortedSublist>(this.activeTupleBuffers.size());
            TupleBuffer merged = this.createTupleBuffer();
            int desiredSpace = this.activeTupleBuffers.size() * this.schemaSize;
            int reserved = Math.min(desiredSpace, this.bufferManager.getMaxProcessingKB());
            this.bufferManager.reserveBuffers(reserved, BufferManager.BufferReserveMode.FORCE);
            if (desiredSpace > reserved) {
                reserved += this.bufferManager.reserveBuffers(desiredSpace - reserved, BufferManager.BufferReserveMode.WAIT);
            }
            int maxSortIndex = Math.max(2, reserved / this.schemaSize);
            int release = reserved % this.schemaSize > 0 ? 1 : 0;
            this.bufferManager.releaseBuffers(release);
            reserved -= release;
            try {
                int i;
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Merging", maxSortIndex, "sublists out of", this.activeTupleBuffers.size()});
                }
                for (i = 0; i < maxSortIndex; ++i) {
                    TupleBuffer activeID = this.activeTupleBuffers.get(i);
                    SortedSublist sortedSublist = new SortedSublist();
                    sortedSublist.its = activeID.createIndexedTupleSource();
                    sortedSublist.index = i;
                    if (activeID == this.output) {
                        sortedSublist.limit = this.output.getRowCount();
                    }
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                while (sublists.size() > 0) {
                    SortedSublist sortedSublist = (SortedSublist)sublists.remove(sublists.size() - 1);
                    merged.addTuple(sortedSublist.tuple);
                    if (this.output != null && sortedSublist.index > this.masterSortIndex) {
                        this.output.addTuple(sortedSublist.tuple);
                    }
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                for (i = 0; i < maxSortIndex; ++i) {
                    TupleBuffer id = this.activeTupleBuffers.remove(0);
                    if (id == this.output) continue;
                    id.remove();
                }
                merged.saveBatch();
                this.activeTupleBuffers.add(merged);
                this.masterSortIndex = this.masterSortIndex - maxSortIndex + 1;
                if (this.masterSortIndex >= 0) continue;
                this.masterSortIndex = this.activeTupleBuffers.size() - 1;
            }
            finally {
                this.bufferManager.releaseBuffers(reserved);
            }
        }
        if (this.doneReading) {
            if (this.output != null) {
                this.output.close();
                TupleBuffer last = this.activeTupleBuffers.remove(0);
                if (this.output != last) {
                    last.remove();
                }
            } else {
                this.activeTupleBuffers.get(0).close();
                this.activeTupleBuffers.get(0).setForwardOnly(false);
            }
            this.phase = 3;
            return;
        }
        Assertion.assertTrue((this.mode == Mode.DUP_REMOVE ? 1 : 0) != 0);
        if (this.output == null) {
            this.output = this.activeTupleBuffers.get(0);
            this.output.setForwardOnly(false);
        }
        this.phase = 1;
    }

    private void incrementWorkingTuple(ArrayList<SortedSublist> subLists, SortedSublist sortedSublist) throws TeiidComponentException, TeiidProcessingException {
        while (true) {
            sortedSublist.tuple = null;
            if (sortedSublist.limit < sortedSublist.its.getCurrentIndex()) {
                return;
            }
            try {
                sortedSublist.tuple = sortedSublist.its.nextTuple();
            }
            catch (BlockedException e) {
                // empty catch block
            }
            if (sortedSublist.tuple == null) {
                return;
            }
            int index = Collections.binarySearch(subLists, sortedSublist);
            if (index < 0) {
                subLists.add(-index - 1, sortedSublist);
                return;
            }
            if (this.mode == Mode.SORT) {
                subLists.add(index, sortedSublist);
                return;
            }
            if (this.mode != Mode.DUP_REMOVE || this.output == null || sortedSublist.index != this.masterSortIndex) continue;
            SortedSublist dup = subLists.get(index);
            subLists.set(index, sortedSublist);
            sortedSublist = dup;
        }
    }

    public boolean isDistinct() {
        return this.comparator.isDistinct();
    }

    private class SortedSublist
    implements Comparable<SortedSublist> {
        List<?> tuple;
        int index;
        IndexedTupleSource its;
        int limit = Integer.MAX_VALUE;

        private SortedSublist() {
        }

        @Override
        public int compareTo(SortedSublist o) {
            return -SortUtility.this.comparator.compare(this.tuple, o.tuple);
        }

        public String toString() {
            return this.index + " " + this.tuple;
        }
    }

    public static enum Mode {
        SORT,
        DUP_REMOVE,
        DUP_REMOVE_SORT;

    }
}

