/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class SubqueryAwareEvaluator
extends Evaluator {
    private BufferManager manager;
    private Map<String, SubqueryState> subqueries = new HashMap<String, SubqueryState>();

    public SubqueryAwareEvaluator(Map elements, ProcessorDataManager dataMgr, CommandContext context, BufferManager manager) {
        super(elements, dataMgr, context);
        this.manager = manager;
    }

    public void reset() {
        for (SubqueryState subQueryState : this.subqueries.values()) {
            subQueryState.plan.reset();
        }
    }

    public void close() {
        for (SubqueryState state : this.subqueries.values()) {
            state.close();
        }
    }

    protected ValueIterator evaluateSubquery(SubqueryContainer container, List tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        boolean shouldClose;
        ContextReference ref = (ContextReference)((Object)container);
        String key = ref.getContextSymbol();
        SubqueryState state = this.subqueries.get(key);
        if (state == null) {
            state = new SubqueryState();
            state.plan = ((Command)container.getCommand()).getProcessorPlan().clone();
            if (container instanceof ScalarSubquery) {
                state.nonDeterministic = FunctionCollectorVisitor.isNonDeterministic(container.getCommand());
            }
            if (((Command)container.getCommand()).getCorrelatedReferences() != null) {
                for (ElementSymbol es : ((Command)container.getCommand()).getCorrelatedReferences().getKeys()) {
                    if (!DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(es.getType()))) continue;
                    state.comparable = false;
                    break;
                }
            }
            this.subqueries.put(key, state);
        }
        SymbolMap correlatedRefs = ((Command)container.getCommand()).getCorrelatedReferences();
        VariableContext currentContext = null;
        boolean bl = shouldClose = state.done && state.nonDeterministic;
        if (correlatedRefs != null) {
            currentContext = new VariableContext();
            for (Map.Entry<ElementSymbol, Expression> entry : ((Command)container.getCommand()).getCorrelatedReferences().asMap().entrySet()) {
                currentContext.setValue(entry.getKey(), this.evaluate(entry.getValue(), tuple));
            }
            List<Object> refValues = currentContext.getLocalValues();
            if (!((Object)refValues).equals(state.refValues)) {
                state.refValues = refValues;
                shouldClose = true;
            }
        }
        if (shouldClose) {
            state.close();
        }
        if (!state.done) {
            if (state.processor == null) {
                CommandContext subContext = this.context.clone();
                state.plan.reset();
                state.processor = new QueryProcessor(state.plan, subContext, this.manager, this.dataMgr);
                if (currentContext != null) {
                    state.processor.getContext().pushVariableContext(currentContext);
                }
                state.collector = state.processor.createBatchCollector();
            }
            state.done = true;
        }
        return new DependentValueSource(state.collector.collectTuples()).getValueIterator(ref.getValueExpression());
    }

    public class SubqueryState {
        QueryProcessor processor;
        BatchCollector collector;
        boolean done;
        ProcessorPlan plan;
        boolean nonDeterministic;
        List<Object> refValues;
        boolean comparable = true;

        void close() {
            if (this.processor == null) {
                return;
            }
            this.processor.closeProcessing();
            this.collector.getTupleBuffer().remove();
            this.processor = null;
            this.done = false;
        }
    }
}

