/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.AlterTempTable;
import org.teiid.query.util.CommandContext;

class RelationalPlanExecutor
implements PlanExecutor {
    QueryProcessor internalProcessor;
    ResultSetInfo resultInfo;
    BufferManager bufferMgr;
    boolean endOfRows = false;
    TupleSource tupleSource;
    List<?> currentRow;
    int currentRowNumber = 0;
    private ProcessorDataManager dataManager;
    private boolean executed;
    private boolean doneLoading;

    public RelationalPlanExecutor(ResultSetInfo resultInfo, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) throws TeiidComponentException {
        this.resultInfo = resultInfo;
        this.bufferMgr = bufferMgr;
        this.dataManager = dataMgr;
        ProcessorPlan plan = resultInfo.getPlan();
        CommandContext subContext = context.clone();
        subContext.pushVariableContext(new VariableContext());
        this.internalProcessor = new QueryProcessor(plan, subContext, bufferMgr, dataMgr);
    }

    @Override
    public List getOutputElements() throws TeiidComponentException {
        ProcessorPlan plan = this.resultInfo.getPlan();
        return plan.getOutputElements();
    }

    @Override
    public void execute(Map referenceValues, boolean openOnly) throws TeiidComponentException, BlockedException, TeiidProcessingException {
        if (this.tupleSource == null) {
            this.setReferenceValues(referenceValues);
            this.tupleSource = new BatchIterator(this.internalProcessor);
            if (openOnly) {
                this.internalProcessor.init();
            }
        }
        if (!openOnly && !this.executed) {
            String tempTable = this.resultInfo.getTempTable();
            if (tempTable != null && !this.doneLoading && !this.resultInfo.isAutoStaged()) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"Loading result set temp table", tempTable});
                Insert insert = this.resultInfo.getTempInsert();
                insert.setTupleSource(new TempLoadTupleSource());
                this.dataManager.registerRequest(this.internalProcessor.getContext(), insert, TempMetadataAdapter.TEMP_MODEL.getName(), null, 0, -1);
                if (!this.doneLoading) {
                    throw BlockedException.block("Blocking on result set load");
                }
                this.internalProcessor.closeProcessing();
                AlterTempTable att = new AlterTempTable(tempTable);
                this.dataManager.registerRequest(this.internalProcessor.getContext(), att, TempMetadataAdapter.TEMP_MODEL.getName(), null, 0, -1);
                this.tupleSource = this.dataManager.registerRequest(this.internalProcessor.getContext(), this.resultInfo.getTempSelect(), TempMetadataAdapter.TEMP_MODEL.getName(), null, 0, -1);
            }
            this.currentRow();
            if (this.resultInfo.isAutoStaged() && tempTable != null) {
                AlterTempTable att = new AlterTempTable(tempTable);
                int size = (Integer)this.currentRow.get(0);
                if (size > this.bufferMgr.getProcessorBatchSize() * 2) {
                    att.setIndexColumns(this.resultInfo.getFkColumns());
                }
                this.dataManager.registerRequest(this.internalProcessor.getContext(), att, TempMetadataAdapter.TEMP_MODEL.getName(), null, 0, -1);
            }
            this.currentRowNumber = 0;
            this.executed = true;
        }
    }

    void setReferenceValues(Map<ElementSymbol, Object> referencesValues) {
        if (referencesValues == null || referencesValues.isEmpty()) {
            return;
        }
        for (Map.Entry<ElementSymbol, Object> entry : referencesValues.entrySet()) {
            this.internalProcessor.getContext().getVariableContext().setValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public List nextRow() throws TeiidComponentException, TeiidProcessingException {
        if (!this.endOfRows) {
            if (this.currentRow == null || this.currentRowNumber > 0) {
                this.currentRow = this.tupleSource.nextTuple();
            }
            ++this.currentRowNumber;
            if (this.currentRow != null && this.resultInfo.getUserRowLimit() > 0 && this.currentRowNumber > this.resultInfo.getUserRowLimit()) {
                if (this.resultInfo.exceptionOnRowlimit()) {
                    throw new TeiidProcessingException(QueryPlugin.Util.getString("row_limit_passed", new Object[]{new Integer(this.resultInfo.getUserRowLimit()), this.resultInfo.getResultSetName()}));
                }
                this.currentRow = null;
            }
        }
        if (this.currentRow == null) {
            this.endOfRows = true;
        }
        return this.currentRow;
    }

    @Override
    public List currentRow() throws TeiidComponentException, TeiidProcessingException {
        if (this.currentRow == null && !this.endOfRows) {
            return this.nextRow();
        }
        return this.currentRow;
    }

    @Override
    public void close() throws TeiidComponentException {
        String rsTempTable;
        this.internalProcessor.closeProcessing();
        if (this.tupleSource != null) {
            this.tupleSource.closeSource();
        }
        if ((rsTempTable = this.resultInfo.getTempTable()) != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"Unloading result set temp table", rsTempTable});
            this.internalProcessor.closeProcessing();
            try {
                this.tupleSource = this.dataManager.registerRequest(this.internalProcessor.getContext(), this.resultInfo.getTempDrop(), TempMetadataAdapter.TEMP_MODEL.getName(), null, 0, -1);
            }
            catch (TeiidProcessingException e) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR.XML_PLAN", (Throwable)e, (Object[])new Object[]{"Error dropping result set temp table", rsTempTable});
            }
        }
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"closed executor", this.resultInfo.getResultSetName()});
    }

    private final class TempLoadTupleSource
    implements TupleSource {
        private TempLoadTupleSource() {
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            try {
                List<?> tuple = RelationalPlanExecutor.this.tupleSource.nextTuple();
                if (tuple == null) {
                    RelationalPlanExecutor.this.doneLoading = true;
                }
                return tuple;
            }
            catch (BlockedException e) {
                return null;
            }
        }

        @Override
        public void closeSource() {
            RelationalPlanExecutor.this.tupleSource.closeSource();
        }
    }
}

