/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.LRUCache;
import org.teiid.language.Like;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.symbol.Expression;

public class MatchCriteria
extends PredicateCriteria
implements PredicateCriteria.Negatable {
    public static final char WILDCARD_CHAR = '%';
    public static final char MATCH_CHAR = '_';
    private Expression leftExpression;
    private Expression rightExpression;
    public static final char NULL_ESCAPE_CHAR = '\u0000';
    private char escapeChar = '\u0000';
    private boolean negated;
    private Like.MatchMode mode = Like.MatchMode.LIKE;
    private static final LRUCache<List<?>, Pattern> patternCache = new LRUCache(100);

    public MatchCriteria() {
    }

    public MatchCriteria(Expression leftExpression, Expression rightExpression) {
        this.setLeftExpression(leftExpression);
        this.setRightExpression(rightExpression);
    }

    public MatchCriteria(Expression leftExpression, Expression rightExpression, char escapeChar) {
        this(leftExpression, rightExpression);
        this.setEscapeChar(escapeChar);
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negationFlag) {
        this.negated = negationFlag;
    }

    @Override
    public void negate() {
        this.negated = !this.negated;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getLeftExpression()});
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getRightExpression()});
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MatchCriteria)) {
            return false;
        }
        MatchCriteria mc = (MatchCriteria)obj;
        if (this.isNegated() != mc.isNegated()) {
            return false;
        }
        if (this.mode != mc.mode) {
            return false;
        }
        return this.getEscapeChar() == mc.getEscapeChar() && EquivalenceUtil.areEqual((Object)this.getLeftExpression(), (Object)mc.getLeftExpression()) && EquivalenceUtil.areEqual((Object)this.getRightExpression(), (Object)mc.getRightExpression());
    }

    @Override
    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Expression rightCopy = null;
        if (this.getRightExpression() != null) {
            rightCopy = (Expression)this.getRightExpression().clone();
        }
        MatchCriteria criteriaCopy = new MatchCriteria(leftCopy, rightCopy, this.getEscapeChar());
        criteriaCopy.setNegated(this.isNegated());
        criteriaCopy.mode = this.mode;
        return criteriaCopy;
    }

    public static Pattern getPattern(String newPattern, String originalPattern, int flags) throws ExpressionEvaluationException {
        List<Serializable> key = Arrays.asList(newPattern, flags);
        Pattern p = (Pattern)patternCache.get(key);
        if (p == null) {
            try {
                p = Pattern.compile(newPattern, 32);
                patternCache.put(key, (Object)p);
            }
            catch (PatternSyntaxException e) {
                throw new ExpressionEvaluationException(e, "ERR.015.006.0014", QueryPlugin.Util.getString("ERR.015.006.0014", new Object[]{originalPattern, e.getMessage()}));
            }
        }
        return p;
    }

    public Like.MatchMode getMode() {
        return this.mode;
    }

    public void setMode(Like.MatchMode mode) {
        this.mode = mode;
    }

    public static class PatternTranslator {
        private char[] reserved;
        private char newEscape;
        private char[] toReplace;
        private String[] replacements;
        private int flags;
        private final LRUCache<List<?>, Pattern> cache = new LRUCache(100);

        public PatternTranslator(char[] toReplace, String[] replacements, char[] reserved, char newEscape, int flags) {
            this.reserved = reserved;
            this.newEscape = newEscape;
            this.toReplace = toReplace;
            this.replacements = replacements;
            this.flags = flags;
        }

        public Pattern translate(String pattern, char escape) throws ExpressionEvaluationException {
            List<Serializable> key = Arrays.asList(pattern, Character.valueOf(escape));
            Pattern result = (Pattern)this.cache.get(key);
            if (result == null) {
                String newPattern = this.getPatternString(pattern, escape);
                result = MatchCriteria.getPattern(newPattern, pattern, this.flags);
                this.cache.put(key, (Object)result);
            }
            return result;
        }

        public String getPatternString(String pattern, char escape) throws ExpressionEvaluationException {
            StringBuffer newPattern = new StringBuffer("^");
            boolean escaped = false;
            for (int i = 0; i < pattern.length(); ++i) {
                char character = pattern.charAt(i);
                if (character == escape && character != '\u0000') {
                    if (escaped) {
                        this.appendCharacter(newPattern, character);
                        escaped = false;
                        continue;
                    }
                    escaped = true;
                    continue;
                }
                int index = Arrays.binarySearch(this.toReplace, character);
                if (index >= 0) {
                    if (escaped) {
                        this.appendCharacter(newPattern, character);
                        escaped = false;
                        continue;
                    }
                    newPattern.append(this.replacements[index]);
                    continue;
                }
                if (escaped) {
                    throw new ExpressionEvaluationException(QueryPlugin.Util.getString("MatchCriteria.invalid_escape", new Object[]{pattern, new Character(escape)}));
                }
                this.appendCharacter(newPattern, character);
            }
            if (escaped) {
                throw new ExpressionEvaluationException(QueryPlugin.Util.getString("MatchCriteria.invalid_escape", new Object[]{pattern, new Character(escape)}));
            }
            newPattern.append('$');
            return newPattern.toString();
        }

        private void appendCharacter(StringBuffer newPattern, char character) {
            if (Arrays.binarySearch(this.reserved, character) >= 0) {
                newPattern.append(this.newEscape);
            }
            newPattern.append(character);
        }
    }
}

