/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;

public class AggregateSymbol
extends ExpressionSymbol {
    private Type aggregate;
    private boolean distinct;
    private OrderBy orderBy;
    private Expression condition;
    private boolean isWindowed;
    private static final Class<Integer> COUNT_TYPE = DataTypeManager.DefaultDataClasses.INTEGER;
    private static final Map<Class<?>, Class<?>> SUM_TYPES = new HashMap();
    private static final Map<Class<?>, Class<?>> AVG_TYPES;

    protected AggregateSymbol(String name, String canonicalName, Type aggregateFunction, boolean isDistinct, Expression expression) {
        super(name, canonicalName, expression);
        this.aggregate = aggregateFunction;
        this.distinct = isDistinct;
    }

    public AggregateSymbol(String name, String aggregateFunction, boolean isDistinct, Expression expression) {
        super(name, expression);
        this.aggregate = Type.valueOf(aggregateFunction);
        this.distinct = isDistinct;
    }

    public void setAggregateFunction(Type aggregateFunction) {
        this.aggregate = aggregateFunction;
    }

    public Type getAggregateFunction() {
        return this.aggregate;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Class<?> getType() {
        switch (this.aggregate) {
            case COUNT: {
                return COUNT_TYPE;
            }
            case SUM: {
                Class expressionType = this.getExpression().getType();
                return SUM_TYPES.get(expressionType);
            }
            case AVG: {
                Class expressionType = this.getExpression().getType();
                return AVG_TYPES.get(expressionType);
            }
            case ARRAY_AGG: {
                return DataTypeManager.DefaultDataClasses.OBJECT;
            }
            case TEXTAGG: {
                return DataTypeManager.DefaultDataClasses.BLOB;
            }
        }
        if (this.isBoolean()) {
            return DataTypeManager.DefaultDataClasses.BOOLEAN;
        }
        if (this.isEnhancedNumeric()) {
            return DataTypeManager.DefaultDataClasses.DOUBLE;
        }
        if (this.isAnalytical()) {
            return DataTypeManager.DefaultDataClasses.INTEGER;
        }
        return this.getExpression().getType();
    }

    public boolean isAnalytical() {
        switch (this.aggregate) {
            case RANK: 
            case ROW_NUMBER: 
            case DENSE_RANK: {
                return true;
            }
        }
        return false;
    }

    public boolean isBoolean() {
        return this.aggregate == Type.EVERY || this.aggregate == Type.SOME || this.aggregate == Type.ANY;
    }

    public boolean isEnhancedNumeric() {
        return this.aggregate == Type.STDDEV_POP || this.aggregate == Type.STDDEV_SAMP || this.aggregate == Type.VAR_SAMP || this.aggregate == Type.VAR_POP;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public Object clone() {
        AggregateSymbol copy = null;
        copy = this.getExpression() != null ? new AggregateSymbol(this.getName(), this.getCanonical(), this.getAggregateFunction(), this.isDistinct(), (Expression)this.getExpression().clone()) : new AggregateSymbol(this.getName(), this.getCanonical(), this.getAggregateFunction(), this.isDistinct(), null);
        if (this.orderBy != null) {
            copy.setOrderBy(this.orderBy.clone());
        }
        if (this.condition != null) {
            copy.setCondition((Expression)this.condition.clone());
        }
        copy.isWindowed = this.isWindowed;
        return copy;
    }

    @Override
    public int hashCode() {
        int hasCode = HashCodeUtil.hashCode((int)this.aggregate.hashCode(), (boolean)this.distinct);
        return HashCodeUtil.hashCode((int)hasCode, (Object[])new Object[]{this.getExpression()});
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AggregateSymbol)) {
            return false;
        }
        AggregateSymbol other = (AggregateSymbol)obj;
        return this.aggregate.equals((Object)other.aggregate) && this.distinct == other.distinct && this.isWindowed == other.isWindowed && EquivalenceUtil.areEqual((Object)this.getExpression(), (Object)other.getExpression()) && EquivalenceUtil.areEqual((Object)this.condition, (Object)other.condition) && EquivalenceUtil.areEqual((Object)this.getOrderBy(), (Object)other.getOrderBy());
    }

    public boolean isCardinalityDependent() {
        if (this.isDistinct()) {
            return false;
        }
        switch (this.getAggregateFunction()) {
            case MAX: 
            case MIN: 
            case ANY: 
            case SOME: 
            case EVERY: {
                return false;
            }
        }
        return true;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public static boolean areAggregatesCardinalityDependent(Collection<AggregateSymbol> aggs) {
        for (AggregateSymbol aggregateSymbol : aggs) {
            if (!aggregateSymbol.isCardinalityDependent()) continue;
            return true;
        }
        return false;
    }

    public boolean respectsNulls() {
        switch (this.aggregate) {
            case ARRAY_AGG: 
            case TEXTAGG: {
                return true;
            }
        }
        return false;
    }

    public boolean canStage() {
        switch (this.aggregate) {
            case ARRAY_AGG: 
            case TEXTAGG: {
                return false;
            }
            case XMLAGG: {
                return this.orderBy == null;
            }
        }
        return true;
    }

    public boolean isWindowed() {
        return this.isWindowed;
    }

    public void setWindowed(boolean isWindowed) {
        this.isWindowed = isWindowed;
    }

    static {
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES = new HashMap();
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
    }

    public static enum Type {
        COUNT,
        SUM,
        AVG,
        MIN,
        MAX,
        XMLAGG,
        TEXTAGG,
        ARRAY_AGG,
        ANY,
        SOME,
        EVERY,
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_POP,
        VAR_SAMP,
        RANK,
        DENSE_RANK,
        ROW_NUMBER;

    }
}

