/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBrowser;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.tempdata.IndexInfo;

class TempTable {
    private STree tree;
    private AtomicInteger rowId;
    private List<ElementSymbol> columns;
    private BufferManager bm;
    private String sessionID;
    private TempMetadataID tid;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean updatable = true;
    private LinkedHashMap<List<ElementSymbol>, TempTable> indexTables;
    private int keyBatchSize;
    private int leafBatchSize;
    private Map columnMap;
    private List<Integer> notNull = new LinkedList<Integer>();
    private Map<Integer, AtomicInteger> sequences;
    private int uniqueColIndex;

    TempTable(TempMetadataID tid, BufferManager bm, List<ElementSymbol> columns, int primaryKeyLength, String sessionID) {
        this.tid = tid;
        this.bm = bm;
        int startIndex = 0;
        if (primaryKeyLength == 0) {
            startIndex = 1;
            ElementSymbol id = new ElementSymbol("rowId");
            id.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            columns.add(0, id);
            this.rowId = new AtomicInteger();
            this.tree = bm.createSTree(columns, sessionID, 1);
        } else {
            this.uniqueColIndex = primaryKeyLength;
            this.tree = bm.createSTree(columns, sessionID, primaryKeyLength);
        }
        this.columnMap = RelationalNode.createLookupMap(columns);
        this.columns = columns;
        if (!tid.getElements().isEmpty()) {
            for (int i = startIndex; i < columns.size(); ++i) {
                TempMetadataID col = tid.getElements().get(i - startIndex);
                if (col.isAutoIncrement()) {
                    if (this.sequences == null) {
                        this.sequences = new HashMap<Integer, AtomicInteger>();
                    }
                    this.sequences.put(i, new AtomicInteger(1));
                }
                if (!col.isNotNull()) continue;
                this.notNull.add(i);
            }
        }
        if (this.sequences == null) {
            this.sequences = Collections.emptyMap();
        }
        this.sessionID = sessionID;
        this.keyBatchSize = bm.getSchemaSize(columns);
        this.leafBatchSize = bm.getSchemaSize(columns.subList(0, primaryKeyLength));
    }

    void addIndex(List<ElementSymbol> indexColumns, boolean unique) throws TeiidComponentException, TeiidProcessingException {
        List<ElementSymbol> keyColumns = this.columns.subList(0, this.tree.getKeyLength());
        if (((Object)keyColumns).equals(indexColumns) || this.indexTables != null && this.indexTables.containsKey(indexColumns)) {
            return;
        }
        ArrayList<ElementSymbol> allColumns = new ArrayList<ElementSymbol>(indexColumns);
        for (ElementSymbol elementSymbol : keyColumns) {
            if (allColumns.indexOf(elementSymbol) >= 0) continue;
            allColumns.add(elementSymbol);
        }
        TempTable indexTable = new TempTable(new TempMetadataID("idx", Collections.EMPTY_LIST), this.bm, allColumns, allColumns.size(), this.sessionID);
        indexTable.setPreferMemory(this.tree.isPreferMemory());
        indexTable.lock = this.lock;
        if (unique) {
            indexTable.uniqueColIndex = indexColumns.size();
        }
        if (this.indexTables == null) {
            this.indexTables = new LinkedHashMap();
            this.indexTables.put(indexColumns, indexTable);
        }
        TupleSource ts = this.createTupleSource(allColumns, null, null);
        indexTable.insert(ts, allColumns);
        indexTable.getTree().compact();
    }

    private int reserveBuffers() {
        return this.bm.reserveBuffers(this.leafBatchSize + (this.tree.getHeight() - 1) * this.keyBatchSize, BufferManager.BufferReserveMode.FORCE);
    }

    /*
     * WARNING - void declaration
     */
    public TupleSource createTupleSource(List<? extends SingleElementSymbol> projectedCols, Criteria condition, OrderBy orderBy) throws TeiidComponentException, TeiidProcessingException {
        IndexInfo primary;
        boolean agg = false;
        for (SingleElementSymbol singleElementSymbol : projectedCols) {
            if (!(singleElementSymbol instanceof AggregateSymbol)) continue;
            agg = true;
            break;
        }
        if (agg) {
            if (condition == null) {
                int count = this.getRowCount();
                return new CollectionTupleSource(Arrays.asList(Collections.nCopies(projectedCols.size(), count)).iterator());
            }
            orderBy = null;
        }
        IndexInfo indexInfo = primary = new IndexInfo(this, projectedCols, condition, orderBy, true);
        if (this.indexTables != null && (condition != null || orderBy != null) && indexInfo.valueSet.size() != 1) {
            void var6_9;
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Considering indexes on table", this, "for query", projectedCols, condition, orderBy});
            int rowCost = this.tree.getRowCount();
            int bestCost = this.estimateCost(orderBy, indexInfo, rowCost);
            for (TempTable table : this.indexTables.values()) {
                IndexInfo secondary = new IndexInfo(table, projectedCols, condition, orderBy, false);
                int cost = this.estimateCost(orderBy, secondary, rowCost);
                if (cost >= bestCost) continue;
                IndexInfo indexInfo2 = secondary;
                bestCost = cost;
            }
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Choose index", var6_9.table, "covering:", var6_9.coveredCriteria, "ordering:", var6_9.ordering});
            if (var6_9.covering) {
                return var6_9.table.createTupleSource(projectedCols, condition, orderBy, (IndexInfo)var6_9, agg);
            }
            List<ElementSymbol> pkColumns = this.columns.subList(0, this.tree.getKeyLength());
            if (var6_9.ordering != null) {
                primary.valueTs = var6_9.table.createTupleSource(pkColumns, Criteria.combineCriteria(var6_9.coveredCriteria), orderBy, (IndexInfo)var6_9, agg);
                primary.ordering = null;
                return this.createTupleSource(projectedCols, Criteria.combineCriteria(var6_9.nonCoveredCriteria), null, primary, agg);
            }
            OrderBy pkOrderBy = new OrderBy();
            for (ElementSymbol elementSymbol : pkColumns) {
                pkOrderBy.addVariable(elementSymbol);
            }
            primary.valueTs = var6_9.table.createTupleSource(pkColumns, Criteria.combineCriteria(var6_9.coveredCriteria), pkOrderBy, (IndexInfo)var6_9, agg);
            return this.createTupleSource(projectedCols, Criteria.combineCriteria(var6_9.nonCoveredCriteria), orderBy, primary, agg);
        }
        return this.createTupleSource(projectedCols, condition, orderBy, indexInfo, agg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleSource createTupleSource(List<? extends SingleElementSymbol> projectedCols, Criteria condition, OrderBy orderBy, IndexInfo ii, boolean agg) throws TeiidComponentException, TeiidProcessingException {
        TupleBrowser browser = ii.createTupleBrowser();
        QueryTupleSource ts = new QueryTupleSource(browser, this.columnMap, agg ? this.getColumns() : projectedCols, condition);
        boolean usingQueryTupleSource = false;
        try {
            TupleBuffer tb = null;
            if (ii.ordering == null && orderBy != null) {
                SortUtility sort = new SortUtility(ts, orderBy.getOrderByItems(), SortUtility.Mode.SORT, this.bm, this.sessionID, projectedCols);
                tb = sort.sort();
            } else {
                if (agg) {
                    int count = 0;
                    while (ts.nextTuple() != null) {
                        ++count;
                    }
                    CollectionTupleSource collectionTupleSource = new CollectionTupleSource(Arrays.asList(Collections.nCopies(projectedCols.size(), count)).iterator());
                    return collectionTupleSource;
                }
                if (this.updatable) {
                    tb = this.bm.createTupleBuffer(projectedCols, this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
                    List<?> next = null;
                    while ((next = ts.nextTuple()) != null) {
                        tb.addTuple(next);
                    }
                } else {
                    usingQueryTupleSource = true;
                    QueryTupleSource queryTupleSource = ts;
                    return queryTupleSource;
                }
            }
            tb.close();
            IndexedTupleSource indexedTupleSource = tb.createIndexedTupleSource(true);
            return indexedTupleSource;
        }
        finally {
            if (!usingQueryTupleSource) {
                ts.closeSource();
            }
        }
    }

    private int estimateCost(OrderBy orderBy, IndexInfo ii, int rowCost) {
        int initialCost = rowCost;
        if (ii.valueSet.size() != 0) {
            int length = ii.valueSet.get(0).size();
            rowCost = ii.valueSet.size() * (ii.table.getPkLength() - length + 1);
            if (ii.table.uniqueColIndex != length) {
                rowCost *= 3;
            }
        } else if (ii.upper != null) {
            rowCost /= 3;
        } else if (ii.lower != null) {
            rowCost /= 3;
        }
        int additionalCost = Math.max(0, initialCost - rowCost);
        int cost = Math.min(initialCost, Math.max(1, rowCost));
        if (cost > 1 && (!ii.covering || orderBy != null && ii.ordering == null)) {
            cost *= 32 - Integer.numberOfLeadingZeros(cost - 1);
        }
        return cost + additionalCost;
    }

    private TupleBrowser createTupleBrower(Criteria condition, boolean direction) throws TeiidComponentException {
        IndexInfo ii = new IndexInfo(this, null, condition, null, true);
        ii.ordering = direction;
        return ii.createTupleBrowser();
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public int truncate() {
        this.tid.getTableData().dataModified(this.tree.getRowCount());
        return this.tree.truncate();
    }

    public void remove() {
        this.tree.remove();
        if (this.indexTables != null) {
            for (TempTable indexTable : this.indexTables.values()) {
                indexTable.remove();
            }
        }
    }

    public List<ElementSymbol> getColumns() {
        if (this.rowId != null) {
            return this.columns.subList(1, this.columns.size());
        }
        return this.columns;
    }

    public TupleSource insert(TupleSource tuples, List<ElementSymbol> variables) throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        List<ElementSymbol> cols = this.getColumns();
        int[] indexes = new int[cols.size()];
        boolean shouldProject = false;
        for (int i = 0; i < cols.size(); ++i) {
            indexes[i] = variables.indexOf(cols.get(i));
            shouldProject |= indexes[i] != i;
        }
        InsertUpdateProcessor up = new InsertUpdateProcessor(tuples, this.rowId != null, (int[])(shouldProject ? indexes : null));
        int updateCount = up.process();
        this.tid.setCardinality(this.tree.getRowCount());
        this.tid.getTableData().dataModified(updateCount);
        return CollectionTupleSource.createUpdateCountTupleSource(updateCount);
    }

    public TupleSource update(Criteria crit, final SetClauseList update) throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        final boolean primaryKeyChangePossible = this.canChangePrimaryKey(update);
        final TupleBrowser browser = this.createTupleBrower(crit, true);
        UpdateProcessor up = new UpdateProcessor(crit, browser){
            protected TupleBuffer changeSet;
            protected UpdateProcessor changeSetProcessor;

            @Override
            protected void tuplePassed(List tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                ArrayList<Object> newTuple = new ArrayList<Object>(tuple);
                for (Map.Entry<ElementSymbol, Expression> entry : update.getClauseMap().entrySet()) {
                    newTuple.set((Integer)TempTable.this.columnMap.get(entry.getKey()), this.eval.evaluate(entry.getValue(), tuple));
                }
                if (primaryKeyChangePossible) {
                    browser.removed();
                    TempTable.this.deleteTuple(tuple);
                    if (this.changeSet == null) {
                        this.changeSet = TempTable.this.bm.createTupleBuffer(TempTable.this.columns, TempTable.this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
                    }
                    this.changeSet.addTuple(newTuple);
                } else {
                    browser.update(newTuple);
                }
            }

            @Override
            protected void undo(List tuple) throws TeiidComponentException, TeiidProcessingException {
                if (primaryKeyChangePossible) {
                    TempTable.this.insertTuple(tuple, false);
                } else {
                    TempTable.this.updateTuple(tuple);
                }
            }

            @Override
            void success() throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
                if (primaryKeyChangePossible) {
                    if (this.changeSetProcessor == null) {
                        this.changeSetProcessor = new InsertUpdateProcessor(this.changeSet.createIndexedTupleSource(true), false, null);
                    }
                    this.changeSetProcessor.process();
                }
            }

            @Override
            public void close() {
                super.close();
                if (this.changeSetProcessor != null) {
                    this.changeSetProcessor.close();
                }
                if (this.changeSet != null) {
                    this.changeSet.remove();
                }
            }
        };
        int updateCount = up.process();
        this.tid.getTableData().dataModified(updateCount);
        return CollectionTupleSource.createUpdateCountTupleSource(updateCount);
    }

    private boolean canChangePrimaryKey(SetClauseList update) {
        if (this.rowId == null) {
            HashSet<ElementSymbol> affectedColumns = new HashSet<ElementSymbol>(update.getClauseMap().keySet());
            affectedColumns.retainAll(this.columns.subList(0, this.tree.getKeyLength()));
            if (!affectedColumns.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public TupleSource delete(Criteria crit) throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        final TupleBrowser browser = this.createTupleBrower(crit, true);
        UpdateProcessor up = new UpdateProcessor(crit, browser){

            @Override
            protected void tuplePassed(List tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                browser.removed();
                TempTable.this.deleteTuple(tuple);
            }

            @Override
            protected void undo(List tuple) throws TeiidComponentException, TeiidProcessingException {
                TempTable.this.insertTuple(tuple, false);
            }
        };
        int updateCount = up.process();
        this.tid.setCardinality(this.tree.getRowCount());
        this.tid.getTableData().dataModified(updateCount);
        return CollectionTupleSource.createUpdateCountTupleSource(updateCount);
    }

    private void insertTuple(List<?> list, boolean ordered) throws TeiidComponentException, TeiidProcessingException {
        if (this.tree.insert(list, ordered ? STree.InsertMode.ORDERED : STree.InsertMode.NEW, -1) != null) {
            throw new TeiidProcessingException(QueryPlugin.Util.getString("TempTable.duplicate_key"));
        }
    }

    private void deleteTuple(List<?> tuple) throws TeiidComponentException {
        if (this.tree.remove(tuple) == null) {
            throw new AssertionError((Object)"Delete failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<?> updateTuple(List<?> tuple, boolean remove) throws TeiidComponentException {
        try {
            this.lock.writeLock().lock();
            if (remove) {
                List result = this.tree.remove(tuple);
                if (result == null) {
                    List<?> list = null;
                    return list;
                }
                if (this.indexTables != null) {
                    for (TempTable index : this.indexTables.values()) {
                        tuple = RelationalNode.projectTuple(RelationalNode.getProjectionIndexes(index.getColumnMap(), index.columns), result);
                        index.tree.remove(tuple);
                    }
                }
                this.tid.getTableData().dataModified(1);
                List i$ = result;
                return i$;
            }
            List result = this.tree.insert(tuple, STree.InsertMode.UPDATE, -1);
            if (this.indexTables != null) {
                for (TempTable index : this.indexTables.values()) {
                    tuple = RelationalNode.projectTuple(RelationalNode.getProjectionIndexes(index.getColumnMap(), index.columns), tuple);
                    index.tree.insert(tuple, STree.InsertMode.UPDATE, -1);
                }
            }
            this.tid.getTableData().dataModified(1);
            List list = result;
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateTuple(List<?> tuple) throws TeiidComponentException {
        if (this.tree.insert(tuple, STree.InsertMode.UPDATE, -1) == null) {
            throw new AssertionError((Object)"Update failed");
        }
    }

    void setPreferMemory(boolean preferMemory) {
        this.tree.setPreferMemory(preferMemory);
    }

    void setUpdatable(boolean updatable) {
        this.updatable = updatable;
        if (this.indexTables != null) {
            for (TempTable index : this.indexTables.values()) {
                index.setUpdatable(updatable);
            }
        }
    }

    CacheHint getCacheHint() {
        return this.tid.getCacheHint();
    }

    int getPkLength() {
        if (this.rowId != null) {
            return 0;
        }
        return this.tree.getKeyLength();
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String toString() {
        return this.tid.getID() + " (" + this.columns + ")\n";
    }

    Map getColumnMap() {
        return this.columnMap;
    }

    STree getTree() {
        return this.tree;
    }

    public TempMetadataID getMetadataId() {
        return this.tid;
    }

    private abstract class UpdateProcessor {
        private TupleSource ts;
        protected final Evaluator eval;
        private final Criteria crit;
        protected int updateCount = 0;
        protected List currentTuple;
        protected TupleBuffer undoLog;

        UpdateProcessor(Criteria crit, TupleSource ts) throws TeiidComponentException {
            this.ts = ts;
            this.eval = new Evaluator(TempTable.this.columnMap, null, null);
            this.crit = crit;
            this.undoLog = TempTable.this.bm.createTupleBuffer(TempTable.this.columns, TempTable.this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int process() throws ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
            int reserved = TempTable.this.reserveBuffers();
            boolean held = TempTable.this.lock.writeLock().isHeldByCurrentThread();
            TempTable.this.lock.writeLock().lock();
            boolean success = false;
            try {
                while (this.currentTuple != null || (this.currentTuple = this.ts.nextTuple()) != null) {
                    if (this.crit == null || this.eval.evaluate(this.crit, this.currentTuple)) {
                        this.tuplePassed(this.currentTuple);
                        ++this.updateCount;
                        this.undoLog.addTuple(this.currentTuple);
                    }
                    this.currentTuple = null;
                }
                TempTable.this.bm.releaseBuffers(reserved);
                reserved = 0;
                this.success();
                success = true;
            }
            finally {
                TempTable.this.bm.releaseBuffers(reserved);
                try {
                    if (!success) {
                        this.undoLog.setFinal(true);
                        IndexedTupleSource undoTs = this.undoLog.createIndexedTupleSource();
                        List<?> tuple = null;
                        while ((tuple = undoTs.nextTuple()) != null) {
                            this.undo(tuple);
                        }
                    }
                }
                catch (TeiidException e) {
                    LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
                }
                finally {
                    if (!held) {
                        TempTable.this.lock.writeLock().unlock();
                    }
                    this.close();
                }
            }
            return this.updateCount;
        }

        void success() throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        }

        protected abstract void tuplePassed(List var1) throws BlockedException, TeiidComponentException, TeiidProcessingException;

        protected abstract void undo(List var1) throws TeiidComponentException, TeiidProcessingException;

        public void close() {
            this.ts.closeSource();
            this.undoLog.remove();
        }
    }

    private final class QueryTupleSource
    implements TupleSource {
        private final Evaluator eval;
        private final Criteria condition;
        private final boolean project;
        private final int[] indexes;
        private int reserved;
        private TupleBrowser browser;

        private QueryTupleSource(TupleBrowser browser, Map map, List<? extends SingleElementSymbol> projectedCols, Criteria condition) {
            this.browser = browser;
            this.indexes = RelationalNode.getProjectionIndexes(map, projectedCols);
            this.eval = new Evaluator(map, null, null);
            this.condition = condition;
            this.project = this.shouldProject();
            this.reserved = TempTable.this.reserveBuffers();
            if (TempTable.this.updatable) {
                TempTable.this.lock.readLock().lock();
            }
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            List<?> next;
            do {
                if ((next = this.browser.nextTuple()) != null) continue;
                TempTable.this.bm.releaseBuffers(this.reserved);
                this.reserved = 0;
                return null;
            } while (this.condition != null && !this.eval.evaluate(this.condition, next));
            if (this.project) {
                next = RelationalNode.projectTuple(this.indexes, next);
            }
            return next;
        }

        @Override
        public void closeSource() {
            if (TempTable.this.updatable) {
                TempTable.this.lock.readLock().unlock();
            }
            TempTable.this.bm.releaseBuffers(this.reserved);
            this.reserved = 0;
            this.browser.closeSource();
        }

        private boolean shouldProject() {
            if (this.indexes.length == TempTable.this.getColumns().size()) {
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] == i) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    private final class InsertUpdateProcessor
    extends UpdateProcessor {
        private boolean addRowId;
        private int[] indexes;

        private InsertUpdateProcessor(TupleSource ts, boolean addRowId, int[] indexes) throws TeiidComponentException {
            super(null, ts);
            this.addRowId = addRowId;
            this.indexes = indexes;
        }

        @Override
        protected void tuplePassed(List tuple) throws BlockedException, TeiidComponentException, TeiidProcessingException {
            int i;
            if (this.indexes != null) {
                ArrayList<Integer> newTuple = new ArrayList<Integer>(TempTable.this.columns.size());
                if (this.addRowId) {
                    newTuple.add(TempTable.this.rowId.getAndIncrement());
                }
                for (i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] == -1) {
                        AtomicInteger sequence = (AtomicInteger)TempTable.this.sequences.get(i);
                        if (sequence != null) {
                            newTuple.add(sequence.getAndIncrement());
                            continue;
                        }
                        newTuple.add(null);
                        continue;
                    }
                    newTuple.add((Integer)tuple.get(this.indexes[i]));
                }
                tuple = newTuple;
            } else if (this.addRowId) {
                tuple = new ArrayList<Integer>(tuple);
                tuple.add(0, TempTable.this.rowId.getAndIncrement());
            }
            this.currentTuple = tuple;
            Iterator i$ = TempTable.this.notNull.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                if (tuple.get(i) != null) continue;
                throw new TeiidProcessingException(QueryPlugin.Util.getString("TempTable.not_null", new Object[]{TempTable.this.columns.get(i)}));
            }
            TempTable.this.insertTuple(tuple, this.addRowId);
        }

        @Override
        protected void undo(List tuple) throws TeiidComponentException, TeiidProcessingException {
            TempTable.this.deleteTuple(tuple);
        }
    }
}

