/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.xquery.saxon.StreamingUtils;
import org.teiid.translator.WSConnection;

public class SaxonXQueryExpression {
    private static final String EMPTY_STRING = "";
    static final String DEFAULT_PREFIX = "-";
    public static final Properties DEFAULT_OUTPUT_PROPERTIES = new Properties();
    private static final Expression DUMMY_EXPRESSION = new Expression(){

        public ItemType getItemType(TypeHierarchy th) {
            return null;
        }

        public void explain(ExpressionPresenter out) {
        }

        public Expression copy() {
            return null;
        }

        protected int computeCardinality() {
            return 0;
        }

        public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
            return pathMapNodeSet;
        }
    };
    private static final ErrorListener ERROR_LISTENER = new ErrorListener(){

        @Override
        public void warning(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void error(TransformerException arg0) throws TransformerException {
        }

        @Override
        public void fatalError(TransformerException arg0) throws TransformerException {
        }
    };
    XQueryExpression xQuery;
    String xQueryString;
    Map<String, String> namespaceMap;
    Configuration config;
    PathMap.PathMapRoot contextRoot;
    String streamingPath;
    public static final boolean[] isValidAncestorAxis = new boolean[]{false, false, true, false, false, false, false, false, true, true, false, false, true, false};

    public SaxonXQueryExpression(String xQueryString, XMLNamespaces namespaces, List<DerivedColumn> passing, List<XMLTable.XMLColumn> columns) throws QueryResolverException {
        DEFAULT_OUTPUT_PROPERTIES.setProperty("method", "xml");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        this.namespaceMap = new HashMap<String, String>();
        this.config = new Configuration();
        this.config.setErrorListener(ERROR_LISTENER);
        this.xQueryString = xQueryString;
        StaticQueryContext context = new StaticQueryContext(this.config);
        IndependentContext ic = new IndependentContext(this.config);
        this.namespaceMap.put(EMPTY_STRING, EMPTY_STRING);
        if (namespaces != null) {
            for (XMLNamespaces.NamespaceItem item : namespaces.getNamespaceItems()) {
                if (item.getPrefix() == null) {
                    if (item.getUri() == null) {
                        context.setDefaultElementNamespace(EMPTY_STRING);
                        ic.setDefaultElementNamespace(EMPTY_STRING);
                        continue;
                    }
                    context.setDefaultElementNamespace(item.getUri());
                    ic.setDefaultElementNamespace(item.getUri());
                    this.namespaceMap.put(EMPTY_STRING, item.getUri());
                    continue;
                }
                context.declareNamespace(item.getPrefix(), item.getUri());
                ic.declareNamespace(item.getPrefix(), item.getUri());
                this.namespaceMap.put(item.getPrefix(), item.getUri());
            }
        }
        this.namespaceMap.put(DEFAULT_PREFIX, this.namespaceMap.get(EMPTY_STRING));
        for (DerivedColumn derivedColumn : passing) {
            if (derivedColumn.getAlias() == null) continue;
            try {
                context.declareGlobalVariable(StructuredQName.fromClarkName((String)derivedColumn.getAlias()), SequenceType.ANY_SEQUENCE, null, true);
            }
            catch (XPathException e) {
                throw new TeiidRuntimeException((Throwable)e, "Could not define global variable");
            }
        }
        this.processColumns(columns, ic);
        try {
            this.xQuery = context.compileQuery(xQueryString);
        }
        catch (XPathException e) {
            throw new QueryResolverException(e, QueryPlugin.Util.getString("SaxonXQueryExpression.compile_failed"));
        }
    }

    private SaxonXQueryExpression() {
        DEFAULT_OUTPUT_PROPERTIES.setProperty("method", "xml");
        DEFAULT_OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        this.namespaceMap = new HashMap<String, String>();
        this.config = new Configuration();
    }

    public SaxonXQueryExpression clone() {
        SaxonXQueryExpression clone = new SaxonXQueryExpression();
        clone.xQuery = this.xQuery;
        clone.xQueryString = this.xQueryString;
        clone.config = this.config;
        clone.contextRoot = this.contextRoot;
        clone.namespaceMap = this.namespaceMap;
        clone.streamingPath = this.streamingPath;
        return clone;
    }

    public boolean usesContextItem() {
        return this.xQuery.usesContextItem();
    }

    public void useDocumentProjection(List<XMLTable.XMLColumn> columns, AnalysisRecord record) {
        PathMap.PathMapRoot parentRoot;
        block17: {
            try {
                this.streamingPath = StreamingUtils.getStreamingPath(this.xQueryString, this.namespaceMap);
            }
            catch (IllegalArgumentException e) {
                if (!record.recordDebug()) break block17;
                record.println("Document streaming will not be used: " + e.getMessage());
            }
        }
        this.contextRoot = null;
        PathMap map = this.xQuery.getPathMap();
        try {
            parentRoot = map.getContextRoot();
        }
        catch (IllegalStateException e) {
            if (record.recordDebug()) {
                record.println("Document projection will not be used, since multiple context item exist.");
            }
            return;
        }
        if (parentRoot == null) {
            if (record.recordDebug()) {
                record.println("Document projection will not be used, since no context item reference was found in the XQuery");
            }
            return;
        }
        HashSet<PathMap.PathMapNode> finalNodes = new HashSet<PathMap.PathMapNode>();
        this.getReturnableNodes((PathMap.PathMapNode)parentRoot, finalNodes);
        if (!finalNodes.isEmpty()) {
            if (columns != null && !columns.isEmpty()) {
                if (finalNodes.size() != 1) {
                    if (record.recordDebug()) {
                        record.println("Document projection will not be used, since multiple return items exist");
                    }
                    return;
                }
                if ((parentRoot = this.projectColumns(parentRoot, columns, finalNodes.iterator().next(), record)) == null) {
                    return;
                }
            } else {
                for (PathMap.PathMapNode subNode : finalNodes) {
                    subNode.createArc(new AxisExpression(5, (NodeTest)AnyNodeTest.getInstance()));
                }
            }
        }
        if (parentRoot.hasUnknownDependencies()) {
            if (record.recordDebug()) {
                record.println("Document projection will not be used since there are unknown dependencies (most likely a user defined function).");
            }
            return;
        }
        if (record.recordDebug()) {
            StringBuilder sb = new StringBuilder();
            SaxonXQueryExpression.showArcs(sb, (PathMap.PathMapNode)parentRoot, 0);
            record.println("Using path filtering for XQuery context item: \n" + sb.toString());
        }
        this.contextRoot = parentRoot;
    }

    private PathMap.PathMapRoot projectColumns(PathMap.PathMapRoot parentRoot, List<XMLTable.XMLColumn> columns, PathMap.PathMapNode finalNode, AnalysisRecord record) {
        for (XMLTable.XMLColumn xmlColumn : columns) {
            if (xmlColumn.isOrdinal()) continue;
            Expression internalExpression = xmlColumn.getPathExpression().getInternalExpression();
            PathMap subMap = new PathMap(internalExpression);
            PathMap.PathMapRoot subContextRoot = null;
            for (PathMap.PathMapRoot pathMapRoot : subMap.getPathMapRoots()) {
                if (!(pathMapRoot.getRootExpression() instanceof ContextItemExpression) && !(pathMapRoot.getRootExpression() instanceof RootExpression)) continue;
                if (subContextRoot != null) {
                    if (record.recordDebug()) {
                        record.println("Document projection will not be used, since multiple context items exist in column path " + xmlColumn.getPath());
                    }
                    return null;
                }
                subContextRoot = pathMapRoot;
            }
            if (subContextRoot == null) {
                if (!(internalExpression instanceof ContextItemExpression)) continue;
                this.addReturnedArcs(xmlColumn, finalNode);
                continue;
            }
            for (PathMap.PathMapRoot pathMapRoot : subContextRoot.getArcs()) {
                if (this.streamingPath != null && !this.validateColumnForStreaming(record, xmlColumn, (PathMap.PathMapArc)pathMapRoot)) {
                    this.streamingPath = null;
                }
                finalNode.createArc(pathMapRoot.getStep(), pathMapRoot.getTarget());
            }
            HashSet<PathMap.PathMapNode> subFinalNodes = new HashSet<PathMap.PathMapNode>();
            this.getReturnableNodes((PathMap.PathMapNode)subContextRoot, subFinalNodes);
            for (PathMap.PathMapNode subNode : subFinalNodes) {
                this.addReturnedArcs(xmlColumn, subNode);
            }
        }
        PathMap newMap = new PathMap(DUMMY_EXPRESSION);
        PathMap.PathMapRoot newRoot = newMap.makeNewRoot(parentRoot.getRootExpression());
        if (parentRoot.isAtomized()) {
            newRoot.setAtomized();
        }
        if (parentRoot.isReturnable()) {
            newRoot.setReturnable(true);
        }
        if (parentRoot.hasUnknownDependencies()) {
            newRoot.setHasUnknownDependencies();
        }
        for (PathMap.PathMapArc arc : parentRoot.getArcs()) {
            newRoot.createArc(arc.getStep(), arc.getTarget());
        }
        return newMap.reduceToDownwardsAxes(newRoot);
    }

    private boolean validateColumnForStreaming(AnalysisRecord record, XMLTable.XMLColumn xmlColumn, PathMap.PathMapArc arc) {
        boolean ancestor = false;
        LinkedList<PathMap.PathMapArc> arcStack = new LinkedList<PathMap.PathMapArc>();
        arcStack.add(arc);
        while (!arcStack.isEmpty()) {
            PathMap.PathMapArc current = (PathMap.PathMapArc)arcStack.removeFirst();
            byte axis = current.getStep().getAxis();
            if (ancestor) {
                if (current.getTarget().isReturnable() && axis != 8 && axis != 2) {
                    if (record.recordDebug()) {
                        record.println("Document streaming will not be used, since the column path contains an invalid reverse axis " + xmlColumn.getPath());
                    }
                    return false;
                }
                if (!isValidAncestorAxis[axis]) {
                    if (record.recordDebug()) {
                        record.println("Document streaming will not be used, since the column path contains an invalid reverse axis " + xmlColumn.getPath());
                    }
                    return false;
                }
            } else if (!Axis.isSubtreeAxis[axis]) {
                if (axis == 9 || axis == 0 || axis == 1) {
                    if (current.getTarget().isReturnable()) {
                        if (record.recordDebug()) {
                            record.println("Document streaming will not be used, since the column path contains an invalid reverse axis " + xmlColumn.getPath());
                        }
                        return false;
                    }
                    ancestor = true;
                } else {
                    if (record.recordDebug()) {
                        record.println("Document streaming will not be used, since the column path may not reference an ancestor or subtree " + xmlColumn.getPath());
                    }
                    return false;
                }
            }
            for (PathMap.PathMapArc pathMapArc : current.getTarget().getArcs()) {
                arcStack.add(pathMapArc);
            }
        }
        return true;
    }

    private void addReturnedArcs(XMLTable.XMLColumn xmlColumn, PathMap.PathMapNode subNode) {
        if (xmlColumn.getSymbol().getType() == DataTypeManager.DefaultDataClasses.XML) {
            subNode.createArc(new AxisExpression(5, (NodeTest)AnyNodeTest.getInstance()));
        } else {
            subNode.createArc(new AxisExpression(3, (NodeTest)NodeKindTest.TEXT));
            subNode.setAtomized();
        }
    }

    private void getReturnableNodes(PathMap.PathMapNode node, HashSet<PathMap.PathMapNode> finalNodes) {
        if (node.isReturnable()) {
            finalNodes.add(node);
        }
        for (PathMap.PathMapArc arc : node.getArcs()) {
            this.getReturnableNodes(arc.getTarget(), finalNodes);
        }
    }

    private void processColumns(List<XMLTable.XMLColumn> columns, IndependentContext ic) throws QueryResolverException {
        if (columns == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator(this.config);
        eval.setStaticContext((XPathStaticContext)ic);
        for (XMLTable.XMLColumn xmlColumn : columns) {
            XPathExpression exp;
            if (xmlColumn.isOrdinal()) continue;
            String path = xmlColumn.getPath();
            if (path == null) {
                path = xmlColumn.getName();
            }
            if ((path = path.trim()).startsWith("/")) {
                path = path.startsWith("//") ? '.' + path : path.substring(1);
            }
            try {
                exp = eval.createExpression(path);
            }
            catch (XPathException e) {
                throw new QueryResolverException(e, QueryPlugin.Util.getString("SaxonXQueryExpression.invalid_path", new Object[]{xmlColumn.getName(), xmlColumn.getPath()}));
            }
            xmlColumn.setPathExpression(exp);
        }
    }

    public XMLType createXMLType(final SequenceIterator iter, BufferManager bufferManager, boolean emptyOnEmpty) throws XPathException, TeiidComponentException, TeiidProcessingException {
        Item next;
        Item item = iter.next();
        if (item == null && !emptyOnEmpty) {
            return null;
        }
        XMLType.Type type = XMLType.Type.CONTENT;
        if (item instanceof NodeInfo) {
            NodeInfo info = (NodeInfo)item;
            type = SaxonXQueryExpression.getType(info);
        }
        if ((next = iter.next()) != null) {
            type = XMLType.Type.CONTENT;
        }
        SQLXMLImpl xml = XMLSystemFunctions.saveToBufferManager(bufferManager, new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                QueryResult.serializeSequence((SequenceIterator)iter.getAnother(), (Configuration)SaxonXQueryExpression.this.config, (Writer)writer, (Properties)DEFAULT_OUTPUT_PROPERTIES);
            }
        });
        XMLType value = new XMLType((SQLXML)xml);
        value.setType(type);
        return value;
    }

    public static XMLType.Type getType(NodeInfo info) {
        switch (info.getNodeKind()) {
            case 9: {
                return XMLType.Type.DOCUMENT;
            }
            case 1: {
                return XMLType.Type.ELEMENT;
            }
            case 3: {
                return XMLType.Type.TEXT;
            }
            case 8: {
                return XMLType.Type.COMMENT;
            }
            case 7: {
                return XMLType.Type.PI;
            }
        }
        return XMLType.Type.CONTENT;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static void showArcs(StringBuilder sb, PathMap.PathMapNode node, int level) {
        for (PathMap.PathMapArc pathMapArc : node.getArcs()) {
            char[] pad = new char[level * 2];
            Arrays.fill(pad, ' ');
            sb.append(new String(pad));
            sb.append(pathMapArc.getStep());
            sb.append('\n');
            node = pathMapArc.getTarget();
            SaxonXQueryExpression.showArcs(sb, node, level + 1);
        }
    }

    public boolean isStreaming() {
        return this.streamingPath != null;
    }

    public static class Result {
        public SequenceIterator iter;
        public List<Source> sources = new LinkedList<Source>();

        public void close() {
            for (Source source : this.sources) {
                WSConnection.Util.closeSource((Source)source);
            }
            if (this.iter != null) {
                this.iter.close();
            }
            this.sources.clear();
            this.iter = null;
        }
    }

    public static interface RowProcessor {
        public void processRow(NodeInfo var1);
    }
}

