/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.jboss.BaseConnection;
import org.teiid.core.util.UnitTestUtil;

@Ignore
public class TestConnectorBindings
extends BaseConnection {
    static BaseConnection.ServerDatasourceConnection ds;
    static Admin admin;
    private static final String VERSION = "-7.0.0-SNAPSHOT";

    @Before
    public void setUp() throws Exception {
        ds = new BaseConnection.ServerDatasourceConnection();
        admin = AdminFactory.getInstance().createAdmin("admin", "admin".toCharArray(), "mms://127.0.0.1:31443");
        TestConnectorBindings.installVDB();
    }

    @After
    public void tearDown() {
        admin.close();
    }

    public static void end() throws Exception {
        admin = AdminFactory.getInstance().createAdmin("admin", "admin".toCharArray(), "mm://localhost:31443");
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        if (vdb != null) {
            admin.deleteVDB("TransactionsRevisited", 1);
        }
        admin.close();
    }

    @Test
    public void testVDBDeploy() throws Exception {
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        if (vdb != null) {
            admin.deleteVDB("TransactionsRevisited", 1);
        }
        TestConnectorBindings.installVDB();
        Assert.assertNotNull((Object)admin.getVDB("TransactionsRevisited", 1));
        Set vdbs = admin.getVDBs();
        Assert.assertTrue((vdbs.size() >= 1 ? 1 : 0) != 0);
        admin.deleteVDB("TransactionsRevisited", 1);
        Assert.assertNull((Object)admin.getVDB("TransactionsRevisited", 1));
    }

    @Test
    public void testChangeConnectionType() throws Exception {
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        Assert.assertNotNull((Object)vdb);
        VDB.ConnectionType ct = vdb.getConnectionType();
        Assert.assertEquals((Object)VDB.ConnectionType.BY_VERSION, (Object)ct);
        admin.changeVDBConnectionType("TransactionsRevisited", 1, VDB.ConnectionType.ANY);
        vdb = admin.getVDB("TransactionsRevisited", 1);
        ct = vdb.getConnectionType();
        Assert.assertEquals((Object)VDB.ConnectionType.ANY, (Object)ct);
    }

    @Test
    public void testGetVDB() throws Exception {
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        Assert.assertNotNull((Object)vdb);
        Assert.assertEquals((String)"TransactionsRevisited", (String)vdb.getName());
        Assert.assertEquals((int)1, (int)vdb.getVersion());
        Assert.assertEquals((String)"A VDB to test transactions", (String)vdb.getDescription());
        Assert.assertEquals((Object)VDB.Status.INACTIVE, (Object)vdb.getStatus());
        List models = vdb.getModels();
        Assert.assertEquals((int)4, (int)models.size());
        Model model = null;
        for (Model m : models) {
            if (!m.getName().equals("pm1")) continue;
            model = m;
            break;
        }
        Assert.assertNotNull(model);
        Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)model.getModelType());
        Assert.assertEquals((String)"sample-value", (String)model.getPropertyValue("sample"));
        List sourceNames = model.getSourceNames();
        Assert.assertEquals((int)1, (int)sourceNames.size());
        Assert.assertEquals((String)"mysql", (String)model.getSourceTranslatorName((String)sourceNames.get(0)));
        Assert.assertEquals((String)"java:mysql-connector-binding", (String)model.getSourceConnectionJndiName((String)sourceNames.get(0)));
        Assert.assertTrue((boolean)model.isSource());
        Assert.assertTrue((boolean)model.isVisible());
        List policies = vdb.getDataPolicies();
        Assert.assertEquals((int)1, (int)policies.size());
        Assert.assertEquals((String)"policy1", (String)((DataPolicy)policies.get(0)).getName());
        Assert.assertEquals((String)"roleOne described", (String)((DataPolicy)policies.get(0)).getDescription());
        List permissions = ((DataPolicy)policies.get(0)).getPermissions();
        Assert.assertEquals((int)2, (int)permissions.size());
        for (DataPolicy.DataPermission permission : permissions) {
            if (permission.getResourceName().equals("myTable.T1")) {
                Assert.assertTrue((boolean)permission.getAllowRead());
                Assert.assertFalse((boolean)permission.getAllowCreate());
                Assert.assertFalse((boolean)permission.getAllowDelete());
                Assert.assertFalse((boolean)permission.getAllowUpdate());
                continue;
            }
            if (permission.getResourceName().equals("myTable.T2")) {
                Assert.assertFalse((boolean)permission.getAllowRead());
                Assert.assertFalse((boolean)permission.getAllowCreate());
                Assert.assertTrue((boolean)permission.getAllowDelete());
                Assert.assertFalse((boolean)permission.getAllowUpdate());
                continue;
            }
            Assert.fail((String)"there are only two types of permissions");
        }
    }

    @Test
    public void testSessions() throws Exception {
        Connection c = ds.getConnection("TransactionsRevisited");
        Collection sessions = admin.getSessions();
        int size = sessions.size();
        Assert.assertTrue((size >= 1 ? 1 : 0) != 0);
        Session found = null;
        for (Session s : sessions) {
            if (!s.getUserName().equals("admin@teiid-security")) continue;
            found = s;
            break;
        }
        Assert.assertNotNull(found);
        admin.terminateSession(found.getSessionId());
        sessions = admin.getSessions();
        Assert.assertTrue((sessions.size() == size - 1 ? 1 : 0) != 0);
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequests() throws Exception {
        Runnable work = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 5; ++i) {
                    try {
                        TestConnectorBindings.this.execute(ds, "TransactionsRevisited", "select * from pm1.g1");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Thread t = new Thread(work);
        t.start();
        try {
            Collection requests = admin.getRequests();
            Assert.assertTrue((requests.size() >= 0 ? 1 : 0) != 0);
        }
        finally {
            t.join();
        }
        String sessionId = null;
        Collection sessions = admin.getSessions();
        for (Session s : sessions) {
            sessionId = s.getSessionId();
        }
        t = new Thread(work);
        t.start();
        try {
            Collection requests = admin.getRequestsForSession(sessionId);
            Assert.assertTrue((requests.size() >= 0 ? 1 : 0) != 0);
        }
        finally {
            t.join();
        }
    }

    @Test
    public void testCache() throws Exception {
        Collection caches = admin.getCacheTypes();
        Assert.assertEquals((int)3, (int)caches.size());
        admin.clearCache("CODE_TABLE_CACHE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testTransactions() throws Exception {
        Runnable work = new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 10; ++i) {
                        int v = i + 200;
                        TestConnectorBindings.this.execute(ds, "TransactionsRevisited", "insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(" + v + ",'" + v + "'," + v + ",'" + v + "')");
                    }
                    TestConnectorBindings.this.execute(ds, "TransactionsRevisited", "delete from vm.g1 where pm1e1 >= 200");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(work);
        t.start();
        Thread.sleep(2000L);
        try {
            Collection txns = admin.getTransactions();
            Assert.assertTrue((txns.size() >= 0 ? 1 : 0) != 0);
        }
        finally {
            t.join();
        }
    }

    private static void installVDB() throws AdminException, FileNotFoundException {
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        if (vdb == null) {
            File f = UnitTestUtil.getTestDataFile((String)"TransactionsRevisited.vdb");
            FileInputStream fis = new FileInputStream(f);
            admin.deployVDB(f.getName(), (InputStream)fis);
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testTranslatorTemplateProperties() throws Exception {
        Collection defs = admin.getTemplatePropertyDefinitions("translator-jdbc-7.0.0-SNAPSHOT");
        for (PropertyDefinition pd : defs) {
            System.out.println(pd.getName() + ":" + pd.getPropertyTypeClassName() + ":" + pd.getDefaultValue());
            if (!pd.getName().equals("ExtensionTranslationClassName")) continue;
            Assert.assertEquals((String)"Extension SQL Translation Class", (String)pd.getDisplayName());
            Assert.assertEquals((boolean)false, (boolean)pd.isAdvanced());
            Assert.assertEquals((boolean)true, (boolean)pd.isRequired());
            Assert.assertEquals((boolean)false, (boolean)pd.isMasked());
            Assert.assertEquals((boolean)true, (boolean)pd.isModifiable());
            Assert.assertEquals((int)12, (int)pd.getAllowedValues().size());
            System.out.println(pd.getAllowedValues());
        }
    }

    @Test
    public void testGetTemplate() throws Exception {
        Translator translator = admin.getTranslator("oracle");
        for (String key : translator.getProperties().stringPropertyNames()) {
            System.out.println(key + "=" + translator.getPropertyValue(key));
        }
        Assert.assertEquals((String)"org.teiid.translator.jdbc.oracle.OracleSQLTranslator", (String)translator.getPropertyValue("ExtensionTranslationClassName"));
        Assert.assertEquals((Object)false, (Object)translator.getPropertyValue("XaCapable"));
    }

    @Test
    public void testAssignConnectorBinding() throws Exception {
        admin.assignToModel("TransactionsRevisited", 1, "pm1", "mysql", "mysql", "jndi:FOO");
        boolean checked = false;
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        List models = vdb.getModels();
        for (Model model : models) {
            if (!model.getName().equals("pm1")) continue;
            List sources = model.getSourceNames();
            for (String source : sources) {
                if (!source.equals("mysql")) continue;
                Assert.assertEquals((String)"jndi:FOO", (String)model.getSourceConnectionJndiName(source));
                checked = true;
            }
        }
        Assert.assertTrue((String)"Test not veryfied", (boolean)checked);
    }

    @Test
    public void testAddRoleNames() throws Exception {
        List sources;
        TestConnectorBindings.installVDB();
        admin.addDataRoleMapping("TransactionsRevisited", 1, "policy1", "managers");
        VDB vdb = admin.getVDB("TransactionsRevisited", 1);
        List policies = vdb.getDataPolicies();
        Assert.assertTrue((!policies.isEmpty() ? 1 : 0) != 0);
        for (DataPolicy policy : policies) {
            if (!policy.getName().equals("policy1")) continue;
            sources = policy.getMappedRoleNames();
            Assert.assertTrue((boolean)sources.contains("managers"));
        }
        admin.removeDataRoleMapping("TransactionsRevisited", 1, "policy1", "managers");
        vdb = admin.getVDB("TransactionsRevisited", 1);
        policies = vdb.getDataPolicies();
        Assert.assertTrue((!policies.isEmpty() ? 1 : 0) != 0);
        for (DataPolicy policy : policies) {
            if (!policy.getName().equals("policy1")) continue;
            sources = policy.getMappedRoleNames();
            Assert.assertFalse((boolean)sources.contains("managers"));
        }
        admin.removeDataRoleMapping("TransactionsRevisited", 1, "policy1", "FOO");
    }

    @Test
    public void testCreateDataSource() throws Exception {
        Properties p = new Properties();
        p.setProperty("DatabaseName", "txntest");
        p.setProperty("PortNumber", "3306");
        p.setProperty("ServerName", "localhost");
        p.setProperty("additional-ds-properties", "foo=bar, t= x");
        p.setProperty("user-name", "rareddy");
        p.setProperty("password", "mm");
        p.setProperty("xa-datasource-class", "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
        admin.createDataSource("test-mysql", "connector-jdbc-xa", p);
    }

    @Test
    public void testCreateDriverSource() throws Exception {
        Properties p = new Properties();
        p.setProperty("connection-url", "jdbc:mysql://localhost:3306/txntest");
        p.setProperty("additional-connection-properties", "foo=bar, t= x");
        p.setProperty("user-name", "rareddy");
        p.setProperty("password", "mm");
        p.setProperty("driver-class", "com.mysql.jdbc.Driver");
        admin.createDataSource("test-mysql-driver", "connector-jdbc", p);
    }
}

