/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLXML;
import java.sql.Statement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidStatement;

public class TestQueryPlans {
    private static Connection conn;

    @BeforeClass
    public static void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB("test", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        conn = server.createConnection("jdbc:teiid:test");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        conn.close();
    }

    @Test
    public void testNoExec() throws Exception {
        Statement s = conn.createStatement();
        s.execute("set noexec on");
        ResultSet rs = s.executeQuery("select * from all_tables");
        Assert.assertFalse((boolean)rs.next());
        s.execute("SET NOEXEC off");
        rs = s.executeQuery("select * from all_tables");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testShowPlan() throws Exception {
        Statement s = conn.createStatement();
        s.execute("set showplan on");
        ResultSet rs = s.executeQuery("select * from all_tables");
        Assert.assertNotNull((Object)s.unwrap(TeiidStatement.class).getPlanDescription());
        Assert.assertNull((Object)s.unwrap(TeiidStatement.class).getDebugLog());
        rs = s.executeQuery("show plan");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getMetaData().getColumnType(1), (long)2005L);
        Assert.assertTrue((boolean)rs.getString(1).startsWith("ProjectNode"));
        SQLXML plan = rs.getSQLXML(2);
        Assert.assertTrue((boolean)plan.getString().startsWith("<?xml"));
        Assert.assertNull((Object)rs.getObject("DEBUG_LOG"));
        Assert.assertNotNull((Object)rs.getObject("PLAN_TEXT"));
        s.execute("SET showplan debug");
        rs = s.executeQuery("select * from all_tables");
        Assert.assertNotNull((Object)s.unwrap(TeiidStatement.class).getDebugLog());
        rs = s.executeQuery("show plan");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNotNull((Object)rs.getObject("DEBUG_LOG"));
        s.execute("SET showplan off");
        rs = s.executeQuery("select * from all_tables");
        Assert.assertNull((Object)s.unwrap(TeiidStatement.class).getPlanDescription());
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testShow() throws Exception {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("show all");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNotNull((Object)rs.getString("NAME"));
        s.execute("set showplan on");
        rs = s.executeQuery("show showplan");
        rs.next();
        Assert.assertEquals((Object)"on", (Object)rs.getString(1));
    }
}

