/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestSystemVirtualModel
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";

    public TestSystemVirtualModel() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    protected void checkResult(String testName, String query) throws Exception {
        this.execute(query);
        TestMMDatabaseMetaData.compareResultSet("TestSystemVirtualModel/" + testName, this.internalResultSet);
    }

    @Test
    public void testModels() throws Exception {
        this.checkResult("testSchemas", "select* from SYS.Schemas order by Name");
    }

    @Test
    public void testKeys() throws Exception {
        this.checkResult("testKeys", "select* from SYS.Keys order by Name");
    }

    @Test
    public void testGroups() throws Exception {
        this.checkResult("testTables", "select* from SYS.Tables order by Name");
    }

    @Test
    public void testDataTypes() throws Exception {
        this.checkResult("testDataTypes", "select * from SYS.DataTypes order by name");
    }

    @Test
    public void testProcedureParams() throws Exception {
        this.checkResult("testProcedureParams", "select * from SYS.ProcedureParams order by Name");
    }

    @Test
    public void testProcedures() throws Exception {
        this.checkResult("testProcedures", "select* from SYS.Procedures order by Name");
    }

    @Test
    public void testProperties() throws Exception {
        String[] expected = new String[]{"Name[string]\tValue[string]\tUID[string]\tOID[integer]\tClobValue[clob]", "pg_type:oid\t30\tmmuid:ffa4ac73-b549-470e-931f-dc36330cb8c4\t1\t30", "pg_type:oid\t1009\tmmuid:d9f36bdc-7b25-4af0-b9f5-a96aac6d3094\t2\t1009", "pg_type:oid\t1002\tmmuid:bcbed548-176c-4116-a5d6-7638cb0206e1\t3\t1002", "pg_type:oid\t1028\tmmuid:a385751f-a31a-4d5d-9197-3fbd390b0251\t4\t1028"};
        this.executeAndAssertResults("select* from SYS.Properties", expected);
    }

    @Test
    public void testVirtualDatabase() throws Exception {
        String[] expected = new String[]{"Name[string]\tVersion[string]\t", "PartsSupplier\t1"};
        this.executeAndAssertResults("select* from SYS.VirtualDatabases", expected);
    }

    @Test
    public void testKeyColumns() throws Exception {
        this.checkResult("testKeyColumns", "select* from SYS.KeyColumns order by Name, KeyName");
    }

    @Test
    public void testVDBResources() throws IOException, SQLException {
        this.execute("select * from vdbresources", new Object[0]);
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void testColumns() throws Exception {
        this.checkResult("testColumns", "select* from SYS.Columns order by Name");
    }

    @Test
    public void testTableType() throws Exception {
        String[] expected = new String[]{"Type[string]\t", "Table"};
        this.executeAndAssertResults("select distinct Type from SYS.Tables order by Type", expected);
    }

    @Test
    public void testTableIsSystem() throws Exception {
        this.checkResult("testTableIsSystem", "select Name from SYS.Tables where IsSystem = 'false' order by Name");
    }

    @Test
    public void testDefect12064() throws Exception {
        String[] expected = new String[]{"KeyName[string]\tRefKeyUID[string]\t", "PK_PARTS\tnull", "PK_SHIP_VIA\tnull", "PK_STATUS\tnull", "PK_SUPPLIER\tnull", "PK_SUPPLIER_PARTS\tnull", "PK_SUPPLIER_PARTS\tnull", "idx_matpg_relatt_ids\tnull", "idx_matpg_relatt_ids\tnull", "matpg_datatype_ids\tnull", "matpg_datatype_ids\tnull", "matpg_datatype_names\tnull", "matpg_datatype_names\tnull", "pk_matpg_relatt_names\tnull", "pk_matpg_relatt_names\tnull", "pk_matpg_relatt_names\tnull", "pk_pg_attr\tnull", "pk_pg_class\tnull", "pk_pg_index\tnull", "pk_pg_proc\tnull"};
        this.executeAndAssertResults("select KeyName, RefKeyUID FROM SYS.KeyColumns WHERE RefKeyUID IS NULL order by KeyName", expected);
    }

    @Test
    public void testReferenceKeyColumns() throws Exception {
        this.checkResult("testReferenceKeyColumns", "select* FROM SYS.ReferenceKeyColumns order by PKTABLE_NAME");
    }

    @Test
    public void test_UID_OID_are_Equal() throws Exception {
        this.execute("select distinct(UID) FROM SYS.Schemas");
        int uidCount = this.getRowCount();
        this.execute("select distinct(OID) FROM SYS.Schemas");
        int oidCount = this.getRowCount();
        Assert.assertEquals((long)uidCount, (long)oidCount);
        this.execute("select distinct(UID) FROM SYS.DataTypes");
        uidCount = this.getRowCount();
        this.execute("select distinct(OID) FROM SYS.DataTypes");
        oidCount = this.getRowCount();
        Assert.assertEquals((long)uidCount, (long)oidCount);
    }

    @Test
    public void testLogMsg() throws Exception {
        this.execute("call logMsg(level=>'DEBUG', context=>'org.teiid.foo', msg=>'hello world')");
    }

    @Test(expected=SQLException.class)
    public void testLogMsg1() throws Exception {
        this.execute("call logMsg(level=>'foo', context=>'org.teiid.foo', msg=>'hello world')");
    }

    @Test
    public void testAsynch() throws Exception {
        Statement s = this.internalConnection.createStatement();
        TeiidStatement ts = s.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select * from SYS.Schemas", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) {
                ++this.rowCount;
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        });
        Assert.assertEquals((long)4L, (long)((Integer)result.get()).intValue());
    }
}

