/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BlockedException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.QueryProcessorFactoryImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.TestDQPCoreRequestHandling;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestDataTierManager {
    private DQPCore rm;
    private DataTierManagerImpl dtm;
    private CommandContext context;
    private AtomicRequestMessage request;
    private Command command;
    private DataTierTupleSource info;
    private AutoGenDataService connectorManager = new AutoGenDataService();
    private RequestWorkItem workItem;
    private int limit = -1;

    @Before
    public void setUp() {
        this.limit = -1;
        this.connectorManager = new AutoGenDataService();
    }

    private static Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        return command;
    }

    private void helpSetup(int nodeId) throws Exception {
        this.helpSetup("SELECT * FROM BQT1.SmallA", nodeId);
    }

    private void helpSetup(String sql, int nodeId) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, RealMetadataFactory.exampleBQTVDB());
        this.rm = new DQPCore();
        this.rm.setTransactionService((TransactionService)new FakeTransactionService());
        this.rm.setBufferService((BufferService)new FakeBufferService());
        this.rm.setCacheFactory((CacheFactory)new DefaultCacheFactory());
        this.rm.start(new DQPConfiguration());
        FakeBufferService bs = new FakeBufferService();
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)this.connectorManager);
        this.dtm = new DataTierManagerImpl(this.rm, (BufferService)bs, true);
        this.command = TestDataTierManager.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        RequestMessage original = new RequestMessage();
        original.setExecutionId(1L);
        original.setPartialResults(true);
        RequestID requestID = workContext.getRequestID(original.getExecutionId());
        this.context = new CommandContext();
        this.context.setProcessorID((Object)requestID);
        this.context.setVdbName("test");
        this.context.setVdbVersion(1);
        this.context.setQueryProcessorFactory((QueryProcessor.ProcessorFactory)new QueryProcessorFactoryImpl(bs.getBufferManager(), (ProcessorDataManager)this.dtm, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), null, (QueryMetadataInterface)metadata));
        this.workItem = TestDQPCoreRequestHandling.addRequest(this.rm, original, requestID, null, workContext);
        this.request = new AtomicRequestMessage(original, workContext, nodeId);
        this.request.setCommand(this.command);
        this.request.setConnectorName("FakeConnectorID");
        this.info = new DataTierTupleSource(this.request, this.workItem, this.connectorManager.registerRequest(this.request), this.dtm, this.limit);
    }

    @Test
    public void testDataTierTupleSource() throws Exception {
        this.helpSetup(1);
        int i = 0;
        while (i < 10) {
            try {
                this.info.nextTuple();
                ++i;
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
            }
        }
        Assert.assertNotNull((Object)this.workItem.getConnectorRequest(this.request.getAtomicRequestID()));
        Assert.assertNull((Object)this.info.nextTuple());
        this.info.closeSource();
        Assert.assertNull((Object)this.workItem.getConnectorRequest(this.request.getAtomicRequestID()));
    }

    @Test
    public void testDataTierTupleSourceLimit() throws Exception {
        this.limit = 1;
        this.helpSetup(1);
        int i = 0;
        while (i < 1) {
            try {
                this.info.nextTuple();
                ++i;
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
            }
        }
        Assert.assertNotNull((Object)this.workItem.getConnectorRequest(this.request.getAtomicRequestID()));
        Assert.assertNull((Object)this.info.nextTuple());
        this.info.closeSource();
        Assert.assertNull((Object)this.workItem.getConnectorRequest(this.request.getAtomicRequestID()));
    }

    @Test
    public void testPartialResults() throws Exception {
        this.helpSetup(1);
        this.connectorManager.throwExceptionOnExecute = true;
        for (int i = 0; i < 10; ++i) {
            try {
                Assert.assertNull((Object)this.info.nextTuple());
                return;
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
                continue;
            }
        }
        Assert.fail();
    }

    @Test
    public void testNoRowsException() throws Exception {
        this.connectorManager.setRows(0);
        this.helpSetup(3);
        while (true) {
            try {
                Assert.assertNull((Object)this.info.nextTuple());
            }
            catch (BlockedException e) {
                Thread.sleep(50L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testAsynch() throws Exception {
        this.connectorManager.dataNotAvailable = 10;
        this.connectorManager.setRows(0);
        this.helpSetup(3);
        boolean blocked = false;
        while (true) {
            try {
                Assert.assertNull((Object)this.info.nextTuple());
            }
            catch (BlockedException e) {
                blocked = true;
                Thread.sleep(50L);
                continue;
            }
            break;
        }
        Assert.assertTrue((boolean)blocked);
    }
}

