/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialClob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.NestedTableJoinStrategy;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestTextTable {
    @Test
    public void testCorrelatedTextTable() throws Exception {
        String sql = "select x.* from pm1.g1, texttable(e1 || ',' || e2 COLUMNS x string, y integer) x";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("c", 1), Arrays.asList("b", 2), Arrays.asList("a", 0)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableFixed() throws Exception {
        String sql = "select max(compkey), max(cdm_id), max(currency), max(\"start\"), max(maturity), max(amount), count(*) from texttable(? COLUMNS compkey string width 76, CDM_ID string width 14, CURRENCY string width 9, \"START\" string width 31, MATURITY string width 31, AMOUNT double width 21, RECORDSOURCE string width 13, SUMMIT_ID string width 15, RATE double width 20, SPREAD double width 20, DESK string width 14) x";
        List[] expected = new List[]{Arrays.asList("000369USD05/20/200405/20/2007", "000369", "USD", "12/18/2000", "12/19/2005", 6.7209685146E8, 52)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/cdm_dos.txt")));
    }

    @Test
    public void testTextTableFixedWin() throws Exception {
        String sql = "select max(compkey), max(cdm_id), max(currency), max(\"start\"), max(maturity), max(amount), count(*) from texttable(? COLUMNS compkey string width 76, CDM_ID string width 14, CURRENCY string width 9, \"START\" string width 31, MATURITY string width 31, AMOUNT double width 21, RECORDSOURCE string width 13, SUMMIT_ID string width 15, RATE double width 20, SPREAD double width 20, DESK string width 14) x";
        List[] expected = new List[]{Arrays.asList("000369USD05/20/200405/20/2007", "000369", "USD", "12/18/2000", "12/19/2005", 6.7209685146E8, 52)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/cdm_dos_win.txt")));
    }

    @Test
    public void testTextTableFixedPartial() throws Exception {
        String sql = "select max(length(compkey)) from texttable(? COLUMNS compkey string width 76) x";
        List[] expected = new List[]{Arrays.asList(30)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/cdm_dos.txt")));
    }

    @Test
    public void testNamedMultilineHeader() throws Exception {
        String sql = "SELECT * from texttable(? COLUMNS Col3Head string HEADER) x";
        List[] expected = new List[]{Arrays.asList("VAL2"), Arrays.asList("VAL4"), Arrays.asList("abc"), Arrays.asList("VAL9")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/test-file.txt.csv")));
    }

    @Test
    public void testHeaderWithSkip() throws Exception {
        String sql = "select count(*) from texttable(? COLUMNS PARTNAME string HEADER 3 SKIP 5) x";
        List[] expected = new List[]{Arrays.asList(21)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/TextParts_HeaderRow2.csv")));
    }

    @Test
    public void testEscape() throws Exception {
        String sql = "select * from texttable('a\\,b,c\\\na\na,b\\\\' COLUMNS c1 string, c2 string ESCAPE '\\') x";
        List[] expected = new List[]{Arrays.asList("a,b", "c\na"), Arrays.asList("a", "b\\")};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testEscapeError() throws Exception {
        String sql = "select * from texttable('axq' COLUMNS c1 string ESCAPE 'x') x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testDelimiter() throws Exception {
        String sql = "select * from texttable('\na\\,b,c' COLUMNS c1 string, c2 string DELIMITER 'b') x";
        List[] expected = new List[]{Arrays.asList("a\\,", ",c")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testNoRowDelimiter() throws Exception {
        String sql = "select * from texttable('abcdef' COLUMNS c1 string width 1, c2 string width 1 no row delimiter) x";
        List[] expected = new List[]{Arrays.asList("a", "b"), Arrays.asList("c", "d"), Arrays.asList("e", "f")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testNoTrim() throws Exception {
        String sql = "select * from texttable('a b \nc  d' COLUMNS c1 string width 2, c2 string width 2 no trim) x";
        List[] expected = new List[]{Arrays.asList("a", "b "), Arrays.asList("c", " d")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testNoRows() throws Exception {
        String sql = "select * from texttable('' COLUMNS c1 string, c2 string SKIP 3) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testMissingValues() throws Exception {
        String sql = "select * from texttable('a,b\nc' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{Arrays.asList("a", "b"), Arrays.asList("c", null)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testQuote() throws Exception {
        String sql = "select * from texttable('  \" a\", \" \"\" \"' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{Arrays.asList(" a", " \" ")};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testUnclosedQuoteError() throws Exception {
        String sql = "select * from texttable('  \" a\", \" \"\"' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testQuoteError() throws Exception {
        String sql = "select * from texttable('  \" a\", x\" \"\" \"' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testHeaderError() throws Exception {
        String sql = "select * from texttable('notc1,notc2' COLUMNS c1 string, c2 string HEADER) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableCriteria() throws Exception {
        String sql = "select x.* from texttable('a' || ',' || '1' COLUMNS x string, y integer) x where x.y = 1";
        List[] expected = new List[]{Arrays.asList("a", 1)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableGroupBy() throws Exception {
        String sql = "select max(x) from texttable('a' || ',' || '1' COLUMNS x string, y integer) x group by y";
        List[] expected = new List[]{Arrays.asList("a")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableSubquery() throws Exception {
        String sql = "select x.* from pm1.g1, texttable(e1 || ',' || e2 COLUMNS x string, y integer) x where y < (select avg(e2) from pm1.g1 as x)";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("c", 1), Arrays.asList("a", 0)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableMultiBatch() throws Exception {
        String sql = "select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x";
        List[] expected = new List[]{Arrays.asList("c"), Arrays.asList("1"), Arrays.asList("true")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableJoin() throws Exception {
        String sql = "select z.* from (select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x) as z, (select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x) as z1 where z.x = z1.x";
        List[] expected = new List[]{Arrays.asList("c"), Arrays.asList("1"), Arrays.asList("true")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        RelationalPlan plan = (RelationalPlan)TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        JoinNode join = (JoinNode)plan.getRootNode().getChildren()[0];
        Assert.assertTrue((!(join.getJoinStrategy() instanceof NestedTableJoinStrategy) ? 1 : 0) != 0);
        TestProcessor.helpProcess((ProcessorPlan)plan, TestProcessor.createCommandContext(), dataManager, expected);
    }

    @Test
    public void testTextTableJoin1() throws Exception {
        String sql = "select e1, e2 from texttable('a' COLUMNS col string) x, pm1.g1 where col = e1";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("a", 0)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        RelationalPlan plan = (RelationalPlan)TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess((ProcessorPlan)plan, TestProcessor.createCommandContext(), dataManager, expected);
    }

    public static void process(String sql, List[] expectedResults) throws Exception {
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), dataManager, expectedResults);
    }

    public static ClobType clobFromFile(String file) {
        return new ClobType((Clob)new ClobImpl((InputStreamFactory)new InputStreamFactory.FileInputStreamFactory(UnitTestUtil.getTestDataFile((String)file)), -1L));
    }

    @Test
    public void testTextAgg() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select convert(to_chars(textagg(for pm1.g1.e1, pm1.g1.e2 header order by e2), 'UTF-8'), string) as x from pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", new List[]{Arrays.asList("z", 2), Arrays.asList("b", 1)});
        hdm.setBlockOnce(true);
        String nl = System.getProperty("line.separator");
        ArrayList<String> list = new ArrayList<String>();
        list.add("\"e1\",\"e2\"" + nl + "\"b\",\"1\"" + nl + "\"z\",\"2\"" + nl);
        List[] expected = new List[]{list};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test
    public void testTextAggOrderByUnrelated() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select convert(to_chars(textagg(for pm1.g1.e1 header order by e2), 'UTF-8'), string) as x from pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", new List[]{Arrays.asList("z", 2), Arrays.asList("b", 1)});
        hdm.setBlockOnce(true);
        String nl = System.getProperty("line.separator");
        ArrayList<String> list = new ArrayList<String>();
        list.add("\"e1\"" + nl + "\"b\"" + nl + "\"z\"" + nl);
        List[] expected = new List[]{list};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testTextTableInvalidData() throws Exception {
        String sql = "select count(*) from texttable(? COLUMNS PARTNAME string) x";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        char[] data = new char[5000];
        TestProcessor.processPreparedStatement(sql, null, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(new ClobType((Clob)new SerialClob(data))));
    }
}

