/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestCriteriaSelector
extends TestCase {
    public TestCriteriaSelector(String name) {
        super(name);
    }

    public static final CriteriaSelector sample1() {
        ElementSymbol sy1 = new ElementSymbol("a");
        ElementSymbol sy2 = new ElementSymbol("b");
        ElementSymbol sy3 = new ElementSymbol("c");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(1, elmnts);
        return cs;
    }

    public static final CriteriaSelector sample2() {
        ElementSymbol sy1 = new ElementSymbol("x");
        ElementSymbol sy2 = new ElementSymbol("y");
        ElementSymbol sy3 = new ElementSymbol("z");
        ArrayList<ElementSymbol> elmnts = new ArrayList<ElementSymbol>(3);
        elmnts.add(sy1);
        elmnts.add(sy2);
        elmnts.add(sy3);
        CriteriaSelector cs = new CriteriaSelector(7, elmnts);
        return cs;
    }

    public void testGetElements() {
        CriteriaSelector cs1 = TestCriteriaSelector.sample1();
        List elmts = cs1.getElements();
        TestCriteriaSelector.assertTrue((String)"Incorrect number of elements in the selector", (elmts.size() == 3 ? 1 : 0) != 0);
    }

    public void testGetType() {
        CriteriaSelector cs1 = TestCriteriaSelector.sample1();
        TestCriteriaSelector.assertTrue((String)"Incorrect type in the selector", (cs1.getSelectorType() == 1 ? 1 : 0) != 0);
    }

    public void testaddElement1() {
        CriteriaSelector cs1 = (CriteriaSelector)TestCriteriaSelector.sample1().clone();
        cs1.addElement(new ElementSymbol("d"));
        TestCriteriaSelector.assertTrue((String)"Incorrect number of statements in the Block", (cs1.getElements().size() == 4 ? 1 : 0) != 0);
    }

    public void testSelfEquivalence() {
        CriteriaSelector s1 = TestCriteriaSelector.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        CriteriaSelector s1 = TestCriteriaSelector.sample1();
        CriteriaSelector s1a = TestCriteriaSelector.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        CriteriaSelector s1 = TestCriteriaSelector.sample1();
        CriteriaSelector s2 = TestCriteriaSelector.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }
}

