/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import org.teiid.common.buffer.impl.DataObjectOutputStream;

public class DataObjectInputStream
extends DataInputStream
implements ObjectInput {
    ObjectInput ois;
    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public DataObjectInputStream(InputStream in) {
        super(in);
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        if (this.ois == null) {
            this.ois = new ObjectInputStream(this){

                @Override
                protected void readStreamHeader() throws IOException, StreamCorruptedException {
                    int version = this.readByte() & 0xFF;
                    if (version != 5) {
                        throw new StreamCorruptedException("Unsupported version: " + version);
                    }
                }

                @Override
                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    int type = this.read();
                    if (type < 0) {
                        throw new EOFException();
                    }
                    switch (type) {
                        case 0: {
                            return super.readClassDescriptor();
                        }
                        case 1: {
                            String className = this.readUTF();
                            Class<?> clazz = this.loadClass(className);
                            return ObjectStreamClass.lookup(clazz);
                        }
                    }
                    String className = DataObjectOutputStream.typeMapping.get((byte)type);
                    if (className == null) {
                        throw new StreamCorruptedException("Unknown class type " + type);
                    }
                    Class<?> clazz = this.loadClass(className);
                    return ObjectStreamClass.lookup(clazz);
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String className = desc.getName();
                    try {
                        return this.loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }

                protected Class<?> loadClass(String className) throws ClassNotFoundException {
                    Class<?> clazz = DataObjectInputStream.this.classLoader != null ? DataObjectInputStream.this.classLoader.loadClass(className) : Class.forName(className);
                    return clazz;
                }
            };
        }
        return this.ois.readObject();
    }
}

