/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.rowset.serial.SerialClob;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.BufferService;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.util.CommandContext;

public class DataTierManagerImpl
implements ProcessorDataManager {
    private static final int MAX_VALUE_LENGTH = 0x200000;
    private static final TreeMap<String, Integer> levelMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private DQPCore requestMgr;
    private BufferService bufferService;
    private EventDistributor eventDistributor;
    private boolean detectChangeEvents;
    private MetadataRepository metadataRepository;

    public static int getLevel(String level) throws TeiidProcessingException {
        Integer intLevel = levelMap.get(level);
        if (intLevel == null) {
            throw new TeiidProcessingException(QueryPlugin.Util.getString("FunctionMethods.unknown_level", new Object[]{level, levelMap.keySet()}));
        }
        return intLevel;
    }

    public DataTierManagerImpl(DQPCore requestMgr, BufferService bufferService, boolean detectChangeEvents) {
        this.requestMgr = requestMgr;
        this.bufferService = bufferService;
        this.detectChangeEvents = detectChangeEvents;
    }

    public boolean detectChangeEvents() {
        return this.detectChangeEvents;
    }

    public void setEventDistributor(EventDistributor eventDistributor) {
        this.eventDistributor = eventDistributor;
    }

    @Override
    public EventDistributor getEventDistributor() {
        return this.eventDistributor;
    }

    @Override
    public MetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public void setMetadataRepository(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException, TeiidProcessingException {
        RequestWorkItem workItem = this.requestMgr.getRequestWorkItem((RequestID)context.getProcessorID());
        if ("SYS".equals(modelName) || "SYSADMIN".equals(modelName)) {
            return this.processSystemQuery(context, command, workItem.getDqpWorkContext());
        }
        AtomicRequestMessage aqr = this.createRequest(context.getProcessorID(), command, modelName, connectorBindingId, nodeID);
        SourceHint sh = context.getSourceHint();
        if (sh != null) {
            aqr.setGeneralHint(sh.getGeneralHint());
            aqr.setHint(sh.getSourceHint(aqr.getConnectorName()));
        }
        if (limit > 0) {
            aqr.setFetchSize(Math.min(limit, aqr.getFetchSize()));
        }
        if (context.getDataObjects() != null) {
            for (GroupSymbol gs : GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, false)) {
                context.accessedDataObject(gs.getMetadataID());
            }
        }
        ConnectorManagerRepository cmr = (ConnectorManagerRepository)workItem.getDqpWorkContext().getVDB().getAttachment(ConnectorManagerRepository.class);
        ConnectorWork work = cmr.getConnectorManager(aqr.getConnectorName()).registerRequest(aqr);
        work.setRequestWorkItem(workItem);
        return new DataTierTupleSource(aqr, workItem, work, this, limit);
    }

    private TupleSource processSystemQuery(CommandContext context, Command command, DQPWorkContext workContext) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<List<Object>> rows;
        block82: {
            TransformationMetadata indexMetadata;
            CompositeMetadataStore metadata;
            int vdbVersion;
            String vdbName;
            block81: {
                vdbName = workContext.getVdbName();
                vdbVersion = workContext.getVdbVersion();
                VDBMetaData vdb = workContext.getVDB();
                metadata = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
                indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
                rows = new ArrayList<List<Object>>();
                int oid = 1;
                if (!(command instanceof Query)) break block81;
                Query query = (Query)command;
                UnaryFromClause ufc = (UnaryFromClause)query.getFrom().getClauses().get(0);
                GroupSymbol group = ufc.getGroup();
                if (StringUtil.startsWithIgnoreCase((String)group.getNonCorrelationName(), (String)"SYSADMIN")) {
                    SystemAdminTables sysTable = SystemAdminTables.valueOf(group.getNonCorrelationName().substring("SYSADMIN".length() + 1).toUpperCase());
                    switch (sysTable) {
                        case MATVIEWS: {
                            for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                                for (Table table : schema.getTables().values()) {
                                    if (!table.isMaterialized()) continue;
                                    String targetSchema = null;
                                    String matTableName = null;
                                    String state = null;
                                    Timestamp updated = null;
                                    Integer cardinaltity = null;
                                    Boolean valid = null;
                                    if (table.getMaterializedTable() == null) {
                                        GlobalTableStore globalStore = context.getGlobalTableStore();
                                        matTableName = "#MAT_" + table.getFullName().toUpperCase();
                                        GlobalTableStoreImpl.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
                                        valid = info.isValid();
                                        state = info.getState().name();
                                        updated = info.getUpdateTime() == -1L ? null : new Timestamp(info.getUpdateTime());
                                        TempMetadataID id = globalStore.getTempTableStore().getMetadataStore().getTempGroupID(matTableName);
                                        if (id != null) {
                                            cardinaltity = id.getCardinality();
                                        }
                                    } else {
                                        Table t = table.getMaterializedTable();
                                        matTableName = t.getName();
                                        targetSchema = ((Schema)t.getParent()).getName();
                                    }
                                    rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), targetSchema, matTableName, valid, state, updated, cardinaltity));
                                }
                            }
                            break;
                        }
                        case VDBRESOURCES: {
                            String[] filePaths;
                            for (String filePath : filePaths = indexMetadata.getVDBResourcePaths()) {
                                rows.add(Arrays.asList(filePath, new BlobType((Blob)indexMetadata.getVDBResourceAsBlob(filePath))));
                            }
                            break;
                        }
                    }
                    return new CollectionTupleSource(rows.iterator());
                }
                SystemTables sysTable = SystemTables.valueOf(group.getNonCorrelationName().substring("SYS".length() + 1).toUpperCase());
                switch (sysTable) {
                    case DATATYPES: {
                        for (Datatype datatype : metadata.getDatatypes()) {
                            rows.add(Arrays.asList(datatype.getName(), datatype.isBuiltin(), datatype.isBuiltin(), datatype.getName(), datatype.getJavaClassName(), datatype.getScale(), datatype.getLength(), datatype.getNullType().toString(), datatype.isSigned(), datatype.isAutoIncrement(), datatype.isCaseSensitive(), datatype.getPrecisionLength(), datatype.getRadix(), datatype.getSearchType().toString(), datatype.getUUID(), datatype.getRuntimeTypeName(), datatype.getBasetypeName(), datatype.getAnnotation(), oid++));
                        }
                        break block82;
                    }
                    case VIRTUALDATABASES: {
                        rows.add(Arrays.asList(vdbName, vdbVersion));
                        break;
                    }
                    case SCHEMAS: {
                        for (Schema model : this.getVisibleSchemas(vdb, metadata)) {
                            rows.add(Arrays.asList(vdbName, model.getName(), model.isPhysical(), model.getUUID(), model.getAnnotation(), model.getPrimaryMetamodelUri(), oid++));
                        }
                        break block82;
                    }
                    case PROCEDURES: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Procedure proc : schema.getProcedures().values()) {
                                rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), proc.getNameInSource(), proc.getResultSet() != null, proc.getUUID(), proc.getAnnotation(), oid++));
                            }
                        }
                        break block82;
                    }
                    case PROCEDUREPARAMS: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Procedure proc : schema.getProcedures().values()) {
                                Datatype dt;
                                for (ProcedureParameter param : proc.getParameters()) {
                                    dt = param.getDatatype();
                                    rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), param.getName(), dt != null ? dt.getRuntimeTypeName() : null, param.getPosition(), param.getType().toString(), param.isOptional(), param.getPrecision(), param.getLength(), param.getScale(), param.getRadix(), param.getNullType().toString(), param.getUUID(), param.getAnnotation(), oid++));
                                }
                                if (proc.getResultSet() == null) continue;
                                for (ProcedureParameter param : proc.getResultSet().getColumns()) {
                                    dt = param.getDatatype();
                                    rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), param.getName(), dt != null ? dt.getRuntimeTypeName() : null, param.getPosition(), "ResultSet", false, param.getPrecision(), param.getLength(), param.getScale(), param.getRadix(), param.getNullType().toString(), param.getUUID(), param.getAnnotation(), oid++));
                                }
                            }
                        }
                        break block82;
                    }
                    case PROPERTIES: {
                        Collection<AbstractMetadataRecord> records = DataTierManagerImpl.getAllPropertiedObjects(metadata, this.getVisibleSchemas(vdb, metadata));
                        for (AbstractMetadataRecord record : records) {
                            for (Map.Entry entry : record.getProperties().entrySet()) {
                                String value = (String)entry.getValue();
                                ClobType clobValue = null;
                                if (value != null) {
                                    try {
                                        clobValue = new ClobType((Clob)new SerialClob(value.toCharArray()));
                                    }
                                    catch (SQLException e) {
                                        throw new TeiidProcessingException((Throwable)e);
                                    }
                                }
                                rows.add(Arrays.asList(entry.getKey(), entry.getValue(), record.getUUID(), oid++, clobValue));
                            }
                        }
                        break block82;
                    }
                    default: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            block51: for (Table table : schema.getTables().values()) {
                                switch (sysTable) {
                                    case TABLES: {
                                        rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), table.getTableType().toString(), table.getNameInSource(), table.isPhysical(), table.supportsUpdate(), table.getUUID(), table.getCardinality(), table.getAnnotation(), table.isSystem(), table.isMaterialized(), oid++));
                                        break;
                                    }
                                    case COLUMNS: {
                                        for (Column column : table.getColumns()) {
                                            Datatype dt = column.getDatatype();
                                            rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), column.getName(), column.getPosition(), column.getNameInSource(), dt != null ? dt.getRuntimeTypeName() : null, column.getScale(), column.getLength(), column.isFixedLength(), column.isSelectable(), column.isUpdatable(), column.isCaseSensitive(), column.isSigned(), column.isCurrency(), column.isAutoIncremented(), column.getNullType().toString(), column.getMinimumValue(), column.getMaximumValue(), column.getDistinctValues(), column.getNullValues(), column.getSearchType().toString(), column.getFormat(), column.getDefaultValue(), dt != null ? dt.getJavaClassName() : null, column.getPrecision(), column.getCharOctetLength(), column.getRadix(), column.getUUID(), column.getAnnotation(), oid++));
                                        }
                                        continue block51;
                                    }
                                    case KEYS: {
                                        for (KeyRecord key : table.getAllKeys()) {
                                            rows.add(Arrays.asList(vdbName, ((Schema)table.getParent()).getName(), table.getName(), key.getName(), key.getAnnotation(), key.getNameInSource(), key.getType().toString(), false, key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null, key.getUUID(), oid++));
                                        }
                                        continue block51;
                                    }
                                    case KEYCOLUMNS: {
                                        for (KeyRecord key : table.getAllKeys()) {
                                            int postition = 1;
                                            for (Column column : key.getColumns()) {
                                                rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), column.getName(), key.getName(), key.getType().toString(), key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null, key.getUUID(), postition++, oid++));
                                            }
                                        }
                                        continue block51;
                                    }
                                    case REFERENCEKEYCOLUMNS: {
                                        for (KeyRecord key : table.getForeignKeys()) {
                                            short postition = 0;
                                            for (Column column : key.getColumns()) {
                                                Table pkTable = (Table)key.getPrimaryKey().getParent();
                                                Serializable[] serializableArray = new Serializable[14];
                                                serializableArray[0] = vdbName;
                                                serializableArray[1] = ((Schema)pkTable.getParent()).getName();
                                                serializableArray[2] = pkTable.getName();
                                                serializableArray[3] = ((Column)key.getPrimaryKey().getColumns().get(postition)).getName();
                                                serializableArray[4] = vdbName;
                                                serializableArray[5] = schema.getName();
                                                serializableArray[6] = table.getName();
                                                serializableArray[7] = column.getName();
                                                postition = (short)(postition + 1);
                                                serializableArray[8] = Short.valueOf(postition);
                                                serializableArray[9] = Integer.valueOf(3);
                                                serializableArray[10] = Integer.valueOf(3);
                                                serializableArray[11] = key.getName();
                                                serializableArray[12] = key.getPrimaryKey().getName();
                                                serializableArray[13] = Integer.valueOf(5);
                                                rows.add(Arrays.asList(serializableArray));
                                            }
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        break block82;
                    }
                }
                break block82;
            }
            StoredProcedure proc = (StoredProcedure)command;
            if (StringUtil.startsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)"SYSADMIN")) {
                SystemAdminProcs sysProc = SystemAdminProcs.valueOf(proc.getProcedureCallableName().substring("SYSADMIN".length() + 1).toUpperCase());
                switch (sysProc) {
                    case LOGMSG: 
                    case ISLOGGABLE: {
                        String level = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                        String logContext = (String)((Constant)proc.getParameter(3).getExpression()).getValue();
                        Object message = null;
                        if (sysProc == SystemAdminProcs.LOGMSG) {
                            message = ((Constant)proc.getParameter(4).getExpression()).getValue();
                        }
                        int msgLevel = DataTierManagerImpl.getLevel(level);
                        boolean logged = false;
                        if (LogManager.isMessageToBeRecorded((String)logContext, (int)msgLevel)) {
                            if (message != null) {
                                LogManager.log((int)msgLevel, (String)logContext, (Object)message);
                            }
                            logged = true;
                        }
                        if (proc.returnParameters()) {
                            rows.add(Arrays.asList(logged));
                        }
                        return new CollectionTupleSource(rows.iterator());
                    }
                    case SETPROPERTY: {
                        try {
                            AbstractMetadataRecord target;
                            String uuid = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                            String key = (String)((Constant)proc.getParameter(3).getExpression()).getValue();
                            Clob value = (Clob)((Constant)proc.getParameter(4).getExpression()).getValue();
                            String strVal = null;
                            String result = null;
                            if (value != null) {
                                if (value.length() > 0x200000L) {
                                    throw new TeiidProcessingException(QueryPlugin.Util.getString("DataTierManagerImpl.max_value_length", new Object[]{0x200000}));
                                }
                                strVal = ObjectConverterUtil.convertToString((Reader)value.getCharacterStream());
                            }
                            if ((target = DataTierManagerImpl.getByUuid(metadata, uuid)) == null) {
                                throw new TeiidProcessingException(QueryPlugin.Util.getString("DataTierManagerImpl.unknown_uuid", new Object[]{uuid}));
                            }
                            if (this.metadataRepository != null) {
                                this.metadataRepository.setProperty(vdbName, vdbVersion, target, key, strVal);
                            }
                            result = target.setProperty(key, strVal);
                            if (this.eventDistributor != null) {
                                this.eventDistributor.setProperty(vdbName, vdbVersion, uuid, key, strVal);
                            }
                            if (proc.returnParameters()) {
                                if (result == null) {
                                    rows.add(Arrays.asList(new Clob[]{null}));
                                } else {
                                    rows.add(Arrays.asList(new ClobType((Clob)new SerialClob(result.toCharArray()))));
                                }
                            }
                            return new CollectionTupleSource(rows.iterator());
                        }
                        catch (SQLException e) {
                            throw new TeiidProcessingException((Throwable)e);
                        }
                        catch (IOException e) {
                            throw new TeiidProcessingException((Throwable)e);
                        }
                    }
                }
                Table table = indexMetadata.getGroupID((String)((Constant)proc.getParameter(1).getExpression()).getValue());
                switch (sysProc) {
                    case SETCOLUMNSTATS: {
                        String columnName = (String)((Constant)proc.getParameter(2).getExpression()).getValue();
                        Column c = null;
                        for (Column col : table.getColumns()) {
                            if (!col.getName().equalsIgnoreCase(columnName)) continue;
                            c = col;
                            break;
                        }
                        if (c == null) {
                            throw new TeiidProcessingException(columnName + TransformationMetadata.NOT_EXISTS_MESSAGE);
                        }
                        Integer distinctVals = (Integer)((Constant)proc.getParameter(3).getExpression()).getValue();
                        Integer nullVals = (Integer)((Constant)proc.getParameter(4).getExpression()).getValue();
                        String max = (String)((Constant)proc.getParameter(5).getExpression()).getValue();
                        String min = (String)((Constant)proc.getParameter(6).getExpression()).getValue();
                        ColumnStats columnStats = new ColumnStats();
                        columnStats.setDistinctValues(distinctVals);
                        columnStats.setNullValues(nullVals);
                        columnStats.setMaximumValue(max);
                        columnStats.setMinimumValue(min);
                        if (this.metadataRepository != null) {
                            this.metadataRepository.setColumnStats(vdbName, vdbVersion, c, columnStats);
                        }
                        c.setColumnStats(columnStats);
                        if (this.eventDistributor == null) break;
                        this.eventDistributor.setColumnStats(vdbName, vdbVersion, ((Schema)table.getParent()).getName(), table.getName(), columnName, columnStats);
                        break;
                    }
                    case SETTABLESTATS: {
                        Constant val = (Constant)proc.getParameter(2).getExpression();
                        int cardinality = (Integer)val.getValue();
                        TableStats tableStats = new TableStats();
                        tableStats.setCardinality(Integer.valueOf(cardinality));
                        if (this.metadataRepository != null) {
                            this.metadataRepository.setTableStats(vdbName, vdbVersion, table, tableStats);
                        }
                        table.setCardinality(cardinality);
                        if (this.eventDistributor == null) break;
                        this.eventDistributor.setTableStats(vdbName, vdbVersion, ((Schema)table.getParent()).getName(), table.getName(), tableStats);
                    }
                }
                table.setLastModified(System.currentTimeMillis());
                return new CollectionTupleSource(rows.iterator());
            }
            SystemProcs sysTable = SystemProcs.valueOf(proc.getProcedureCallableName().substring("SYS".length() + 1).toUpperCase());
            switch (sysTable) {
                case GETXMLSCHEMAS: {
                    try {
                        Table groupID = indexMetadata.getGroupID((String)((Constant)proc.getParameter(1).getExpression()).getValue());
                        List<SQLXMLImpl> schemas = indexMetadata.getXMLSchemas(groupID);
                        for (SQLXMLImpl schema : schemas) {
                            rows.add(Arrays.asList(new XMLType((SQLXML)schema)));
                        }
                        break;
                    }
                    catch (QueryMetadataException e) {
                        throw new TeiidProcessingException((Throwable)((Object)e));
                    }
                }
            }
        }
        return new CollectionTupleSource(rows.iterator());
    }

    public static AbstractMetadataRecord getByUuid(CompositeMetadataStore metadata, String uuid) {
        for (AbstractMetadataRecord object : DataTierManagerImpl.getAllPropertiedObjects(metadata, metadata.getSchemas().values())) {
            if (!object.getUUID().equals(uuid)) continue;
            return object;
        }
        return null;
    }

    public static Collection<AbstractMetadataRecord> getAllPropertiedObjects(CompositeMetadataStore metadata, Collection<Schema> schemas) {
        LinkedHashSet<AbstractMetadataRecord> records = new LinkedHashSet<AbstractMetadataRecord>();
        records.addAll(metadata.getDatatypes());
        for (Schema schema : schemas) {
            records.add((AbstractMetadataRecord)schema);
            for (Table table : schema.getTables().values()) {
                records.add((AbstractMetadataRecord)table);
                records.addAll(table.getColumns());
                records.addAll(table.getAllKeys());
            }
            for (Procedure proc : schema.getProcedures().values()) {
                records.add((AbstractMetadataRecord)proc);
                records.addAll(proc.getParameters());
                if (proc.getResultSet() == null) continue;
                records.addAll(proc.getResultSet().getColumns());
            }
        }
        return records;
    }

    private List<Schema> getVisibleSchemas(VDBMetaData vdb, CompositeMetadataStore metadata) {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Schema schema : metadata.getSchemas().values()) {
            if (!vdb.isVisible(schema.getName())) continue;
            result.add(schema);
        }
        return result;
    }

    private AtomicRequestMessage createRequest(Object processorId, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidProcessingException, TeiidComponentException {
        RequestWorkItem workItem = this.requestMgr.getRequestWorkItem((RequestID)processorId);
        RequestMessage request = workItem.requestMsg;
        AtomicRequestMessage aqr = new AtomicRequestMessage(request, workItem.getDqpWorkContext(), nodeID);
        aqr.setCommand(command);
        aqr.setModelName(modelName);
        aqr.setMaxResultRows(this.requestMgr.getMaxSourceRows());
        aqr.setExceptionOnMaxRows(this.requestMgr.isExceptionOnMaxSourceRows());
        aqr.setPartialResults(request.supportsPartialResults());
        aqr.setSerial(this.requestMgr.getUserRequestSourceConcurrency() == 1);
        if (nodeID >= 0) {
            aqr.setTransactionContext(workItem.getTransactionContext());
        }
        aqr.setFetchSize(this.bufferService.getBufferManager().getConnectorBatchSize());
        if (connectorBindingId == null) {
            VDBMetaData vdb = workItem.getDqpWorkContext().getVDB();
            ModelMetaData model = vdb.getModel(modelName);
            List bindings = model.getSourceNames();
            if (bindings == null || bindings.size() != 1) {
                throw new TeiidComponentException(QueryPlugin.Util.getString("DataTierManager.could_not_obtain_connector_binding", new Object[]{modelName, workItem.getDqpWorkContext().getVdbName(), workItem.getDqpWorkContext().getVdbVersion()}));
            }
            connectorBindingId = (String)bindings.get(0);
            Assertion.isNotNull((Object)connectorBindingId, (String)"could not obtain connector id");
        }
        aqr.setConnectorName(connectorBindingId);
        return aqr;
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        throw new UnsupportedOperationException();
    }

    BufferManager getBufferManager() {
        return this.bufferService.getBufferManager();
    }

    static {
        levelMap.put("OFF", 0);
        levelMap.put("FATAL", 1);
        levelMap.put("ERROR", 2);
        levelMap.put("WARN", 3);
        levelMap.put("INFO", 4);
        levelMap.put("DEBUG", 5);
        levelMap.put("TRACE", 6);
    }

    private static enum SystemProcs {
        GETXMLSCHEMAS;

    }

    private static enum SystemAdminProcs {
        SETTABLESTATS,
        SETCOLUMNSTATS,
        SETPROPERTY,
        LOGMSG,
        ISLOGGABLE;

    }

    private static enum SystemAdminTables {
        MATVIEWS,
        VDBRESOURCES;

    }

    private static enum SystemTables {
        VIRTUALDATABASES,
        SCHEMAS,
        TABLES,
        DATATYPES,
        COLUMNS,
        KEYS,
        PROCEDURES,
        KEYCOLUMNS,
        PROCEDUREPARAMS,
        REFERENCEKEYCOLUMNS,
        PROPERTIES;

    }
}

