/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.util.CommandContext;

public class MultiSourcePlanToProcessConverter
extends PlanToProcessConverter {
    private Set<String> multiSourceModels;
    private DQPWorkContext workContext;
    private boolean multiSource;
    private boolean update;

    public MultiSourcePlanToProcessConverter(QueryMetadataInterface metadata, IDGenerator idGenerator, AnalysisRecord analysisRecord, CapabilitiesFinder capFinder, Set<String> multiSourceModels, DQPWorkContext workContext, CommandContext context) {
        super(metadata, idGenerator, analysisRecord, capFinder);
        this.multiSourceModels = multiSourceModels;
        this.workContext = workContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RelationalPlan convert(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        RelationalPlan result = null;
        try {
            RelationalPlan relationalPlan = result = super.convert(planNode);
            return relationalPlan;
        }
        finally {
            if (result != null && this.update && this.multiSource) {
                result.setMultisourceUpdate(true);
            }
            this.update = false;
            this.multiSource = false;
        }
    }

    @Override
    protected RelationalNode convertNode(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        RelationalNode node = super.convertNode(planNode);
        if (node instanceof AccessNode) {
            try {
                return this.multiSourceModify((AccessNode)node);
            }
            catch (TeiidProcessingException e) {
                throw new QueryPlannerException(e, e.getMessage());
            }
        }
        if (node instanceof ProjectIntoNode) {
            throw new AssertionError((Object)"Multisource insert with query expression not allowed not allowed, should have been caught in validation.");
        }
        return node;
    }

    private RelationalNode multiSourceModify(AccessNode accessNode) throws TeiidComponentException, TeiidProcessingException {
        String modelName = accessNode.getModelName();
        if (!this.multiSourceModels.contains(modelName)) {
            return accessNode;
        }
        VDBMetaData vdb = this.workContext.getVDB();
        ModelMetaData model = vdb.getModel(modelName);
        ArrayList<AccessNode> accessNodes = new ArrayList<AccessNode>();
        boolean hasOutParams = false;
        if (accessNode.getCommand() instanceof StoredProcedure) {
            StoredProcedure sp = (StoredProcedure)accessNode.getCommand();
            hasOutParams = sp.returnParameters() && sp.getProjectedSymbols().size() > sp.getResultSetColumns().size();
        }
        for (String sourceName : model.getSourceNames()) {
            AccessNode instanceNode = (AccessNode)accessNode.clone();
            instanceNode.setID(this.getID());
            instanceNode.setConnectorBindingId(sourceName);
            Command command = (Command)instanceNode.getCommand().clone();
            command = this.rewriteCommand(sourceName, command);
            if (command == null) continue;
            try {
                command = QueryRewriter.rewrite(command, this.metadata, null);
                instanceNode.setCommand(command);
            }
            catch (QueryValidatorException e) {
                // empty catch block
            }
            if (!RelationalNodeUtil.shouldExecute(command, false)) continue;
            accessNodes.add(instanceNode);
        }
        if (hasOutParams && accessNodes.size() != 1) {
            throw new QueryPlannerException(QueryPlugin.Util.getString("MultiSource.out_procedure", new Object[]{accessNode.getCommand()}));
        }
        switch (accessNodes.size()) {
            case 0: {
                if (RelationalNodeUtil.isUpdate(accessNode.getCommand())) {
                    ProjectNode pnode = new ProjectNode(this.getID());
                    pnode.setElements(accessNode.getElements());
                    pnode.setSelectSymbols(Arrays.asList(new ExpressionSymbol("x", new Constant(0))));
                    return pnode;
                }
                NullNode nullNode = new NullNode(this.getID());
                nullNode.setElements(accessNode.getElements());
                return nullNode;
            }
            case 1: {
                AccessNode newNode = (AccessNode)accessNodes.get(0);
                return newNode;
            }
        }
        this.multiSource = true;
        UnionAllNode unionNode = new UnionAllNode(this.getID());
        unionNode.setElements(accessNode.getElements());
        for (AccessNode newNode : accessNodes) {
            unionNode.addChild(newNode);
        }
        RelationalNode parent = unionNode;
        if (RelationalNodeUtil.isUpdate(accessNode.getCommand())) {
            this.update = true;
            GroupingNode groupNode = new GroupingNode(this.getID());
            AggregateSymbol sumCount = new AggregateSymbol("SumCount", "SUM", false, accessNode.getElements().get(0));
            ArrayList<ExpressionSymbol> outputElements = new ArrayList<ExpressionSymbol>(1);
            outputElements.add(sumCount);
            groupNode.setElements(outputElements);
            groupNode.addChild(unionNode);
            ProjectNode projectNode = new ProjectNode(this.getID());
            Function intSum = ResolverUtil.getConversion(sumCount, DataTypeManager.getDataTypeName(sumCount.getType()), "integer", false, this.metadata.getFunctionLibrary());
            ExpressionSymbol rowCount = new ExpressionSymbol("RowCount", intSum);
            outputElements = new ArrayList(1);
            outputElements.add(rowCount);
            projectNode.setElements(outputElements);
            projectNode.setSelectSymbols(outputElements);
            projectNode.addChild(groupNode);
            parent = projectNode;
        }
        return parent;
    }

    private Command rewriteCommand(String sourceName, Command command) throws ExpressionEvaluationException, TeiidComponentException {
        Constant source;
        ProcedureContainer obj;
        if (command instanceof StoredProcedure) {
            obj = (StoredProcedure)command;
            Iterator<SPParameter> params = ((StoredProcedure)obj).getMapOfParameters().values().iterator();
            while (params.hasNext()) {
                String shortName;
                SPParameter param = params.next();
                if (param.getParameterType() != 1 || !(shortName = SingleElementSymbol.getShortName(param.getName())).equalsIgnoreCase("SOURCE_NAME")) continue;
                source = (Constant)param.getExpression();
                params.remove();
                if (param.isUsingDefault() && source.isNull() || source.getValue().equals(sourceName)) continue;
                return null;
            }
        }
        if (command instanceof Insert) {
            obj = (Insert)command;
            for (int i = 0; i < ((Insert)obj).getVariables().size(); ++i) {
                ElementSymbol elem = ((Insert)obj).getVariables().get(i);
                Object metadataID = elem.getMetadataID();
                if (!(metadataID instanceof MultiSourceElement)) continue;
                source = (Constant)((Insert)obj).getValues().get(i);
                ((Insert)obj).getVariables().remove(i);
                ((Insert)obj).getValues().remove(i);
                if (source.getValue().equals(sourceName)) continue;
                return null;
            }
        } else {
            DeepPreOrderNavigator.doVisit(command, new MultiSourceElementReplacementVisitor(sourceName));
        }
        if (!RelationalNodeUtil.shouldExecute(command, false)) {
            return null;
        }
        return command;
    }
}

