/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.virtual.VirtualFile;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.metadata.BasicQueryMetadata;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.sql.lang.SPParameter;

public class TransformationMetadata
extends BasicQueryMetadata
implements Serializable {
    private static final long serialVersionUID = 1058627332954475287L;
    public static final char DELIMITER_CHAR = '.';
    public static final String DELIMITER_STRING = String.valueOf('.');
    public static String NOT_EXISTS_MESSAGE = StringUtil.Constants.SPACE + QueryPlugin.Util.getString("TransformationMetadata.does_not_exist._1");
    private static Properties EMPTY_PROPS = new Properties();
    private final CompositeMetadataStore store;
    private Map<String, Resource> vdbEntries;
    private FunctionLibrary functionLibrary;
    private VDBMetaData vdbMetaData;
    private Map<String, Object> metadataCache = Collections.synchronizedMap(new LRUCache(250));
    private Map<String, Object> groupInfoCache = Collections.synchronizedMap(new LRUCache(250));
    private Map<String, Collection<Table>> partialNameToFullNameCache = Collections.synchronizedMap(new LRUCache(1000));
    private Map<String, Collection<StoredProcedureInfo>> procedureCache = Collections.synchronizedMap(new LRUCache(200));

    public TransformationMetadata(VDBMetaData vdbMetadata, CompositeMetadataStore store, Map<String, Resource> vdbEntries, FunctionTree systemFunctions, Collection<FunctionTree> functionTrees) {
        ArgCheck.isNotNull((Object)((Object)store));
        this.vdbMetaData = vdbMetadata;
        this.store = store;
        this.vdbEntries = vdbEntries == null ? Collections.emptyMap() : vdbEntries;
        this.functionLibrary = functionTrees == null ? new FunctionLibrary(systemFunctions, new FunctionTree[0]) : new FunctionLibrary(systemFunctions, functionTrees.toArray(new FunctionTree[functionTrees.size()]));
    }

    private TransformationMetadata(CompositeMetadataStore store, FunctionLibrary functionLibrary) {
        ArgCheck.isNotNull((Object)((Object)store));
        this.store = store;
        this.vdbEntries = Collections.emptyMap();
        this.functionLibrary = functionLibrary;
    }

    public Column getElementID(String elementName) throws TeiidComponentException, QueryMetadataException {
        int columnIndex = elementName.lastIndexOf(DELIMITER_STRING);
        if (columnIndex == -1) {
            throw new QueryMetadataException(elementName + NOT_EXISTS_MESSAGE);
        }
        Table table = this.store.findGroup(elementName.substring(0, columnIndex).toUpperCase());
        String shortElementName = elementName.substring(columnIndex + 1);
        for (Column column : this.getElementIDsInGroupID(table)) {
            if (!column.getName().equalsIgnoreCase(shortElementName)) continue;
            return column;
        }
        throw new QueryMetadataException(elementName + NOT_EXISTS_MESSAGE);
    }

    public Table getGroupID(String groupName) throws TeiidComponentException, QueryMetadataException {
        return this.getMetadataStore().findGroup(groupName.toUpperCase());
    }

    @Override
    public Collection<String> getGroupsForPartialName(String partialGroupName) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)partialGroupName);
        Collection<Table> matches = this.partialNameToFullNameCache.get(partialGroupName);
        if (matches == null) {
            matches = this.getMetadataStore().getGroupsForPartialName(partialGroupName);
            this.partialNameToFullNameCache.put(partialGroupName, matches);
        }
        if (matches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> filteredResult = new ArrayList<String>(matches.size());
        for (Table table : matches) {
            if (this.vdbMetaData != null && !this.vdbMetaData.isVisible(((Schema)table.getParent()).getName())) continue;
            filteredResult.add(table.getFullName());
        }
        return filteredResult;
    }

    @Override
    public Object getModelID(Object groupOrElementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)groupOrElementID);
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)groupOrElementID;
        AbstractMetadataRecord parent = metadataRecord.getParent();
        if (parent instanceof Schema) {
            return parent;
        }
        if (parent == null) {
            throw this.createInvalidRecordTypeException(groupOrElementID);
        }
        if ((parent = parent.getParent()) instanceof Schema) {
            return parent;
        }
        throw this.createInvalidRecordTypeException(groupOrElementID);
    }

    @Override
    public String getFullName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)metadataID);
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)metadataID;
        return metadataRecord.getFullName();
    }

    @Override
    public String getName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)metadataID);
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)metadataID;
        return metadataRecord.getName();
    }

    @Override
    public List<Column> getElementIDsInGroupID(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        return ((Table)groupID).getColumns();
    }

    @Override
    public Object getGroupIDForElementID(Object elementID) throws TeiidComponentException, QueryMetadataException {
        Column columnRecord;
        AbstractMetadataRecord parent;
        if (elementID instanceof Column && (parent = (columnRecord = (Column)elementID).getParent()) instanceof Table) {
            return parent;
        }
        if (elementID instanceof ProcedureParameter) {
            columnRecord = (ProcedureParameter)elementID;
            return columnRecord.getParent();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public boolean hasProcedure(String name) throws TeiidComponentException {
        try {
            return this.getStoredProcInfoDirect(name) != null;
        }
        catch (QueryMetadataException e) {
            return true;
        }
    }

    @Override
    public StoredProcedureInfo getStoredProcedureInfoForProcedure(String name) throws TeiidComponentException, QueryMetadataException {
        StoredProcedureInfo result = this.getStoredProcInfoDirect(name);
        if (result == null) {
            throw new QueryMetadataException(name + NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    private StoredProcedureInfo getStoredProcInfoDirect(String name) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isNotEmpty((String)name);
        String canonicalName = name.toUpperCase();
        Collection<StoredProcedureInfo> results = this.procedureCache.get(canonicalName);
        if (results == null) {
            Collection<Procedure> procRecords = this.getMetadataStore().getStoredProcedure(canonicalName);
            if (procRecords.isEmpty()) {
                return null;
            }
            results = new ArrayList<StoredProcedureInfo>(procRecords.size());
            for (Procedure procRecord : procRecords) {
                String procedureFullName = procRecord.getFullName();
                StoredProcedureInfo procInfo = new StoredProcedureInfo();
                procInfo.setProcedureCallableName(procedureFullName);
                procInfo.setProcedureID(procRecord);
                procInfo.setModelID(procRecord.getParent());
                for (ProcedureParameter paramRecord : procRecord.getParameters()) {
                    String runtimeType = paramRecord.getRuntimeType();
                    int direction = this.convertParamRecordTypeToStoredProcedureType(paramRecord.getType());
                    SPParameter spParam = new SPParameter(paramRecord.getPosition(), direction, paramRecord.getFullName());
                    spParam.setMetadataID(paramRecord);
                    spParam.setClassType(DataTypeManager.getDataTypeClass((String)runtimeType));
                    procInfo.addParameter(spParam);
                }
                if (procRecord.getResultSet() != null) {
                    ColumnSet resultRecord = procRecord.getResultSet();
                    int lastParamIndex = procInfo.getParameters().size() + 1;
                    SPParameter param = new SPParameter(lastParamIndex, 5, resultRecord.getFullName());
                    param.setClassType(ResultSet.class);
                    param.setMetadataID(resultRecord);
                    for (Column columnRecord : resultRecord.getColumns()) {
                        String colType = columnRecord.getRuntimeType();
                        param.addResultSetColumn(columnRecord.getFullName(), DataTypeManager.getDataTypeClass((String)colType), columnRecord);
                    }
                    procInfo.addParameter(param);
                }
                if (procRecord.isVirtual()) {
                    LiveQueryNode queryNode = new LiveQueryNode(procRecord);
                    procInfo.setQueryPlan(queryNode);
                }
                procInfo.setUpdateCount(procRecord.getUpdateCount() - 1);
                results.add(procInfo);
            }
            this.procedureCache.put(canonicalName, results);
        }
        StoredProcedureInfo result = null;
        for (StoredProcedureInfo storedProcedureInfo : results) {
            Schema schema = (Schema)storedProcedureInfo.getModelID();
            if (!name.equalsIgnoreCase(storedProcedureInfo.getProcedureCallableName()) && this.vdbMetaData != null && !this.vdbMetaData.isVisible(schema.getName())) continue;
            if (result != null) {
                throw new QueryMetadataException(QueryPlugin.Util.getString("ambiguous_procedure", new Object[]{name}));
            }
            result = storedProcedureInfo;
        }
        return result;
    }

    private int convertParamRecordTypeToStoredProcedureType(ProcedureParameter.Type parameterType) {
        switch (parameterType) {
            case In: {
                return 1;
            }
            case Out: {
                return 2;
            }
            case InOut: {
                return 3;
            }
            case ReturnValue: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public String getElementType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getRuntimeType();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getRuntimeType();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object getDefaultValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getDefaultValue();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getDefaultValue();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object getMinimumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getMinimumValue();
        }
        if (elementID instanceof ProcedureParameter) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object getMaximumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getMaximumValue();
        }
        if (elementID instanceof ProcedureParameter) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public boolean isVirtualGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        return ((Table)groupID).isVirtual();
    }

    @Override
    public boolean isProcedure(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof Procedure) {
            return true;
        }
        if (groupID instanceof Table) {
            return false;
        }
        throw this.createInvalidRecordTypeException(groupID);
    }

    @Override
    public boolean isVirtualModel(Object modelID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Schema.class, (Object)modelID);
        Schema modelRecord = (Schema)modelID;
        return !modelRecord.isPhysical();
    }

    @Override
    public QueryNode getVirtualPlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        if (!tableRecord.isVirtual()) {
            throw new QueryMetadataException(QueryPlugin.Util.getString("TransformationMetadata.QueryPlan_could_not_be_found_for_physical_group__6") + tableRecord.getFullName());
        }
        LiveTableQueryNode queryNode = new LiveTableQueryNode(tableRecord);
        List bindings = tableRecord.getBindings();
        if (bindings != null) {
            Iterator bindIter = bindings.iterator();
            while (bindIter.hasNext()) {
                queryNode.addBinding((String)bindIter.next());
            }
        }
        return queryNode;
    }

    @Override
    public String getInsertPlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecordImpl = (Table)groupID;
        if (!tableRecordImpl.isVirtual()) {
            throw new QueryMetadataException(QueryPlugin.Util.getString("TransformationMetadata.InsertPlan_could_not_be_found_for_physical_group__8") + tableRecordImpl.getFullName());
        }
        return tableRecordImpl.isInsertPlanEnabled() ? tableRecordImpl.getInsertPlan() : null;
    }

    @Override
    public String getUpdatePlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecordImpl = (Table)groupID;
        if (!tableRecordImpl.isVirtual()) {
            throw new QueryMetadataException(QueryPlugin.Util.getString("TransformationMetadata.InsertPlan_could_not_be_found_for_physical_group__10") + tableRecordImpl.getFullName());
        }
        return tableRecordImpl.isUpdatePlanEnabled() ? tableRecordImpl.getUpdatePlan() : null;
    }

    @Override
    public String getDeletePlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecordImpl = (Table)groupID;
        if (!tableRecordImpl.isVirtual()) {
            throw new QueryMetadataException(QueryPlugin.Util.getString("TransformationMetadata.DeletePlan_could_not_be_found_for_physical_group__12") + tableRecordImpl.getFullName());
        }
        return tableRecordImpl.isDeletePlanEnabled() ? tableRecordImpl.getDeletePlan() : null;
    }

    @Override
    public boolean modelSupports(Object modelID, int modelConstant) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Schema.class, (Object)modelID);
        switch (modelConstant) {
            default: 
        }
        throw new UnsupportedOperationException(QueryPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + modelConstant);
    }

    @Override
    public boolean groupSupports(Object groupID, int groupConstant) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        switch (groupConstant) {
            case 0: {
                return tableRecord.supportsUpdate();
            }
        }
        throw new UnsupportedOperationException(QueryPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + groupConstant);
    }

    @Override
    public boolean elementSupports(Object elementID, int elementConstant) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            Column columnRecord = (Column)elementID;
            switch (elementConstant) {
                case 4: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Nullable;
                }
                case 10: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Unknown;
                }
                case 2: {
                    return columnRecord.getSearchType() == Column.SearchType.Searchable || columnRecord.getSearchType() == Column.SearchType.All_Except_Like;
                }
                case 1: {
                    return columnRecord.getSearchType() == Column.SearchType.Searchable || columnRecord.getSearchType() == Column.SearchType.Like_Only;
                }
                case 0: {
                    return columnRecord.isSelectable();
                }
                case 5: {
                    return columnRecord.isUpdatable();
                }
                case 7: {
                    String defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return columnRecord.isAutoIncremented();
                }
                case 9: {
                    return columnRecord.isCaseSensitive();
                }
                case 11: {
                    return columnRecord.isSigned();
                }
            }
            throw new UnsupportedOperationException(QueryPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + elementConstant);
        }
        if (elementID instanceof ProcedureParameter) {
            ProcedureParameter columnRecord = (ProcedureParameter)elementID;
            switch (elementConstant) {
                case 4: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Nullable;
                }
                case 10: {
                    return columnRecord.getNullType() == BaseColumn.NullType.Unknown;
                }
                case 1: 
                case 2: {
                    return false;
                }
                case 0: {
                    return columnRecord.getType() != ProcedureParameter.Type.In;
                }
                case 5: {
                    return false;
                }
                case 7: {
                    String defaultValue = columnRecord.getDefaultValue();
                    return defaultValue != null;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 11: {
                    return true;
                }
            }
            throw new UnsupportedOperationException(QueryPlugin.Util.getString("TransformationMetadata.Unknown_support_constant___12") + elementConstant);
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    private IllegalArgumentException createInvalidRecordTypeException(Object elementID) {
        return new IllegalArgumentException(QueryPlugin.Util.getString("TransformationMetadata.Invalid_type", new Object[]{elementID.getClass().getName()}));
    }

    @Override
    public int getMaxSetSize(Object modelID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Schema.class, (Object)modelID);
        return 0;
    }

    @Override
    public Collection getIndexesInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        return ((Table)groupID).getIndexes();
    }

    @Override
    public Collection getUniqueKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecordImpl = (Table)groupID;
        ArrayList<KeyRecord> result = new ArrayList<KeyRecord>(tableRecordImpl.getUniqueKeys());
        if (tableRecordImpl.getPrimaryKey() != null) {
            result.add(tableRecordImpl.getPrimaryKey());
        }
        for (KeyRecord key : tableRecordImpl.getIndexes()) {
            if (key.getType() != KeyRecord.Type.Unique) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public Collection getForeignKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        return ((Table)groupID).getForeignKeys();
    }

    @Override
    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ForeignKey.class, (Object)foreignKeyID);
        ForeignKey fkRecord = (ForeignKey)foreignKeyID;
        return fkRecord.getPrimaryKey();
    }

    @Override
    public Collection getAccessPatternsInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        return ((Table)groupID).getAccessPatterns();
    }

    @Override
    public List getElementIDsInIndex(Object index) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ColumnSet.class, (Object)index);
        return ((ColumnSet)index).getColumns();
    }

    @Override
    public List getElementIDsInKey(Object key) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ColumnSet.class, (Object)key);
        return ((ColumnSet)key).getColumns();
    }

    @Override
    public List getElementIDsInAccessPattern(Object accessPattern) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(ColumnSet.class, (Object)accessPattern);
        return ((ColumnSet)accessPattern).getColumns();
    }

    @Override
    public boolean isXMLGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        return tableRecord.getTableType() == Table.Type.Document;
    }

    @Override
    public boolean hasMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        return tableRecord.isMaterialized();
    }

    @Override
    public Object getMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        if (tableRecord.isMaterialized()) {
            return tableRecord.getMaterializedTable();
        }
        return null;
    }

    @Override
    public Object getMaterializationStage(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        if (tableRecord.isMaterialized()) {
            return tableRecord.getMaterializedStageTable();
        }
        return null;
    }

    @Override
    public MappingNode getMappingNode(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        MappingDocument mappingDoc = (MappingDocument)tableRecord.getAttachment(MappingDocument.class);
        if (mappingDoc != null) {
            return mappingDoc;
        }
        String groupName = tableRecord.getFullName();
        if (tableRecord.isVirtual()) {
            String document = tableRecord.getSelectTransformation();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(document.getBytes());
            MappingLoader reader = new MappingLoader();
            try {
                mappingDoc = reader.loadDocument(inputStream);
                mappingDoc.setName(groupName);
            }
            catch (Exception e) {
                throw new TeiidComponentException((Throwable)e, QueryPlugin.Util.getString("TransformationMetadata.Error_trying_to_read_virtual_document_{0},_with_body__n{1}_1", new Object[]{groupName, mappingDoc}));
            }
            finally {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e) {}
            }
            tableRecord.addAttchment(MappingDocument.class, (Object)mappingDoc);
            return mappingDoc;
        }
        return null;
    }

    @Override
    public String getVirtualDatabaseName() throws TeiidComponentException, QueryMetadataException {
        if (this.vdbMetaData == null) {
            return null;
        }
        return this.vdbMetaData.getName();
    }

    public int getVirtualDatabaseVersion() {
        if (this.vdbMetaData == null) {
            return 0;
        }
        return this.vdbMetaData.getVersion();
    }

    public VDBMetaData getVdbMetaData() {
        return this.vdbMetaData;
    }

    @Override
    public Collection<Table> getXMLTempGroups(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        if (tableRecord.getTableType() == Table.Type.Document) {
            return this.store.getXMLTempGroups(tableRecord);
        }
        return Collections.emptySet();
    }

    @Override
    public int getCardinality(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        return ((Table)groupID).getCardinality();
    }

    @Override
    public List<SQLXMLImpl> getXMLSchemas(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(Table.class, (Object)groupID);
        Table tableRecord = (Table)groupID;
        String groupName = tableRecord.getFullName();
        List schemaPaths = tableRecord.getSchemaPaths();
        LinkedList<SQLXMLImpl> schemas = new LinkedList<SQLXMLImpl>();
        if (schemaPaths == null) {
            return schemas;
        }
        File f = new File(tableRecord.getResourcePath());
        String path = f.getParent();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        for (String string : schemaPaths) {
            String parentPath = path;
            boolean relative = false;
            while (string.startsWith("../")) {
                relative = true;
                string = string.substring(3);
                parentPath = new File(parentPath).getParent();
            }
            SQLXMLImpl schema = null;
            if (!relative) {
                schema = this.getVDBResourceAsSQLXML(string);
            }
            if (schema == null) {
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                schema = this.getVDBResourceAsSQLXML(parentPath + string);
            }
            if (schema == null) {
                throw new QueryMetadataException(QueryPlugin.Util.getString("TransformationMetadata.Error_trying_to_read_schemas_for_the_document/table____1") + groupName);
            }
            schemas.add(schema);
        }
        return schemas;
    }

    @Override
    public String getNameInSource(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)metadataID);
        return ((AbstractMetadataRecord)metadataID).getNameInSource();
    }

    @Override
    public int getElementLength(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getLength();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getLength();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getPosition(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getPosition();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getPosition();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getPrecision(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getPrecision();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getPrecision();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getRadix(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getRadix();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getRadix();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public String getFormat(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getFormat();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getScale(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getScale();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getScale();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getDistinctValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getDistinctValues();
        }
        if (elementID instanceof ProcedureParameter) {
            return -1;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public int getNullValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getNullValues();
        }
        if (elementID instanceof ProcedureParameter) {
            return -1;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public String getNativeType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof Column) {
            return ((Column)elementID).getNativeType();
        }
        if (elementID instanceof ProcedureParameter) {
            return null;
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Properties getExtensionProperties(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)metadataID);
        AbstractMetadataRecord metadataRecord = (AbstractMetadataRecord)metadataID;
        Map result = metadataRecord.getProperties();
        if (result == null) {
            return EMPTY_PROPS;
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)result);
        return p;
    }

    @Override
    public byte[] getBinaryVDBResource(String resourcePath) throws TeiidComponentException, QueryMetadataException {
        VirtualFile f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        try {
            return ObjectConverterUtil.convertToByteArray((InputStream)f.openStream());
        }
        catch (IOException e) {
            throw new TeiidComponentException((Throwable)e);
        }
    }

    public ClobImpl getVDBResourceAsClob(String resourcePath) {
        VirtualFile f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        return new ClobImpl((InputStreamFactory)new VirtualFileInputStreamFactory(f), -1L);
    }

    public SQLXMLImpl getVDBResourceAsSQLXML(String resourcePath) {
        VirtualFile f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        return new SQLXMLImpl((InputStreamFactory)new VirtualFileInputStreamFactory(f));
    }

    public BlobImpl getVDBResourceAsBlob(String resourcePath) {
        VirtualFile f = this.getFile(resourcePath);
        if (f == null) {
            return null;
        }
        return new BlobImpl((InputStreamFactory)new VirtualFileInputStreamFactory(f));
    }

    private VirtualFile getFile(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        Resource r = this.vdbEntries.get(resourcePath);
        if (r != null) {
            return r.file;
        }
        return null;
    }

    @Override
    public String getCharacterVDBResource(String resourcePath) throws TeiidComponentException, QueryMetadataException {
        try {
            byte[] bytes = this.getBinaryVDBResource(resourcePath);
            if (bytes == null) {
                return null;
            }
            return ObjectConverterUtil.convertToString((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            throw new TeiidComponentException((Throwable)e);
        }
    }

    public CompositeMetadataStore getMetadataStore() {
        return this.store;
    }

    @Override
    public String[] getVDBResourcePaths() throws TeiidComponentException, QueryMetadataException {
        LinkedList<String> paths = new LinkedList<String>();
        for (Map.Entry<String, Resource> entry : this.vdbEntries.entrySet()) {
            paths.add(entry.getKey());
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public String getModeledType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        Datatype record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getDatatypeID();
        }
        return null;
    }

    @Override
    public String getModeledBaseType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        Datatype record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getBasetypeID();
        }
        return null;
    }

    @Override
    public String getModeledPrimitiveType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        Datatype record = this.getDatatypeRecord(elementID);
        if (record != null) {
            return record.getPrimitiveTypeID();
        }
        return null;
    }

    private Datatype getDatatypeRecord(Object elementID) {
        if (elementID instanceof Column) {
            return ((Column)elementID).getDatatype();
        }
        if (elementID instanceof ProcedureParameter) {
            return ((ProcedureParameter)elementID).getDatatype();
        }
        throw this.createInvalidRecordTypeException(elementID);
    }

    @Override
    public Object addToMetadataCache(Object metadataID, String key, Object value) {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)metadataID);
        boolean groupInfo = key.startsWith("groupinfo/");
        key = this.getCacheKey(key, (AbstractMetadataRecord)metadataID);
        if (groupInfo) {
            return this.groupInfoCache.put(key, value);
        }
        return this.metadataCache.put(key, value);
    }

    @Override
    public Object getFromMetadataCache(Object metadataID, String key) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(AbstractMetadataRecord.class, (Object)metadataID);
        boolean groupInfo = key.startsWith("groupinfo/");
        key = this.getCacheKey(key, (AbstractMetadataRecord)metadataID);
        if (groupInfo) {
            return this.groupInfoCache.get(key);
        }
        return this.metadataCache.get(key);
    }

    private String getCacheKey(String key, AbstractMetadataRecord record) {
        return record.getUUID() + "/" + key;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public Object getPrimaryKey(Object metadataID) {
        ArgCheck.isInstanceOf(Table.class, (Object)metadataID);
        Table table = (Table)metadataID;
        return table.getPrimaryKey();
    }

    @Override
    public QueryMetadataInterface getDesignTimeMetadata() {
        TransformationMetadata tm = new TransformationMetadata(this.store, this.functionLibrary);
        tm.groupInfoCache = this.groupInfoCache;
        tm.metadataCache = this.metadataCache;
        tm.partialNameToFullNameCache = this.partialNameToFullNameCache;
        tm.procedureCache = this.procedureCache;
        return tm;
    }

    public static class Resource {
        VirtualFile file;
        boolean visible;

        public Resource(VirtualFile file, boolean visible) {
            this.file = file;
            this.visible = visible;
        }
    }

    private final class VirtualFileInputStreamFactory
    extends InputStreamFactory {
        private final VirtualFile f;

        private VirtualFileInputStreamFactory(VirtualFile f) {
            this.f = f;
        }

        public InputStream getInputStream() throws IOException {
            return this.f.openStream();
        }

        public long getLength() {
            try {
                return this.f.getSize();
            }
            catch (IOException iOException) {
                return super.getLength();
            }
        }

        public InputStreamFactory.StorageMode getStorageMode() {
            return InputStreamFactory.StorageMode.PERSISTENT;
        }
    }

    private static final class LiveTableQueryNode
    extends QueryNode {
        Table t;

        private LiveTableQueryNode(Table t) {
            super(null);
            this.t = t;
        }

        @Override
        public String getQuery() {
            return this.t.getSelectTransformation();
        }
    }

    private static final class LiveQueryNode
    extends QueryNode {
        Procedure p;

        private LiveQueryNode(Procedure p) {
            super(null);
            this.p = p;
        }

        @Override
        public String getQuery() {
            return this.p.getQueryPlan();
        }
    }
}

