/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class ProjectNode
extends SubqueryAwareRelationalNode {
    private List<? extends SingleElementSymbol> selectSymbols;
    private Map elementMap;
    private boolean needsProject = true;
    private List<Expression> expressions;
    private int[] projectionIndexes;
    private TupleBatch currentBatch;
    private int currentRow = 1;

    protected ProjectNode() {
    }

    public ProjectNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.currentRow = 1;
    }

    public List<? extends SingleElementSymbol> getSelectSymbols() {
        return this.selectSymbols;
    }

    public void setSelectSymbols(List<? extends SingleElementSymbol> symbols) {
        this.selectSymbols = symbols;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap != null) {
            return;
        }
        this.projectionIndexes = new int[this.selectSymbols.size()];
        Arrays.fill(this.projectionIndexes, -1);
        this.expressions = new ArrayList<Expression>(this.selectSymbols.size());
        for (SingleElementSymbol ses : this.selectSymbols) {
            this.expressions.add(SymbolMap.getExpression(ses));
        }
        if (this.getChildren()[0] == null) {
            this.elementMap = new HashMap();
            return;
        }
        List<? extends SingleElementSymbol> childElements = this.getChildren()[0].getElements();
        this.elementMap = ProjectNode.createLookupMap(childElements);
        this.needsProject = childElements.size() != this.getElements().size();
        for (int i = 0; i < this.selectSymbols.size(); ++i) {
            Integer index;
            SingleElementSymbol symbol = this.selectSymbols.get(i);
            if (symbol instanceof AliasSymbol) {
                index = (Integer)this.elementMap.get(symbol);
                if (index != null && index == i) {
                    this.projectionIndexes[i] = index;
                    continue;
                }
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if ((index = (Integer)this.elementMap.get(symbol)) == null || index != i) {
                this.needsProject = true;
                continue;
            }
            this.projectionIndexes[i] = index;
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.currentBatch == null) {
            if (this.getChildren()[0] == null) {
                this.currentBatch = new TupleBatch(1, new List[]{Arrays.asList(new Object[0])});
                this.currentBatch.setTerminationFlag(true);
            } else {
                this.currentBatch = this.getChildren()[0].nextBatch();
            }
            if (!this.needsProject) {
                TupleBatch result = this.currentBatch;
                this.currentBatch = null;
                return result;
            }
        }
        while (this.currentRow <= this.currentBatch.getEndRow() && !this.isBatchFull()) {
            List tuple = this.currentBatch.getTuple(this.currentRow);
            ArrayList<Object> projectedTuple = new ArrayList<Object>(this.selectSymbols.size());
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression symbol = this.expressions.get(i);
                this.updateTuple(symbol, i, tuple, projectedTuple);
            }
            this.addBatchRow(projectedTuple);
            ++this.currentRow;
        }
        if (this.currentRow > this.currentBatch.getEndRow()) {
            if (this.currentBatch.getTerminationFlag()) {
                this.terminateBatches();
            }
            this.currentBatch = null;
        }
        return this.pullBatch();
    }

    private void updateTuple(Expression symbol, int projectionIndex, List<?> values, List<Object> tuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        int index = this.projectionIndexes[projectionIndex];
        if (index != -1) {
            tuple.add(values.get(index));
        } else {
            tuple.add(this.getEvaluator(this.elementMap).evaluate(symbol, values));
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.selectSymbols);
    }

    @Override
    public Object clone() {
        ProjectNode clonedNode = new ProjectNode();
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(ProjectNode source, ProjectNode target) {
        super.copy(source, target);
        target.selectSymbols = this.selectSymbols;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Select Columns", this.selectSymbols);
        return props;
    }
}

