/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.xml.CriteriaCondition;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.lang.Criteria;

public class RecurseProgramCondition
extends CriteriaCondition {
    private static final int NO_LIMIT = -1;
    private static final boolean NO_EXCEPTION = false;
    private int recursionLimit;
    private boolean exceptionOnRecursionLimit;

    public RecurseProgramCondition(Program subProgramToRecurse, Criteria terminationCriteria) {
        this(subProgramToRecurse, terminationCriteria, -1, false);
    }

    public RecurseProgramCondition(Program subProgramToRecurse, Criteria terminationCriteria, int recursionLimit, boolean exceptionOnRecursionLimit) {
        super(terminationCriteria, subProgramToRecurse);
        this.recursionLimit = recursionLimit;
        this.exceptionOnRecursionLimit = exceptionOnRecursionLimit;
    }

    @Override
    public boolean isProgramRecursive() {
        return true;
    }

    @Override
    public boolean evaluate(XMLProcessorEnvironment env, XMLContext context) throws TeiidComponentException, TeiidProcessingException {
        boolean terminate = false;
        if (this.criteria != null) {
            terminate = super.evaluate(env, context);
        }
        if (!terminate && this.recursionLimit != -1) {
            boolean bl = terminate = env.getProgramRecursionCount(this.getThenProgram()) >= this.recursionLimit;
            if (terminate && this.exceptionOnRecursionLimit) {
                throw new TeiidComponentException("ERR.015.006.0039", QueryPlugin.Util.getString("ERR.015.006.0039"));
            }
        }
        return !terminate;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("RECURSE ");
        s.append("termination Criteria ");
        s.append(this.criteria);
        s.append(", recursion limit ");
        if (this.recursionLimit == -1) {
            s.append("none");
        } else {
            s.append(this.recursionLimit);
        }
        s.append(", exception on limit ");
        s.append(this.exceptionOnRecursionLimit);
        return s.toString();
    }
}

