/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.validator.UpdateValidator;

public abstract class ProcedureContainerResolver
implements CommandResolver {
    public abstract void resolveProceduralCommand(Command var1, TempMetadataAdapter var2) throws QueryMetadataException, QueryResolverException, TeiidComponentException;

    public Command expandCommand(ProcedureContainer procCommand, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol group = procCommand.getGroup();
        Command subCommand = null;
        String plan = this.getPlan(metadata, procCommand);
        if (plan == null) {
            return null;
        }
        QueryParser parser = QueryParser.getQueryParser();
        try {
            subCommand = parser.parseUpdateProcedure(plan);
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0045", QueryPlugin.Util.getString("ERR.015.008.0045", new Object[]{group, procCommand.getClass().getSimpleName()}));
        }
        return subCommand;
    }

    protected abstract String getPlan(QueryMetadataInterface var1, GroupSymbol var2) throws TeiidComponentException, QueryMetadataException, QueryResolverException;

    public static void addChanging(TempMetadataStore discoveredMetadata, GroupContext externalGroups, List<ElementSymbol> elements) {
        ArrayList<ElementSymbol> changingElements = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol changeElement = virtualElmnt.clone();
            changeElement.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            changingElements.add(changeElement);
        }
        ProcedureContainerResolver.addScalarGroup("CHANGING", discoveredMetadata, externalGroups, changingElements, false);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        ProcedureContainer procCommand = (ProcedureContainer)command;
        this.resolveGroup(metadata, procCommand);
        this.resolveProceduralCommand(procCommand, metadata);
        this.getPlan((QueryMetadataInterface)metadata, procCommand);
    }

    private String getPlan(QueryMetadataInterface metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (!procCommand.getGroup().isTempGroupSymbol() && metadata.isVirtualGroup(procCommand.getGroup().getMetadataID())) {
            String plan = this.getPlan(metadata, procCommand.getGroup());
            if (plan == null && !metadata.isProcedure(procCommand.getGroup().getMetadataID())) {
                int type = procCommand.getType();
                ProcedureContainerResolver.getUpdateInfo(procCommand.getGroup(), metadata, type);
            }
            return plan;
        }
        return null;
    }

    public static UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, QueryMetadataInterface metadata, int type) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        UpdateValidator.UpdateInfo info = ProcedureContainerResolver.getUpdateInfo(group, metadata);
        if (info == null) {
            return null;
        }
        if (info.isDeleteValidationError() && type == 4 || info.isUpdateValidationError() && type == 3 || info.isInsertValidationError() && type == 2) {
            String name = "Delete";
            if (type == 3) {
                name = "Update";
            } else if (type == 2) {
                name = "Insert";
            }
            throw new QueryResolverException("ERR.015.008.0009", QueryPlugin.Util.getString("ERR.015.008.0009", new Object[]{group, name}));
        }
        return info;
    }

    public static UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (!QueryResolver.isView(group, metadata)) {
            return null;
        }
        try {
            return QueryResolver.resolveView(group, metadata.getVirtualPlan(group.getMetadataID()), "SELECT", metadata).getUpdateInfo();
        }
        catch (QueryValidatorException e) {
            throw new QueryResolverException((Throwable)((Object)e), e.getMessage());
        }
    }

    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
        GroupSymbol group = procCommand.getGroup();
        ResolverUtil.resolveGroup(group, metadata);
        procCommand.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(group, metadata, procCommand.getType()));
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends SingleElementSymbol> symbols) {
        return ProcedureContainerResolver.addScalarGroup(name, metadata, externalGroups, symbols, true);
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends SingleElementSymbol> symbols, boolean updatable) {
        boolean[] updateArray = new boolean[symbols.size()];
        if (updatable) {
            Arrays.fill(updateArray, true);
        }
        return ProcedureContainerResolver.addScalarGroup(name, metadata, externalGroups, symbols, updateArray);
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends SingleElementSymbol> symbols, boolean[] updatable) {
        GroupSymbol variables = new GroupSymbol(name);
        externalGroups.addGroup(variables);
        TempMetadataID tid = metadata.addTempGroup(name, symbols);
        tid.setMetadataType(TempMetadataID.Type.SCALAR);
        int i = 0;
        for (TempMetadataID cid : tid.getElements()) {
            cid.setMetadataType(TempMetadataID.Type.SCALAR);
            cid.setUpdatable(updatable[i++]);
        }
        variables.setMetadataID(tid);
        return variables;
    }

    public static void findChildCommandMetadata(Command currentCommand, GroupSymbol container, int type, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        TempMetadataStore childMetadata = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, childMetadata);
        GroupContext externalGroups = new GroupContext();
        if (currentCommand instanceof TriggerAction) {
            TriggerAction ta = (TriggerAction)currentCommand;
            ta.setView(container);
            List<ElementSymbol> viewElements = ResolverUtil.resolveElementsInGroup(ta.getView(), metadata);
            if (type == 3 || type == 2) {
                ProcedureContainerResolver.addChanging(tma.getMetadataStore(), externalGroups, viewElements);
                ProcedureContainerResolver.addScalarGroup("NEW", tma.getMetadataStore(), externalGroups, viewElements, false);
            }
            if (type == 3 || type == 4) {
                ProcedureContainerResolver.addScalarGroup("OLD", tma.getMetadataStore(), externalGroups, viewElements, false);
            }
        } else if (currentCommand instanceof CreateUpdateProcedureCommand) {
            CreateUpdateProcedureCommand cupc = (CreateUpdateProcedureCommand)currentCommand;
            cupc.setVirtualGroup(container);
            if (type == 6) {
                StoredProcedureInfo info = metadata.getStoredProcedureInfoForProcedure(container.getCanonicalName());
                String procName = info.getProcedureCallableName();
                ArrayList<ElementSymbol> tempElements = new ArrayList<ElementSymbol>(info.getParameters().size());
                boolean[] updatable = new boolean[info.getParameters().size()];
                int i = 0;
                for (SPParameter param : info.getParameters()) {
                    if (param.getParameterType() == 5) continue;
                    ElementSymbol symbol = param.getParameterSymbol();
                    tempElements.add(symbol);
                    updatable[i++] = param.getParameterType() != 1;
                }
                ProcedureContainerResolver.addScalarGroup(procName, childMetadata, externalGroups, tempElements, updatable);
            } else if (type != 4) {
                ProcedureContainerResolver.createInputChangingMetadata(childMetadata, tma, container, externalGroups);
            }
        }
        QueryResolver.setChildMetadata(currentCommand, childMetadata.getData(), externalGroups);
    }

    static void createInputChangingMetadata(TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata, GroupSymbol group, GroupContext externalGroups) throws QueryMetadataException, TeiidComponentException {
        List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
        ArrayList<ElementSymbol> inputElments = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol inputElement = virtualElmnt.clone();
            inputElments.add(inputElement);
        }
        ProcedureContainerResolver.addScalarGroup("INPUT", discoveredMetadata, externalGroups, inputElments, false);
        ProcedureContainerResolver.addScalarGroup("INPUTS", discoveredMetadata, externalGroups, inputElments, false);
        ProcedureContainerResolver.addChanging(discoveredMetadata, externalGroups, elements);
    }
}

