/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Select
implements LanguageObject {
    private List<SelectSymbol> symbols;
    private boolean distinct;

    public Select() {
        this.symbols = new ArrayList<SelectSymbol>();
    }

    public Select(List<? extends SelectSymbol> symbols) {
        this.symbols = new ArrayList<SelectSymbol>(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public boolean isStar() {
        return this.symbols.size() == 1 && this.symbols.get(0) instanceof MultipleElementSymbol && ((MultipleElementSymbol)this.symbols.get(0)).getGroup() == null;
    }

    public List<SelectSymbol> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<? extends SelectSymbol> symbols) {
        this.symbols = new ArrayList<SelectSymbol>(symbols);
    }

    public SelectSymbol getSymbol(int index) {
        return this.symbols.get(index);
    }

    public void addSymbol(SelectSymbol symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    public void addSymbols(Collection<? extends SelectSymbol> toAdd) {
        if (this.symbols != null) {
            this.symbols.addAll(toAdd);
        }
    }

    public void clearSymbols() {
        this.symbols.clear();
    }

    public boolean containsSymbol(SelectSymbol symbol) {
        return this.symbols.contains(symbol);
    }

    public void setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List<SingleElementSymbol> getProjectedSymbols() {
        ArrayList<SingleElementSymbol> projectedSymbols = new ArrayList<SingleElementSymbol>();
        for (SelectSymbol symbol : this.symbols) {
            if (symbol instanceof SingleElementSymbol) {
                projectedSymbols.add((SingleElementSymbol)symbol);
                continue;
            }
            List<ElementSymbol> multiSymbols = ((MultipleElementSymbol)symbol).getElementSymbols();
            if (multiSymbols == null) continue;
            projectedSymbols.addAll(multiSymbols);
        }
        return projectedSymbols;
    }

    @Override
    public Object clone() {
        Select copy = new Select(LanguageObject.Util.deepClone(this.symbols, SelectSymbol.class));
        copy.setDistinct(this.isDistinct());
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Select)) {
            return false;
        }
        Select other = (Select)obj;
        return other.isDistinct() == this.isDistinct() && EquivalenceUtil.areEqual(this.getSymbols(), other.getSymbols());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getSymbols()});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

