/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;

public final class BlobType
extends Streamable<Blob>
implements Blob {
    private static final long serialVersionUID = 1294191629070433450L;

    public BlobType() {
    }

    public BlobType(Blob blob) {
        super(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return ((Blob)this.reference).getBinaryStream();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return ((Blob)this.reference).getBytes(pos, length);
    }

    @Override
    long computeLength() throws SQLException {
        return ((Blob)this.reference).length();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return ((Blob)this.reference).position(pattern, start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return ((Blob)this.reference).position(pattern, start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return ((Blob)this.reference).setBinaryStream(pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return ((Blob)this.reference).setBytes(pos, bytes, offset, len);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return ((Blob)this.reference).setBytes(pos, bytes);
    }

    @Override
    public void truncate(long len) throws SQLException {
        ((Blob)this.reference).truncate(len);
    }

    @Override
    public void free() throws SQLException {
        ((Blob)this.reference).free();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return ((Blob)this.reference).getBinaryStream(pos, length);
    }

    public static SerialBlob createBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException(e);
        }
    }

    @Override
    protected void readReference(ObjectInput in) throws IOException {
        byte[] bytes = new byte[(int)this.getLength()];
        in.readFully(bytes);
        try {
            this.reference = new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeReference(ObjectOutput out) throws IOException {
        try {
            BlobType.writeBinary(out, this.getBinaryStream(), (int)this.length);
        }
        catch (SQLException e) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBinary(final ObjectOutput out, InputStream is, int length) throws IOException {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        try {
            ObjectConverterUtil.write(os, is, length, false);
        }
        finally {
            is.close();
        }
    }
}

