/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.AnyToStringTransform;

public class SQLXMLToStringTransform
extends AnyToStringTransform {
    public SQLXMLToStringTransform() {
        super(DataTypeManager.DefaultDataClasses.XML);
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        XMLType source = (XMLType)value;
        Reader reader = null;
        try {
            char[] result = new char[4000];
            reader = source.getCharacterStream();
            int read = reader.read(result);
            String string = new String(result, 0, read);
            return string;
        }
        catch (SQLException e) {
            throw new TransformationException(e, CorePlugin.Util.getString("failed_convert", this.getSourceType().getName(), this.getTargetType().getName()));
        }
        catch (IOException e) {
            throw new TransformationException(e, CorePlugin.Util.getString("failed_convert", this.getSourceType().getName(), this.getTargetType().getName()));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

