/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.lang.reflect.Type;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.plugins.types.MutableCompositeMetaType;
import org.jboss.metatype.spi.values.MetaMapper;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;

public class CacheStatisticsMetadataMapper
extends MetaMapper<CacheStatisticsMetadata> {
    private static final String HITRATIO = "hitRatio";
    private static final String TOTAL_ENTRIES = "totalEntries";
    private static final String REQUEST_COUNT = "requestCount";
    private static final MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private static final MutableCompositeMetaType metaType = new MutableCompositeMetaType(CacheStatisticsMetadata.class.getName(), "The Cache statistics");

    public Type mapToType() {
        return CacheStatisticsMetadata.class;
    }

    public MetaType getMetaType() {
        return metaType;
    }

    public MetaValue createMetaValue(MetaType metaType, CacheStatisticsMetadata object) {
        if (object == null) {
            return null;
        }
        if (metaType instanceof CompositeMetaType) {
            CompositeMetaType composite = (CompositeMetaType)metaType;
            CompositeValueSupport cache = new CompositeValueSupport(composite);
            cache.set(TOTAL_ENTRIES, (MetaValue)SimpleValueSupport.wrap((int)object.getTotalEntries()));
            cache.set(HITRATIO, (MetaValue)SimpleValueSupport.wrap((double)object.getHitRatio()));
            cache.set(REQUEST_COUNT, (MetaValue)SimpleValueSupport.wrap((int)object.getRequestCount()));
            return cache;
        }
        throw new IllegalArgumentException("Cannot convert cache statistics " + object);
    }

    public CacheStatisticsMetadata unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (metaValue instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            CacheStatisticsMetadata cache = new CacheStatisticsMetadata();
            cache.setTotalEntries((Integer)metaValueFactory.unwrap(compositeValue.get(TOTAL_ENTRIES)));
            cache.setHitRatio((Double)metaValueFactory.unwrap(compositeValue.get(HITRATIO)));
            cache.setRequestCount((Integer)metaValueFactory.unwrap(compositeValue.get(REQUEST_COUNT)));
            return cache;
        }
        throw new IllegalStateException("Unable to unwrap cache statistics " + metaValue);
    }

    static {
        metaType.addItem(TOTAL_ENTRIES, TOTAL_ENTRIES, (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.addItem(HITRATIO, HITRATIO, (MetaType)SimpleMetaType.DOUBLE_PRIMITIVE);
        metaType.addItem(REQUEST_COUNT, REQUEST_COUNT, (MetaType)SimpleMetaType.INTEGER_PRIMITIVE);
        metaType.freeze();
    }
}

