/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.PermissionMap;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="", propOrder={"description", "permissions", "mappedRoleNames"})
@ManagementObject(properties=ManagementProperties.EXPLICIT)
public class DataPolicyMetadata
implements DataPolicy,
Serializable {
    private static final long serialVersionUID = -4119646357275977190L;
    @XmlAttribute(name="name", required=true)
    protected String name;
    @XmlElement(name="description")
    protected String description;
    @XmlAttribute(name="any-authenticated")
    protected boolean anyAuthenticated;
    @XmlAttribute(name="allow-create-temporary-tables")
    protected Boolean allowCreateTemporaryTables;
    @XmlElement(name="permission")
    protected PermissionMap permissions = new PermissionMap(new KeyBuilder<PermissionMetaData>(){
        private static final long serialVersionUID = -6992984146431492449L;

        @Override
        public String getKey(PermissionMetaData entry) {
            return entry.getResourceName().toLowerCase();
        }
    });
    @XmlElement(name="mapped-role-name")
    protected List<String> mappedRoleNames = new ArrayList<String>();

    @Override
    @ManagementProperty(description="Policy Name")
    @ManagementObjectID(type="policy")
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    @ManagementProperty(description="Policy Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    @ManagementProperty(description="Permissions in a Data Policy", managed=true)
    public List<DataPolicy.DataPermission> getPermissions() {
        return new ArrayList<DataPolicy.DataPermission>(this.permissions.getMap().values());
    }

    public void setPermissions(List<DataPolicy.DataPermission> permissions) {
        this.permissions.getMap().clear();
        for (DataPolicy.DataPermission permission : permissions) {
            this.permissions.add((PermissionMetaData)permission);
        }
    }

    public void addPermission(PermissionMetaData ... permissions) {
        for (PermissionMetaData permission : permissions) {
            this.permissions.add(permission);
        }
    }

    @Override
    @ManagementProperty(description="Mapped Container role names mapped to this policy")
    public List<String> getMappedRoleNames() {
        return this.mappedRoleNames;
    }

    public void setMappedRoleNames(List<String> names) {
        this.mappedRoleNames.clear();
        this.mappedRoleNames.addAll(names);
    }

    public void addMappedRoleName(String name) {
        this.mappedRoleNames.add(name);
    }

    public boolean allows(String resourceName, DataPolicy.PermissionType type) {
        resourceName = resourceName.toLowerCase();
        while (resourceName.length() > 0) {
            Boolean allowed;
            PermissionMetaData p = (PermissionMetaData)this.permissions.getMap().get(resourceName);
            if (p != null && (allowed = p.allows(type)) != null) {
                return allowed;
            }
            resourceName = resourceName.substring(0, Math.max(0, resourceName.lastIndexOf(46)));
        }
        return false;
    }

    @Override
    public Boolean isAllowCreateTemporaryTables() {
        return this.allowCreateTemporaryTables;
    }

    public void setAllowCreateTemporaryTables(Boolean allowCreateTemporaryTables) {
        this.allowCreateTemporaryTables = allowCreateTemporaryTables;
    }

    @Override
    @ManagementProperty(description="Indicates if the role is mapped to any authenticated user.")
    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public void setAnyAuthenticated(boolean anyAuthenticated) {
        this.anyAuthenticated = anyAuthenticated;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="", propOrder={"resourceName", "allowCreate", "allowRead", "allowUpdate", "allowDelete", "allowExecute", "allowAlter"})
    @ManagementObject(properties=ManagementProperties.EXPLICIT)
    public static class PermissionMetaData
    implements DataPolicy.DataPermission,
    Serializable {
        private static final long serialVersionUID = 7034744531663164277L;
        private String resourceName;
        @XmlElement(name="allow-create")
        protected Boolean allowCreate;
        @XmlElement(name="allow-read")
        protected Boolean allowRead;
        @XmlElement(name="allow-update")
        protected Boolean allowUpdate;
        @XmlElement(name="allow-delete")
        protected Boolean allowDelete;
        @XmlElement(name="allow-execute")
        protected Boolean allowExecute;
        @XmlElement(name="allow-alter")
        protected Boolean allowAlter;

        @Override
        @ManagementProperty(description="Resource Name, for which permission defined")
        @XmlElement(name="resource-name", required=true)
        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String value) {
            this.resourceName = value;
        }

        @Override
        @ManagementProperty(description="Allows Create")
        public Boolean getAllowCreate() {
            return this.allowCreate;
        }

        public void setAllowCreate(Boolean value) {
            this.allowCreate = value;
        }

        @Override
        @ManagementProperty(description="Allows Read")
        public Boolean getAllowRead() {
            return this.allowRead;
        }

        public void setAllowRead(Boolean value) {
            this.allowRead = value;
        }

        @Override
        @ManagementProperty(description="Allows Update")
        public Boolean getAllowUpdate() {
            return this.allowUpdate;
        }

        public void setAllowUpdate(Boolean value) {
            this.allowUpdate = value;
        }

        @Override
        @ManagementProperty(description="Allows Delete")
        public Boolean getAllowDelete() {
            return this.allowDelete;
        }

        public void setAllowDelete(Boolean value) {
            this.allowDelete = value;
        }

        public String getType() {
            StringBuilder sb = new StringBuilder();
            if (Boolean.TRUE.equals(this.getAllowCreate())) {
                sb.append("C");
            }
            if (Boolean.TRUE.equals(this.getAllowRead())) {
                sb.append("R");
            }
            if (Boolean.TRUE.equals(this.getAllowUpdate())) {
                sb.append("U");
            }
            if (Boolean.TRUE.equals(this.getAllowDelete())) {
                sb.append("D");
            }
            if (Boolean.TRUE.equals(this.getAllowExecute())) {
                sb.append("E");
            }
            if (Boolean.TRUE.equals(this.getAllowAlter())) {
                sb.append("A");
            }
            return sb.toString();
        }

        public Boolean allows(DataPolicy.PermissionType type) {
            switch (type) {
                case ALTER: {
                    return this.getAllowAlter();
                }
                case CREATE: {
                    return this.getAllowCreate();
                }
                case EXECUTE: {
                    if (this.getAllowExecute() != null) {
                        return this.getAllowExecute();
                    }
                }
                case READ: {
                    return this.getAllowRead();
                }
                case UPDATE: {
                    return this.getAllowUpdate();
                }
                case DELETE: {
                    return this.getAllowDelete();
                }
            }
            throw new AssertionError();
        }

        @Override
        @ManagementProperty(description="Allows Alter")
        public Boolean getAllowAlter() {
            return this.allowAlter;
        }

        @Override
        @ManagementProperty(description="Allows Execute")
        public Boolean getAllowExecute() {
            return this.allowExecute;
        }

        public void setAllowAlter(Boolean allowAlter) {
            this.allowAlter = allowAlter;
        }

        public void setAllowExecute(Boolean allowExecute) {
            this.allowExecute = allowExecute;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getResourceName());
            sb.append("[");
            sb.append(this.getType());
            sb.append("]");
            return sb.toString();
        }
    }
}

