/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.net.socket.AuthenticationType;

public class Handshake
implements Externalizable {
    private static final long serialVersionUID = 7839271224736355515L;
    private String version = ApplicationInfo.getInstance().getReleaseNumber();
    private byte[] publicKey;
    private AuthenticationType authType = AuthenticationType.CLEARTEXT;

    public String getVersion() {
        return this.version;
    }

    public void setVersion() {
        this.version = ApplicationInfo.getInstance().getReleaseNumber();
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] key) {
        this.publicKey = key;
    }

    public AuthenticationType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthenticationType authType) {
        this.authType = authType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.version = (String)in.readObject();
        this.publicKey = (byte[])in.readObject();
        try {
            this.authType = AuthenticationType.values()[in.readByte()];
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.version);
        out.writeObject(this.publicKey);
        out.writeByte(this.authType.ordinal());
    }
}

