/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.connection;

import java.util.Properties;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.connection.DataSourceConnection;
import org.teiid.test.framework.connection.DriverConnection;
import org.teiid.test.framework.connection.JEEConnection;
import org.teiid.test.framework.datasource.DataSourceFactory;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class ConnectionStrategyFactory {
    public static ConnectionStrategy createConnectionStrategy() {
        ConfigPropertyLoader configLoader = ConfigPropertyLoader.getInstance();
        ConnectionStrategy strategy = null;
        Properties props = configLoader.getProperties();
        String type = props.getProperty("connection-type", "driver");
        if (type == null) {
            throw new TransactionRuntimeException("Property connection-type was specified");
        }
        try {
            if (type.equalsIgnoreCase("driver")) {
                strategy = new DriverConnection(props);
                TestLogger.logDebug("Created Driver Strategy");
            } else if (type.equalsIgnoreCase("datasource")) {
                strategy = new DataSourceConnection(props);
                TestLogger.logDebug("Created DataSource Strategy");
            } else if (type.equalsIgnoreCase("jndi")) {
                strategy = new JEEConnection(props);
                TestLogger.logDebug("Created JEE Strategy");
            }
            if (strategy == null) {
                new TransactionRuntimeException("Invalid property value for connection-type is " + type);
            }
            strategy.configure();
            return strategy;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ConfigPropertyLoader config = ConfigPropertyLoader.getInstance();
        new DataSourceFactory(config);
    }
}

