/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.gss;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.core.TeiidComponentException;
import org.teiid.gss.GSSCallbackHandler;
import org.teiid.gss.GssAction;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.CommunicationException;

public class MakeGSS {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");

    public static LogonResult authenticate(ILogon logon, Properties props) throws LogonException, TeiidComponentException, CommunicationException {
        String config;
        String kdc;
        String realm;
        String kerberosPrincipalName;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("GSS Authentication Request");
        }
        Object result = null;
        StringBuilder errors = new StringBuilder();
        String jaasApplicationName = props.getProperty("jaasName");
        String nl = System.getProperty("line.separator");
        if (jaasApplicationName == null) {
            errors.append(JDBCPlugin.Util.getString("client_prop_missing", new Object[]{"jaasName"}));
            errors.append(nl);
        }
        if ((kerberosPrincipalName = props.getProperty("kerberosServicePrincipleName")) == null) {
            errors.append(JDBCPlugin.Util.getString("client_prop_missing", new Object[]{"kerberosServicePrincipleName"}));
            errors.append(nl);
        }
        if ((realm = System.getProperty("java.security.krb5.realm")) == null) {
            errors.append(JDBCPlugin.Util.getString("system_prop_missing", new Object[]{"java.security.krb5.realm"}));
            errors.append(nl);
        }
        if ((kdc = System.getProperty("java.security.krb5.kdc")) == null) {
            errors.append(JDBCPlugin.Util.getString("system_prop_missing", new Object[]{"java.security.krb5.kdc"}));
            errors.append(nl);
        }
        if ((config = System.getProperty("java.security.auth.login.config")) == null) {
            errors.append(JDBCPlugin.Util.getString("system_prop_missing", new Object[]{"java.security.auth.login.config"}));
            errors.append(nl);
        }
        if (errors.length() > 0) {
            throw new LogonException(errors.toString());
        }
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        try {
            LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
            lc.login();
            Subject sub = lc.getSubject();
            GssAction action = new GssAction(logon, kerberosPrincipalName, props);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new LogonException(e, JDBCPlugin.Util.getString("gss_auth_failed"));
        }
        if (result instanceof LogonException) {
            throw (LogonException)result;
        }
        if (result instanceof TeiidComponentException) {
            throw (TeiidComponentException)result;
        }
        if (result instanceof CommunicationException) {
            throw (CommunicationException)result;
        }
        if (result instanceof Exception) {
            throw new LogonException(result, JDBCPlugin.Util.getString("gss_auth_failed"));
        }
        return result;
    }
}

