/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.UnitTestUtil;

public class TestPropertiesUtils
extends TestCase {
    private static final String TEMP_FILE = UnitTestUtil.getTestScratchPath() + "/temp.properties";
    private static final boolean UNMODIFIABLE = true;
    private static final boolean DEEP_CLONE = true;
    private static final String PROP_NAME_1 = "prop1";
    private static final String PROP_NAME_2 = "prop2";
    private static final String PROP_NAME_3 = "prop3";
    private static final String PROP_NAME_4 = "prop4";
    private static final String PROP_NAME_5 = "prop5";
    private static final String PROP_NAME_6 = "prop6";
    private static final String PROP_VALUE_1A = "value1a";
    private static final String PROP_VALUE_1B = "value1b";
    private static final String PROP_VALUE_2A = "value2a";
    private static final String PROP_VALUE_2C = "value2c";
    private static final String PROP_VALUE_3A = "value3a";
    private static final String PROP_VALUE_4B = "value4b";
    private static final String PROP_VALUE_4C = "value4c";
    private static final String PROP_VALUE_5B = "value5b";
    private static final String PROP_VALUE_6C = "value6c";
    private static final Map MAP_A;
    private static final Map MAP_B;
    private static final Map MAP_C;
    private static final List LIST_A;
    private static final List LIST_AB;
    private static final List LIST_ABC;

    public TestPropertiesUtils(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        try {
            File temp = new File(TEMP_FILE);
            temp.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPrintLoadWithHeader() throws Exception {
        Properties props1 = TestPropertiesUtils.make(MAP_C, null, false);
        PropertiesUtils.print((String)TEMP_FILE, (Properties)props1, (String)"header");
        Properties props2 = PropertiesUtils.load((String)TEMP_FILE);
        TestPropertiesUtils.assertEquals((String)"Expected props1 to be equal to props2", (int)0, (int)PropertiesUtils.compare((Properties)props1, (Properties)props2));
        String header = PropertiesUtils.loadHeader((String)TEMP_FILE);
        TestPropertiesUtils.assertEquals((String)"header", (String)header);
    }

    public void testPrintLoadWithoutHeader() throws Exception {
        Properties props1 = TestPropertiesUtils.make(MAP_C, null, false);
        PropertiesUtils.print((String)TEMP_FILE, (Properties)props1);
        Properties props2 = PropertiesUtils.load((String)TEMP_FILE);
        TestPropertiesUtils.assertEquals((String)"Expected props1 to be equal to props2", (int)0, (int)PropertiesUtils.compare((Properties)props1, (Properties)props2));
    }

    public void testPutAllWithDefaults() {
        Properties c = TestPropertiesUtils.make(MAP_C, null, false);
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, true), true);
        PropertiesUtils.putAll((Properties)c, (Properties)ab);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(c, LIST_ABC));
    }

    public void testSimpleModifiableClone() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        a = PropertiesUtils.clone((Properties)a);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_A));
    }

    public void testSimpleModifiableCloneWithUnmodifiableDefaults() {
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, true), false);
        ab = PropertiesUtils.clone((Properties)ab);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(ab, LIST_AB));
    }

    public void testSimpleModifiableCloneWithModifiableDefaults() {
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, false), false);
        ab = PropertiesUtils.clone((Properties)ab);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(ab, LIST_AB));
    }

    public void testCloneModifiableAsModifiable() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        a = PropertiesUtils.clone((Properties)a);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_A));
    }

    public void testCloneUnmodifiableAsModifiable() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        a = PropertiesUtils.clone((Properties)a);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_A));
    }

    public void testCloneModifiableWithModifiableAsModifiable() {
        Properties ab = TestPropertiesUtils.make(MAP_A, TestPropertiesUtils.make(MAP_B, null, false), false);
        ab = PropertiesUtils.clone((Properties)ab);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(ab, LIST_AB));
    }

    public void testCloneModAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testDeepcloneModAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testCloneModAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testDeepcloneModAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, false);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testCloneUnmodAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testDeepcloneUnmodAndModAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, false);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testCloneUnmodAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)false);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    public void testDeepcloneUnmodAndUnmodAsMod() {
        Properties a = TestPropertiesUtils.make(MAP_A, null, true);
        Properties b = TestPropertiesUtils.make(MAP_B, null, true);
        a = PropertiesUtils.clone((Properties)a, (Properties)b, (boolean)true);
        TestPropertiesUtils.assertTrue((boolean)TestPropertiesUtils.verifyProps(a, LIST_AB));
    }

    private static final boolean verifyProps(Properties props, List chainOfMappings) {
        boolean result = TestPropertiesUtils.verifyAllPropsPresent(props, chainOfMappings);
        if (result) {
            result = TestPropertiesUtils.verifyCorrectMappings(props, chainOfMappings);
        }
        return result;
    }

    private static final boolean verifyAllPropsPresent(Properties props, List chainOfMappings) {
        Enumeration<?> e = props.propertyNames();
        HashSet propNames = new HashSet();
        while (e.hasMoreElements()) {
            propNames.add(e.nextElement());
        }
        HashSet testNames = new HashSet();
        for (Map aMapping : chainOfMappings) {
            testNames.addAll(aMapping.keySet());
        }
        return propNames.containsAll(testNames);
    }

    private static final boolean verifyCorrectMappings(Properties props, List chainOfMappings) {
        Enumeration<?> e = props.propertyNames();
        boolean allGood = true;
        while (e.hasMoreElements() && allGood) {
            boolean foundKey = false;
            String propName = (String)e.nextElement();
            String propValue = props.getProperty(propName);
            Iterator i = chainOfMappings.iterator();
            while (i.hasNext() && !foundKey) {
                Map aMapping = (Map)i.next();
                Object value = aMapping.get(propName);
                if (value == null) continue;
                foundKey = true;
                allGood = propValue.equals(value);
            }
        }
        return allGood;
    }

    private static final Properties make(Map mappings, Properties defaults, boolean makeUnmodifiable) {
        Properties props = null;
        props = defaults != null ? new Properties(defaults) : new Properties();
        for (Map.Entry anEntry : mappings.entrySet()) {
            props.setProperty((String)anEntry.getKey(), (String)anEntry.getValue());
        }
        return props;
    }

    public void testNestedProperties() throws Exception {
        System.setProperty("testdirectory", "c:/metamatrix/testdirectory");
        Properties p = new Properties(System.getProperties());
        p.setProperty("key1", "value1");
        p.setProperty("key2", "${key1}/value2");
        p.put("key3", new Integer(-234));
        p.setProperty("key4", "${key2}/value4");
        p.setProperty("key5", "${testdirectory}/testdata");
        p.setProperty("key7", "anotherdir/${testdirectory}/${key1}");
        int currentSize = p.size();
        Properties m = PropertiesUtils.resolveNestedProperties((Properties)p);
        TestPropertiesUtils.assertEquals((String)"value1/value2", (String)m.getProperty("key2"));
        TestPropertiesUtils.assertEquals((Object)new Integer(-234), (Object)m.get("key3"));
        TestPropertiesUtils.assertEquals((String)"value1/value2/value4", (String)m.getProperty("key4"));
        TestPropertiesUtils.assertEquals((String)"c:/metamatrix/testdirectory/testdata", (String)m.getProperty("key5"));
        TestPropertiesUtils.assertEquals((String)"anotherdir/c:/metamatrix/testdirectory/value1", (String)m.getProperty("key7"));
        TestPropertiesUtils.assertTrue((p == m ? 1 : 0) != 0);
        TestPropertiesUtils.assertTrue((currentSize == m.size() ? 1 : 0) != 0);
        p.setProperty("key6", "${foo}");
        try {
            m = PropertiesUtils.resolveNestedProperties((Properties)p);
            TestPropertiesUtils.fail((String)"must have failed to resovle as {foo} does not exist");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Properties dups = new Properties();
        dups.setProperty("usethis", "${usethis}");
        dups = PropertiesUtils.resolveNestedProperties((Properties)dups);
    }

    public void testOverrideProperties() {
        Properties p = new Properties();
        p.setProperty("foo", "bar");
        p.setProperty("foo1", "bar1");
        p.setProperty("foo2", "bar2");
        Properties p1 = new Properties(p);
        p1.setProperty("foo", "x");
        PropertiesUtils.setOverrideProperies((Properties)p1, (Properties)p);
        TestPropertiesUtils.assertEquals((String)"bar", (String)p1.getProperty("foo"));
        TestPropertiesUtils.assertEquals((int)1, (int)p1.size());
    }

    public void testGetInvalidInt() {
        Properties p = new Properties();
        p.setProperty("x", "y");
        try {
            PropertiesUtils.getIntProperty((Properties)p, (String)"x", (int)1);
            TestPropertiesUtils.fail((String)"expected exception");
        }
        catch (PropertiesUtils.InvalidPropertyException e) {
            TestPropertiesUtils.assertEquals((String)"Property 'x' with value 'y' is not a valid Integer.", (String)e.getMessage());
        }
    }

    public void testSetBeanProperties() {
        Bean bean = new Bean();
        Properties p = new Properties();
        p.setProperty("prop", "0");
        p.setProperty(PROP_NAME_1, "1");
        p.setProperty(PROP_NAME_2, "2");
        p.setProperty(PROP_NAME_3, "3");
        p = new Properties(p);
        p.put("object", new Object());
        PropertiesUtils.setBeanProperties((Object)bean, (Properties)p, null);
        TestPropertiesUtils.assertEquals((int)0, (int)bean.getProp());
        TestPropertiesUtils.assertEquals((String)"1", (String)bean.getProp1());
        TestPropertiesUtils.assertEquals((Object)2.0, (Object)bean.getProp2());
        TestPropertiesUtils.assertEquals(Arrays.asList("3"), bean.getProp3());
        p.setProperty("prop", "?");
        try {
            PropertiesUtils.setBeanProperties((Object)bean, (Properties)p, null);
            TestPropertiesUtils.fail((String)"expected exception");
        }
        catch (PropertiesUtils.InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
    }

    public void testGetInt() {
        Properties p = new Properties();
        p.setProperty("prop", "0  ");
        TestPropertiesUtils.assertEquals((int)PropertiesUtils.getIntProperty((Properties)p, (String)"prop", (int)-1), (int)0);
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put(PROP_NAME_1, PROP_VALUE_1A);
        temp.put(PROP_NAME_2, PROP_VALUE_2A);
        temp.put(PROP_NAME_3, PROP_VALUE_3A);
        MAP_A = Collections.unmodifiableMap(temp);
        temp = new HashMap();
        temp.put(PROP_NAME_1, PROP_VALUE_1B);
        temp.put(PROP_NAME_4, PROP_VALUE_4B);
        temp.put(PROP_NAME_5, PROP_VALUE_5B);
        MAP_B = Collections.unmodifiableMap(temp);
        temp = new HashMap();
        temp.put(PROP_NAME_2, PROP_VALUE_2C);
        temp.put(PROP_NAME_4, PROP_VALUE_4C);
        temp.put(PROP_NAME_6, PROP_VALUE_6C);
        MAP_C = Collections.unmodifiableMap(temp);
        ArrayList<Map> tempList = new ArrayList<Map>(1);
        tempList.add(MAP_A);
        LIST_A = Collections.unmodifiableList(tempList);
        tempList = new ArrayList(1);
        tempList.add(MAP_B);
        tempList = new ArrayList(2);
        tempList.add(MAP_A);
        tempList.add(MAP_B);
        LIST_AB = Collections.unmodifiableList(tempList);
        tempList = new ArrayList(3);
        tempList.add(MAP_A);
        tempList.add(MAP_B);
        tempList.add(MAP_C);
        LIST_ABC = Collections.unmodifiableList(tempList);
    }

    static class Bean {
        private int prop;
        private String prop1;
        private double prop2;
        private List<String> prop3;

        Bean() {
        }

        public int getProp() {
            return this.prop;
        }

        public void setProp(int prop) {
            this.prop = prop;
        }

        public String getProp1() {
            return this.prop1;
        }

        public void setProp1(String prop1) {
            this.prop1 = prop1;
        }

        public double getProp2() {
            return this.prop2;
        }

        public void setProp2(double prop2) {
            this.prop2 = prop2;
        }

        public List<String> getProp3() {
            return this.prop3;
        }

        public void setProp3(List<String> prop3) {
            this.prop3 = prop3;
        }
    }
}

