/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.Serializer;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.PhysicalInfo;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.TeiidComponentException;

public class TestBufferFrontedFileStoreCache {
    @Test
    public void testAddGetMultiBlock() throws Exception {
        BufferFrontedFileStoreCache cache = TestBufferFrontedFileStoreCache.createLayeredCache(0x4000000, 0x4000000);
        CacheEntry ce = new CacheEntry(Long.valueOf(2L));
        SimpleSerializer s = new SimpleSerializer();
        cache.createCacheGroup(s.getId());
        Integer cacheObject = 2;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(cache, 2L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        ce = new CacheEntry(Long.valueOf(3L));
        cacheObject = 80000;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(cache, 3L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        ce = new CacheEntry(Long.valueOf(4L));
        cacheObject = 60000;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(cache, 4L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        cache.removeCacheGroup(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)cache.getDataBlocksInUse());
        Assert.assertEquals((long)0L, (long)cache.getInodesInUse());
        ce = new CacheEntry(Long.valueOf(3L));
        cache.createCacheGroup(s.getId());
        cacheObject = 5000000;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(cache, 3L, s);
        Assert.assertEquals((Object)cacheObject, (Object)ce.getObject());
        cache.removeCacheGroup(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)cache.getDataBlocksInUse());
        Assert.assertEquals((long)0L, (long)cache.getInodesInUse());
        ce = new CacheEntry(Long.valueOf(3L));
        cache.createCacheGroup(s.getId());
        cacheObject = 500000000;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        ce = TestBufferFrontedFileStoreCache.get(cache, 3L, s);
        Assert.assertNull((Object)ce);
        cache.removeCacheGroup(Long.valueOf(1L));
        Assert.assertEquals((long)0L, (long)cache.getDataBlocksInUse());
        Assert.assertEquals((long)0L, (long)cache.getInodesInUse());
    }

    private static CacheEntry get(BufferFrontedFileStoreCache cache, Long oid, Serializer<Integer> s) throws TeiidComponentException {
        PhysicalInfo o = cache.lockForLoad(oid, s);
        CacheEntry ce = cache.get(o, oid, new WeakReference<Serializer<Integer>>(s));
        cache.unlockForLoad(o);
        return ce;
    }

    @Test
    public void testEviction() throws Exception {
        BufferFrontedFileStoreCache cache = TestBufferFrontedFileStoreCache.createLayeredCache(32768, 32768);
        Assert.assertEquals((long)3L, (long)cache.getMaxMemoryBlocks());
        CacheEntry ce = new CacheEntry(Long.valueOf(2L));
        SimpleSerializer s = new SimpleSerializer();
        WeakReference<SimpleSerializer> ref = new WeakReference<SimpleSerializer>(s);
        ce.setSerializer(ref);
        cache.createCacheGroup(s.getId());
        Integer cacheObject = 5000;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        ce = new CacheEntry(Long.valueOf(3L));
        ce.setSerializer(ref);
        cacheObject = 5001;
        ce.setObject((Object)cacheObject);
        cache.addToCacheGroup(s.getId(), ce.getId());
        cache.add(ce, (Serializer)s);
        Assert.assertTrue((cache.getDataBlocksInUse() < 4 ? 1 : 0) != 0);
        Assert.assertTrue((cache.getInodesInUse() < 2 ? 1 : 0) != 0);
        ce = TestBufferFrontedFileStoreCache.get(cache, 2L, s);
        Assert.assertEquals((Object)5000, (Object)ce.getObject());
        ce = TestBufferFrontedFileStoreCache.get(cache, 3L, s);
        Assert.assertEquals((Object)5001, (Object)ce.getObject());
    }

    private static BufferFrontedFileStoreCache createLayeredCache(int bufferSpace, int objectSize) throws TeiidComponentException {
        BufferFrontedFileStoreCache fsc = new BufferFrontedFileStoreCache();
        fsc.setMemoryBufferSpace((long)bufferSpace);
        fsc.setMaxStorageObjectSize(objectSize);
        fsc.setDirect(false);
        SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)new MemoryStorageManager());
        ssm.setMaxFileSizeDirect(131072L);
        fsc.setStorageManager((StorageManager)ssm);
        fsc.initialize();
        return fsc;
    }

    @Test
    public void testSizeIndex() throws Exception {
        PhysicalInfo info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0);
        info.setSize(8192);
        Assert.assertEquals((long)0L, (long)info.sizeIndex);
        info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0);
        info.setSize(8193);
        Assert.assertEquals((long)1L, (long)info.sizeIndex);
        info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0);
        info.setSize(32770);
        Assert.assertEquals((long)3L, (long)info.sizeIndex);
    }

    @Test(expected=Exception.class)
    public void testSizeChanged() throws Exception {
        PhysicalInfo info = new PhysicalInfo(Long.valueOf(1L), Long.valueOf(1L), -1, 0);
        info.setSize(8192);
        Assert.assertEquals((long)0L, (long)info.sizeIndex);
        info.setSize(8193);
    }

    private static final class SimpleSerializer
    implements Serializer<Integer> {
        private SimpleSerializer() {
        }

        public Integer deserialize(ObjectInput ois) throws IOException, ClassNotFoundException {
            Integer result = ois.readInt();
            for (int i = 0; i < result; ++i) {
                Assert.assertEquals((long)i, (long)ois.readInt());
            }
            return result;
        }

        public Long getId() {
            return 1L;
        }

        public void serialize(Integer obj, ObjectOutput oos) throws IOException {
            oos.writeInt(obj);
            for (int i = 0; i < obj; ++i) {
                oos.writeInt(i);
            }
        }

        public boolean useSoftCache() {
            return false;
        }
    }
}

