/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.multisource.MultiSourceCapabilitiesFinder;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.dqp.internal.process.multisource.MultiSourcePlanToProcessConverter;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempCapabilitiesFinder;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestMultiSourcePlanToProcessConverter {
    private static final boolean DEBUG = false;

    public void helpTestMultiSourcePlan(QueryMetadataInterface metadata, String userSql, String multiModel, int sourceCount, ProcessorDataManager dataMgr, List<?>[] expectedResults, VDBMetaData vdb) throws Exception {
        this.helpTestMultiSourcePlan(metadata, userSql, multiModel, sourceCount, dataMgr, expectedResults, vdb, null);
    }

    public void helpTestMultiSourcePlan(QueryMetadataInterface metadata, String userSql, String multiModel, int sourceCount, ProcessorDataManager dataMgr, List<?>[] expectedResults, VDBMetaData vdb, List<?> params) throws Exception {
        Set multiSourceModels = vdb.getMultiSourceModelNames();
        for (String model : multiSourceModels) {
            int x;
            char sourceID = 'a';
            ModelMetaData m = vdb.getModel(model);
            int i = x = m.getSourceNames().size();
            while (i < sourceCount) {
                m.addSourceMapping("" + sourceID, "translator", null);
                ++i;
                sourceID = (char)(sourceID + '\u0001');
            }
        }
        MultiSourceMetadataWrapper wrapper = new MultiSourceMetadataWrapper(metadata, multiSourceModels);
        wrapper = new TempMetadataAdapter((QueryMetadataInterface)wrapper, new TempMetadataStore());
        DQPWorkContext dqpContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)wrapper, vdb);
        AnalysisRecord analysis = new AnalysisRecord(false, false);
        Command command = TestResolver.helpResolve(userSql, (QueryMetadataInterface)wrapper);
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)wrapper, null);
        FakeCapabilitiesFinder fakeFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setFunctionSupport("concat", true);
        fakeFinder.addCapabilities(multiModel, (SourceCapabilities)bsc);
        MultiSourceCapabilitiesFinder finder = new MultiSourceCapabilitiesFinder((CapabilitiesFinder)fakeFinder, (Collection)multiSourceModels);
        finder = new TempCapabilitiesFinder((CapabilitiesFinder)finder);
        IDGenerator idGenerator = new IDGenerator();
        Properties props = new Properties();
        CommandContext context = new CommandContext((Object)"0", "test", "user", null, vdb.getName(), vdb.getVersion(), props, false);
        context.setPlanToProcessConverter((PlanToProcessConverter)new MultiSourcePlanToProcessConverter((QueryMetadataInterface)wrapper, idGenerator, analysis, (CapabilitiesFinder)finder, multiSourceModels, dqpContext, context));
        ProcessorPlan plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)wrapper, (IDGenerator)idGenerator, (CapabilitiesFinder)finder, (AnalysisRecord)analysis, (CommandContext)context);
        if (params != null) {
            TestProcessor.setParameterValues(params, command, context);
        }
        TestProcessor.helpProcess(plan, context, dataMgr, expectedResults);
    }

    @Test
    public void testNoReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'bogus'";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'bogus'", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'a'";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList(null, null, "a")};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(false);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = 'a'", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testPreparedReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = ?";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList(null, null, "a")};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(false);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys WHERE SOURCE_NAME = ?", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB(), Arrays.asList("a"));
    }

    @Test
    public void testMultiReplacement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT * FROM MultiModel.Phys";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(null, null, "a"), Arrays.asList(null, null, "b"), Arrays.asList(null, null, "c")};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT * FROM MultiModel.Phys", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiReplacementWithOrderBy() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT a, b, source_name || a FROM MultiModel.Phys order by a";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("e", "z", "be"), Arrays.asList("f", "z", "bf"), Arrays.asList("x", "z", "ax"), Arrays.asList("y", "z", "ay")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('a', g_0.a) FROM MultiModel.Phys AS g_0", new List[]{Arrays.asList("y", "z", "ay"), Arrays.asList("x", "z", "ax")});
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('b', g_0.a) FROM MultiModel.Phys AS g_0", new List[]{Arrays.asList("e", "z", "be"), Arrays.asList("f", "z", "bf")});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT a, b, source_name || a FROM MultiModel.Phys order by a", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiReplacementWithLimit() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT distinct a, b, source_name || a FROM MultiModel.Phys order by a limit 1";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("e", "z", "be")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('a', g_0.a) FROM MultiModel.Phys AS g_0", new List[]{Arrays.asList("y", "z", "ay"), Arrays.asList("x", "z", "ax")});
        dataMgr.addData("SELECT g_0.a, g_0.b, concat('b', g_0.a) FROM MultiModel.Phys AS g_0", new List[]{Arrays.asList("e", "z", "be"), Arrays.asList("f", "z", "bf")});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT distinct a, b, source_name || a FROM MultiModel.Phys order by a limit 1", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiDependentJoin() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "SELECT a.a FROM MultiModel.Phys a inner join MultiModel.Phys b makedep on (a.a = b.a) order by a";
        String multiModel = "MultiModel";
        int sources = 2;
        List[] expected = new List[]{Arrays.asList("x"), Arrays.asList("x"), Arrays.asList("x"), Arrays.asList("x"), Arrays.asList("y"), Arrays.asList("y"), Arrays.asList("y"), Arrays.asList("y")};
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0", new List[]{Arrays.asList("x"), Arrays.asList("y")});
        dataMgr.addData("SELECT g_0.a FROM MultiModel.Phys AS g_0 WHERE g_0.a IN ('x', 'y')", new List[]{Arrays.asList("x"), Arrays.asList("y")});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "SELECT a.a FROM MultiModel.Phys a inner join MultiModel.Phys b makedep on (a.a = b.a) order by a", "MultiModel", 2, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacementInDynamicCommand() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec Virt.sq1('a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(null, null)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec Virt.sq1('a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testSingleReplacementInDynamicCommandNullValue() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec Virt.sq1(null)";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec Virt.sq1(null)", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testMultiUpdateAll() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "update MultiModel.Phys set a = '1' where b = 'z'";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(3)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("UPDATE MultiModel.Phys SET a = '1' WHERE b = 'z'", new List[]{Arrays.asList(1)});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "update MultiModel.Phys set a = '1' where b = 'z'", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testInsertMatching() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(1)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("INSERT INTO MultiModel.Phys (a) VALUES ('a')", new List[]{Arrays.asList(1)});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testInsertNotMatching() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'x')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(0)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO MultiModel.Phys(a, SOURCE_NAME) VALUES ('a', 'x')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testInsertAll() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO MultiModel.Phys(a) VALUES ('a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(3)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("INSERT INTO MultiModel.Phys (a) VALUES ('a')", new List[]{Arrays.asList(1)});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO MultiModel.Phys(a) VALUES ('a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testProcedure() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec MultiModel.proc('b', 'a')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(1)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("EXEC MultiModel.proc('b')", new List[]{Arrays.asList(1)});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec MultiModel.proc('b', 'a')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testProcedureAll() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "exec MultiModel.proc(\"in\"=>'b')";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("EXEC MultiModel.proc('b')", new List[]{Arrays.asList(1)});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "exec MultiModel.proc(\"in\"=>'b')", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    @Test
    public void testTempInsert() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleMultiBinding();
        String userSql = "INSERT INTO #x select * from MultiModel.Phys";
        String multiModel = "MultiModel";
        int sources = 3;
        List[] expected = new List[]{Arrays.asList(3)};
        MultiSourceDataManager dataMgr = new MultiSourceDataManager();
        dataMgr.setMustRegisterCommands(true);
        dataMgr.addData("SELECT g_0.a, g_0.b FROM MultiModel.Phys AS g_0", new List[]{Arrays.asList("a", "b")});
        this.helpTestMultiSourcePlan((QueryMetadataInterface)metadata, "INSERT INTO #x select * from MultiModel.Phys", "MultiModel", 3, dataMgr, expected, RealMetadataFactory.exampleMultiBindingVDB());
    }

    private final class MultiSourceDataManager
    extends HardcodedDataManager {
        public MultiSourceDataManager() {
            this.setMustRegisterCommands(false);
        }

        @Override
        public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException {
            Assert.assertNotNull((Object)connectorBindingId);
            Collection elements = ElementCollectorVisitor.getElements((LanguageObject)command, (boolean)true, (boolean)true);
            for (ElementSymbol symbol : elements) {
                if (!(symbol.getMetadataID() instanceof MultiSourceElement)) continue;
                Assert.fail((String)"Query Contains a MultiSourceElement -- MultiSource expansion did not happen");
            }
            return super.registerRequest(context, command, modelName, connectorBindingId, nodeID, limit);
        }
    }
}

