/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.eval.SecurityFunctionEvaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestSecurityFunctions
extends TestCase {
    public void testHasRoleWithoutService() throws Exception {
        String sql = "select pm1.g1.e2 from pm1.g1 where true = hasRole('data', pm1.g1.e1)";
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", new List[]{Arrays.asList("fooRole", new Integer(0))});
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void testHasRoleWithService() throws Exception {
        String sql = "select pm1.g1.e2 from pm1.g1 where true = hasRole('data', pm1.g1.e1)";
        List[] expected = new List[]{};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", new List[]{Arrays.asList("fooRole", new Integer(0))});
        CommandContext context = new CommandContext();
        context.setSecurityFunctionEvaluator(new SecurityFunctionEvaluator(){

            public boolean hasRole(String roleType, String roleName) throws TeiidComponentException {
                return false;
            }
        });
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), context);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }
}

