/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class TestSetQuery
extends TestCase {
    public TestSetQuery(String name) {
        super(name);
    }

    public static final SetQuery sample1() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        q1.setFrom(from);
        Query q2 = new Query();
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("y"));
        q2.setSelect(select);
        from = new From();
        from.addGroup(new GroupSymbol("h"));
        q2.setFrom(from);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION);
        sq.setLeftQuery((QueryCommand)q1);
        sq.setRightQuery((QueryCommand)q2);
        return sq;
    }

    public static final SetQuery sample2() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        q1.setFrom(from);
        Query q2 = new Query();
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("y"));
        q2.setSelect(select);
        from = new From();
        from.addGroup(new GroupSymbol("h"));
        q2.setFrom(from);
        SetQuery sq = new SetQuery(SetQuery.Operation.INTERSECT);
        sq.setAll(false);
        sq.setLeftQuery((QueryCommand)q1);
        sq.setRightQuery((QueryCommand)q2);
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((SingleElementSymbol)new ElementSymbol("x"));
        sq.setOrderBy(orderBy);
        return sq;
    }

    public static final Query sample3() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("xml"));
        q1.setSelect(select);
        q1.setIsXML(true);
        From from = new From();
        from.addGroup(new GroupSymbol("xmltest.doc1"));
        q1.setFrom(from);
        return q1;
    }

    public void test1() {
        SetQuery sq = TestSetQuery.sample1();
        TestSetQuery.assertEquals((String)"Union string doesn't match expected: ", (String)"SELECT x FROM g UNION ALL SELECT y FROM h", (String)sq.toString());
    }

    public void test2() {
        Query q1 = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("x"));
        q1.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        q1.setFrom(from);
        Query q2 = new Query();
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("y"));
        q2.setSelect(select);
        from = new From();
        from.addGroup(new GroupSymbol("h"));
        q2.setFrom(from);
        SetQuery sq = new SetQuery(SetQuery.Operation.INTERSECT);
        sq.setAll(false);
        sq.setLeftQuery((QueryCommand)q1);
        sq.setRightQuery((QueryCommand)q2);
        TestSetQuery.assertEquals((String)"Query combiner string doesn't match expected: ", (String)"SELECT x FROM g INTERSECT SELECT y FROM h", (String)sq.toString());
    }

    public void test3() {
        SetQuery sq = TestSetQuery.sample2();
        TestSetQuery.assertEquals((String)"Query combiner string doesn't match expected: ", (String)"SELECT x FROM g INTERSECT SELECT y FROM h ORDER BY x", (String)sq.toString());
    }

    public void testSelfEquivalence() {
        SetQuery s1 = TestSetQuery.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        SetQuery s1 = TestSetQuery.sample1();
        SetQuery s1a = TestSetQuery.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        SetQuery s1 = TestSetQuery.sample1();
        SetQuery s2 = TestSetQuery.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testQuery() {
        Query q = TestSetQuery.sample3();
        ArrayList<ElementSymbol> projList = new ArrayList<ElementSymbol>();
        projList.add(new ElementSymbol("xml"));
        TestSetQuery.assertEquals((String)"result is not as expected.", projList, (Object)q.getProjectedSymbols());
    }
}

